/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.worker;

import org.eclipse.core.runtime.IPath;
import org.eclipse.gyrex.jobs.IJobContext;
import org.slf4j.MDC;

public class JobLogHelper {
    private static final String MDC_KEY_CONTEXT_PATH = "gyrex.contextPath";
    private static final String MDC_KEY_JOB_ID = "gyrex.jobId";

    public static void clearMdc() {
        MDC.remove((String)MDC_KEY_JOB_ID);
        MDC.remove((String)MDC_KEY_CONTEXT_PATH);
    }

    public static void setupMdc(IJobContext jobContext) {
        MDC.put((String)MDC_KEY_JOB_ID, (String)jobContext.getJobId());
        MDC.put((String)MDC_KEY_CONTEXT_PATH, (String)jobContext.getContext().getContextPath().toString());
    }

    public static void setupMdc(String jobId, IPath contextPath) {
        MDC.put((String)MDC_KEY_JOB_ID, (String)jobId);
        MDC.put((String)MDC_KEY_CONTEXT_PATH, (String)contextPath.toString());
    }

    private JobLogHelper() {
    }
}

