/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.worker;

import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gyrex.cloud.services.locking.IExclusiveLock;
import org.eclipse.gyrex.cloud.services.locking.ILockMonitor;
import org.eclipse.gyrex.cloud.services.locking.ILockService;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.jobs.JobState;
import org.eclipse.gyrex.jobs.internal.JobsActivator;
import org.eclipse.gyrex.jobs.internal.JobsDebug;
import org.eclipse.gyrex.jobs.internal.manager.IJobStateWatch;
import org.eclipse.gyrex.jobs.internal.manager.JobImpl;
import org.eclipse.gyrex.jobs.internal.manager.JobManagerImpl;
import org.eclipse.gyrex.jobs.internal.worker.JobContext;
import org.eclipse.gyrex.jobs.internal.worker.JobLogHelper;
import org.eclipse.gyrex.jobs.manager.IJobManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JobStateSynchronizer
implements IJobChangeListener,
IJobStateWatch,
ILockMonitor<IExclusiveLock> {
    private static final Logger LOG = LoggerFactory.getLogger(JobStateSynchronizer.class);
    private final Job realJob;
    private final JobContext jobContext;
    private IExclusiveLock lock;

    public JobStateSynchronizer(Job realJob, JobContext jobContext) {
        this.realJob = realJob;
        this.jobContext = jobContext;
    }

    public void aboutToRun(IJobChangeEvent event) {
        try {
            JobLogHelper.setupMdc(this.jobContext);
            JobManagerImpl jobManager = this.getJobManager();
            String jobId = this.getJobId();
            JobImpl job = jobManager.getJob(jobId);
            if (job.getState() != JobState.WAITING) {
                this.cancelRealJob();
                return;
            }
            String lockId = this.getJobParameter().get("gyrex.jobs.lockId");
            if (lockId != null && !this.acquireLock(lockId)) {
                LOG.warn("Failed acquiring lock {} for job {}. Job execution will be delayed.", (Object)lockId, (Object)this.getJobId());
                this.cancelRealJob();
                if (!Thread.interrupted()) {
                    this.realJob.schedule(10000L);
                }
            }
        }
        finally {
            JobLogHelper.clearMdc();
        }
    }

    private synchronized boolean acquireLock(String lockId) {
        if (this.lock != null && !this.lock.isValid()) {
            return true;
        }
        if (JobsDebug.workerEngine) {
            LOG.debug("Acquiring lock {} for job {}...", (Object)lockId, (Object)this.getJobId());
        }
        try {
            this.lock = this.getLockService().acquireExclusiveLock(lockId, (ILockMonitor)this, 2000L);
            return true;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (TimeoutException timeoutException) {
            return false;
        }
        catch (Exception e) {
            LOG.error("Exception while acquiring lock {} for job {}. {}", new Object[]{lockId, this.getJobId(), ExceptionUtils.getRootCauseMessage((Throwable)e), e});
            return false;
        }
    }

    public void awake(IJobChangeEvent event) {
    }

    private void cancelRealJob() {
        if (this.realJob.cancel()) {
            LOG.info("Job {} has been canceled.", (Object)this.getJobId());
        } else {
            LOG.info("Job {} cancelation has been requested. However, it is currently running and thus may not respond to cancelation.", (Object)this.getJobId());
        }
    }

    public void done(IJobChangeEvent event) {
        try {
            try {
                JobLogHelper.setupMdc(this.jobContext);
                if (this.lock != null) {
                    this.releaseLock();
                }
                this.getJobManager().setInactive(this.getJobId());
                this.updateJobState(null, JobState.NONE, null);
                this.getJobManager().setResult(this.getJobId(), this.getJobParameter(), event.getResult(), System.currentTimeMillis());
            }
            catch (Exception e) {
                LOG.error("Error updating job {} (with result {}): {}", new Object[]{this.getJobId(), event.getResult(), ExceptionUtils.getRootCauseMessage((Throwable)e), e});
                JobLogHelper.clearMdc();
            }
        }
        finally {
            JobLogHelper.clearMdc();
        }
    }

    private String getJobId() {
        return this.jobContext.getJobId();
    }

    JobManagerImpl getJobManager() {
        return (JobManagerImpl)this.getRuntimeContext().get(IJobManager.class);
    }

    private Map<String, String> getJobParameter() {
        return this.jobContext.getParameter();
    }

    private ILockService getLockService() {
        return (ILockService)JobsActivator.getInstance().getService(ILockService.class);
    }

    private IRuntimeContext getRuntimeContext() {
        return this.jobContext.getContext();
    }

    @Override
    public void jobStateChanged(String jobId) {
        JobImpl job = this.getJobManager().getJob(this.getJobId());
        JobState state = job.getState();
        if (state == JobState.ABORTING) {
            this.cancelRealJob();
        }
    }

    public void lockAcquired(IExclusiveLock lock) {
    }

    public void lockLost(IExclusiveLock lock) {
        LOG.warn("Lost lock {} for job {}. An attempt will be made to cancel a running job instance.", (Object)lock.getId(), (Object)this.getJobId());
        this.cancelRealJob();
    }

    public void lockReleased(IExclusiveLock lock) {
    }

    public void lockSuspended(IExclusiveLock lock) {
    }

    private synchronized void releaseLock() {
        if (this.lock != null) {
            if (JobsDebug.workerEngine) {
                LOG.debug("Releasing lock {} for job {}...", (Object)this.lock.getId(), (Object)this.getJobId());
            }
            try {
                this.lock.release();
            }
            catch (Exception exception) {}
            this.lock = null;
        }
    }

    public void running(IJobChangeEvent event) {
        try {
            JobLogHelper.setupMdc(this.jobContext);
            this.updateJobState(JobState.WAITING, JobState.RUNNING, this);
        }
        catch (Exception e) {
            LOG.error("Error updating job state {} (with result {}): {}", new Object[]{this.getJobId(), event.getResult(), ExceptionUtils.getRootCauseMessage((Throwable)e), e});
        }
    }

    public void scheduled(IJobChangeEvent event) {
        try {
            try {
                JobLogHelper.setupMdc(this.jobContext);
                this.getJobManager().setActive(this.getJobId());
                this.updateJobState(null, JobState.WAITING, null);
            }
            catch (Exception e) {
                LOG.error("Error updating job {}: {}", new Object[]{this.getJobId(), ExceptionUtils.getRootCauseMessage((Throwable)e), e});
                JobLogHelper.clearMdc();
            }
        }
        finally {
            JobLogHelper.clearMdc();
        }
    }

    public void setJobActive() {
        try {
            if (JobsDebug.workerEngine) {
                LOG.debug("Activating job {}...", (Object)this.getJobId());
            }
            this.getJobManager().setActive(this.getJobId());
        }
        catch (Exception e) {
            LOG.error("Error updating job {}: {}", new Object[]{this.getJobId(), ExceptionUtils.getRootCauseMessage((Throwable)e), e});
        }
    }

    public void setJobInactive() {
        try {
            if (JobsDebug.workerEngine) {
                LOG.debug("Inactivating job {}...", (Object)this.getJobId());
            }
            this.getJobManager().setInactive(this.getJobId());
        }
        catch (Exception e) {
            LOG.error("Error updating job {}: {}", new Object[]{this.getJobId(), ExceptionUtils.getRootCauseMessage((Throwable)e), e});
        }
    }

    public void sleeping(IJobChangeEvent event) {
    }

    private void updateJobState(JobState expected, JobState state, IJobStateWatch jobStateWatch) {
        try {
            JobImpl job;
            if (!this.getJobManager().setJobState(this.getJobId(), expected, state, jobStateWatch) && (job = this.getJobManager().getJob(this.getJobId())) != null && job.getState() != state) {
                LOG.error("Unable to update job {} from {} to {}. The jobs current state is {}.", new Object[]{this.getJobId(), expected != null ? "state " + (Object)((Object)expected) : "any state", state, job.getState()});
            }
        }
        catch (Exception e) {
            LOG.error("Error updating job {} from {} to {}: {}", new Object[]{this.getJobId(), expected != null ? "state " + (Object)((Object)expected) : "any state", state, ExceptionUtils.getRootCauseMessage((Throwable)e), e});
        }
    }
}

