/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.p2.internal;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.p2.internal.P2Activator;
import org.eclipse.gyrex.p2.internal.P2Debug;
import org.eclipse.gyrex.p2.internal.installer.PackageScanner;
import org.eclipse.gyrex.p2.internal.packages.IPackageManager;
import org.eclipse.gyrex.p2.internal.packages.InstallableUnitReference;
import org.eclipse.gyrex.p2.internal.packages.PackageDefinition;
import org.eclipse.gyrex.p2.internal.repositories.IRepositoryDefinitionManager;
import org.eclipse.gyrex.p2.internal.repositories.RepositoryDefinition;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;

public class SoftwareConsoleCommands
implements CommandProvider {
    static final Map<String, Command> commands = new TreeMap<String, Command>();

    static {
        commands.put("ls", new ListCommand());
        commands.put("addRepo", new Command("<id> <uri> - adds a repository"){

            @Override
            public void execute(IRepositoryDefinitionManager repoManager, IPackageManager packageManager, CommandInterpreter ci) throws Exception {
                URI location;
                String id = ci.nextArgument();
                if (!IdHelper.isValidId((String)id)) {
                    this.printInvalidArgs("invalid repo id", ci);
                    return;
                }
                String uri = ci.nextArgument();
                if (uri == null) {
                    this.printInvalidArgs("uri is missing", ci);
                    return;
                }
                try {
                    location = new URI(uri);
                }
                catch (URISyntaxException e) {
                    ci.println((Object)("invalid uri:" + e.getMessage()));
                    return;
                }
                RepositoryDefinition repo = new RepositoryDefinition();
                repo.setId(id);
                repo.setLocation(location);
                repoManager.saveRepository(repo);
                ci.println((Object)"repository added");
            }
        });
        commands.put("rmRepo", new Command("<id> - removes a repository"){

            @Override
            public void execute(IRepositoryDefinitionManager repoManager, IPackageManager packageManager, CommandInterpreter ci) throws Exception {
                String id = ci.nextArgument();
                if (!IdHelper.isValidId((String)id)) {
                    this.printInvalidArgs("invalid repo id", ci);
                    return;
                }
                repoManager.removeRepository(id);
                ci.println((Object)"repository removed");
            }
        });
        commands.put("addPkg", new Command("<id> - adds a package"){

            @Override
            public void execute(IRepositoryDefinitionManager repoManager, IPackageManager packageManager, CommandInterpreter ci) throws Exception {
                String id = ci.nextArgument();
                if (!IdHelper.isValidId((String)id)) {
                    this.printInvalidArgs("invalid package id", ci);
                    return;
                }
                PackageDefinition packageDefinition = new PackageDefinition();
                packageDefinition.setId(id);
                packageManager.savePackage(packageDefinition);
                ci.println((Object)"package added");
            }
        });
        commands.put("rmPkg", new Command("<id> - removes a package"){

            @Override
            public void execute(IRepositoryDefinitionManager repoManager, IPackageManager packageManager, CommandInterpreter ci) throws Exception {
                String id = ci.nextArgument();
                if (!IdHelper.isValidId((String)id)) {
                    this.printInvalidArgs("invalid package id", ci);
                    return;
                }
                packageManager.removePackage(id);
                ci.println((Object)"package removed");
            }
        });
        commands.put("addIU2Pkg", new Command("<packageId> <installableUnitId> [<installUnitVersion>] - adds an installable unit to a package"){

            @Override
            public void execute(IRepositoryDefinitionManager repoManager, IPackageManager packageManager, CommandInterpreter ci) throws Exception {
                String id = ci.nextArgument();
                if (!IdHelper.isValidId((String)id)) {
                    this.printInvalidArgs("invalid package id", ci);
                    return;
                }
                PackageDefinition packageDefinition = packageManager.getPackage(id);
                if (packageDefinition == null) {
                    ci.println((Object)"package not found");
                    return;
                }
                if (packageManager.isMarkedForInstall(packageDefinition)) {
                    ci.println((Object)"Package already rolled-out! Please create new package for updates or revoke package first.");
                    return;
                }
                InstallableUnitReference iu = new InstallableUnitReference();
                String iuId = ci.nextArgument();
                if (!IdHelper.isValidId((String)iuId)) {
                    this.printInvalidArgs("invalid installable unit id", ci);
                    return;
                }
                iu.setId(iuId);
                String iuVersion = ci.nextArgument();
                if (iuVersion != null) {
                    try {
                        iu.setVersion(Version.create((String)iuVersion));
                    }
                    catch (IllegalArgumentException e) {
                        this.printInvalidArgs("invalid installable unit version: " + e.getMessage(), ci);
                        return;
                    }
                }
                packageDefinition.addComponentToInstall(iu);
                packageManager.savePackage(packageDefinition);
                ci.println((Object)"package updated");
            }
        });
        commands.put("rollout", new Command("<packageId> - rolls out a package"){

            @Override
            public void execute(IRepositoryDefinitionManager repoManager, IPackageManager packageManager, CommandInterpreter ci) throws Exception {
                String id = ci.nextArgument();
                if (!IdHelper.isValidId((String)id)) {
                    this.printInvalidArgs("invalid package id", ci);
                    return;
                }
                PackageDefinition packageDefinition = packageManager.getPackage(id);
                if (packageDefinition == null) {
                    ci.println((Object)"package not found");
                    return;
                }
                packageManager.markedForInstall(packageDefinition);
                ci.println((Object)"package marked for rollout");
            }
        });
        commands.put("revoke", new Command("<packageId> - revokes a package"){

            @Override
            public void execute(IRepositoryDefinitionManager repoManager, IPackageManager packageManager, CommandInterpreter ci) throws Exception {
                String id = ci.nextArgument();
                if (!IdHelper.isValidId((String)id)) {
                    this.printInvalidArgs("invalid package id", ci);
                    return;
                }
                PackageDefinition packageDefinition = packageManager.getPackage(id);
                if (packageDefinition == null) {
                    ci.println((Object)"package not found");
                    return;
                }
                packageManager.markedForUninstall(packageDefinition);
                ci.println((Object)"package revoked");
            }
        });
        commands.put("update", new Command("updated the local node"){

            @Override
            public void execute(IRepositoryDefinitionManager repoManager, IPackageManager packageManager, CommandInterpreter ci) throws Exception {
                PackageScanner packageScanner = PackageScanner.getInstance();
                if (packageScanner.getState() == 4) {
                    ci.println((Object)"update already in progess");
                    return;
                }
                if (!packageScanner.cancel()) {
                    ci.println((Object)"update already in progess; unable to cancel");
                    return;
                }
                boolean wasDebugging = P2Debug.nodeInstallation;
                P2Debug.nodeInstallation = true;
                packageScanner.schedule();
                packageScanner.join();
                P2Debug.nodeInstallation = wasDebugging;
                ci.println((Object)"update finished");
            }
        });
    }

    static void printHelp(CommandInterpreter ci) {
        ci.println((Object)"sw <cmd> [args]");
        for (String cmd : commands.keySet()) {
            ci.println((Object)("\t" + cmd + " " + commands.get(cmd).getHelp()));
        }
    }

    public void _sw(CommandInterpreter ci) throws Exception {
        String command = ci.nextArgument();
        if (command == null) {
            SoftwareConsoleCommands.printHelp(ci);
            return;
        }
        Command cmd = commands.get(command);
        if (cmd == null) {
            ci.println((Object)("ERROR: unknown command " + command));
            SoftwareConsoleCommands.printHelp(ci);
            return;
        }
        IRepositoryDefinitionManager repoManager = null;
        try {
            repoManager = P2Activator.getInstance().getRepositoryManager();
        }
        catch (IllegalStateException illegalStateException) {
            ci.println((Object)"ERROR: Repository manager not available!");
            return;
        }
        IPackageManager packageManager = null;
        try {
            packageManager = P2Activator.getInstance().getPackageManager();
        }
        catch (IllegalStateException illegalStateException) {
            ci.println((Object)"ERROR: Package manager not available!");
            return;
        }
        try {
            cmd.execute(repoManager, packageManager, ci);
        }
        catch (Exception e) {
            if (P2Debug.debug) {
                ci.printStackTrace((Throwable)e);
            }
            ci.println((Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    public String getHelp() {
        StrBuilder help = new StrBuilder(512);
        help.appendln("---Software Commands---");
        help.appendln("\tsw <cmd> [args]");
        for (String cmd : commands.keySet()) {
            help.appendln("\t\t" + cmd + " " + commands.get(cmd).getHelp());
        }
        return help.toString();
    }

    static abstract class Command {
        private final String help;

        public Command(String help) {
            this.help = help;
        }

        public abstract void execute(IRepositoryDefinitionManager var1, IPackageManager var2, CommandInterpreter var3) throws Exception;

        public String getHelp() {
            return this.help;
        }

        protected void printInvalidArgs(String errorMessage, CommandInterpreter ci) {
            ci.println((Object)("ERROR: invalid arguments: " + errorMessage));
            ci.println((Object)("\t" + this.getHelp()));
        }
    }

    private static final class ListCommand
    extends Command {
        private ListCommand() {
            super(" repos|packages [filterString] \t - list repos or packages");
        }

        @Override
        public void execute(IRepositoryDefinitionManager repoManager, IPackageManager packageManager, CommandInterpreter ci) throws Exception {
            String what = ci.nextArgument();
            if (what == null) {
                this.printInvalidArgs("Don't know what to list. Repos? Packages?", ci);
                return;
            }
            String filterString = ci.nextArgument();
            if (StringUtils.startsWithIgnoreCase((String)"repos", (String)what)) {
                Collection<RepositoryDefinition> repos = repoManager.getRepositories();
                for (RepositoryDefinition repo : repos) {
                    if (filterString != null && !StringUtils.contains((String)repo.getId(), (String)filterString) && (repo.getLocation() == null || !StringUtils.contains((String)repo.getLocation().toString(), (String)filterString))) continue;
                    ci.println((Object)String.format("%s [%s]", repo.getId(), repo.toString()));
                }
            } else if (StringUtils.startsWithIgnoreCase((String)"packages", (String)what)) {
                Collection<PackageDefinition> packages = packageManager.getPackages();
                for (PackageDefinition pkdefinition : packages) {
                    if (filterString != null && !StringUtils.contains((String)pkdefinition.getId(), (String)filterString)) continue;
                    ci.println((Object)String.format("%s [%s]", pkdefinition.getId(), pkdefinition.toString()));
                }
            } else {
                this.printInvalidArgs("repos|packages expected", ci);
                return;
            }
        }
    }
}

