/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.solr.internal;

import java.io.File;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.eclipse.gyrex.common.runtime.BaseBundleActivator;
import org.eclipse.gyrex.persistence.solr.internal.EmbeddedSolrServerApplication;
import org.eclipse.gyrex.persistence.solr.internal.SolrDebug;
import org.osgi.framework.BundleContext;

public class SolrActivator
extends BaseBundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.gyrex.persistence.solr";
    private static final AtomicReference<SolrActivator> instance = new AtomicReference();

    public static String getEmbeddedSolrCoreName(String repositoryId) {
        return repositoryId;
    }

    public static SolrActivator getInstance() {
        return instance.get();
    }

    public SolrActivator() {
        super(PLUGIN_ID);
    }

    public void createEmbeddedCore(String coreName) throws Exception {
        CoreContainer coreContainer = this.getEmbeddedCoreContainer();
        if (coreContainer == null) {
            throw new IllegalStateException("no coreContainer");
        }
        SolrCore core = coreContainer.getCore(coreName);
        try {
            if (core != null) {
                throw new IllegalStateException(String.format("core '%s' already exists", coreName));
            }
            EmbeddedSolrServer adminServer = new EmbeddedSolrServer(coreContainer, "admin");
            CoreAdminRequest.createCore((String)coreName, (String)coreName, (SolrServer)adminServer);
        }
        finally {
            if (core != null) {
                core.close();
            }
        }
    }

    protected void doStart(BundleContext context) throws Exception {
        instance.set(this);
    }

    protected void doStop(BundleContext context) throws Exception {
        instance.set(null);
    }

    protected Class getDebugOptions() {
        return SolrDebug.class;
    }

    public CoreContainer getEmbeddedCoreContainer() {
        return EmbeddedSolrServerApplication.coreContainerRef.get();
    }

    public File getEmbeddedSolrBase() {
        return EmbeddedSolrServerApplication.solrBase;
    }

    public File getEmbeddedSolrCoreBase(String coreName) {
        File solrBase = EmbeddedSolrServerApplication.solrBase;
        if (solrBase == null) {
            throw new IllegalStateException("no Solr base directory");
        }
        return new File(solrBase, coreName);
    }

    public void unloadEmbeddedCore(String coreName) throws Exception {
        CoreContainer coreContainer = this.getEmbeddedCoreContainer();
        if (coreContainer == null) {
            throw new IllegalStateException("no coreContainer");
        }
        SolrCore core = coreContainer.getCore(coreName);
        try {
            if (core != null) {
                EmbeddedSolrServer adminServer = new EmbeddedSolrServer(coreContainer, "admin");
                CoreAdminRequest.unloadCore((String)coreName, (SolrServer)adminServer);
            }
        }
        finally {
            if (core != null) {
                core.close();
            }
        }
    }
}

