/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.debug.ui.launchConfigurations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.AppletLaunchConfigurationUtils;
import org.eclipse.jdt.internal.debug.ui.launcher.DebugTypeSelectionDialog;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.internal.debug.ui.launcher.SharedJavaMainTab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class AppletMainTab
extends SharedJavaMainTab {
    private Text fAppletViewerClassText;
    private Button fAppletViewerClassDefaultButton;

    private void createAppletViewerControl(Composite parent) {
        Font font = parent.getFont();
        Group group = SWTFactory.createGroup((Composite)parent, (String)LauncherMessages.AppletMainTab_1, (int)2, (int)1, (int)768);
        Composite comp = SWTFactory.createComposite((Composite)group, (Font)font, (int)2, (int)2, (int)1808, (int)0, (int)0);
        this.fAppletViewerClassText = SWTFactory.createSingleText((Composite)comp, (int)2);
        this.fAppletViewerClassText.addModifyListener((ModifyListener)this.getDefaultListener());
        this.createVerticalSpacer(comp, 1);
        this.fAppletViewerClassDefaultButton = this.createCheckButton(comp, LauncherMessages.AppletMainTab_2);
        this.fAppletViewerClassDefaultButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AppletMainTab.this.handleAppletViewerClassDefaultSelected();
            }
        });
    }

    public void createControl(Composite parent) {
        Composite projComp = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)1808);
        ((GridLayout)projComp.getLayout()).verticalSpacing = 0;
        this.createProjectEditor(projComp);
        this.createVerticalSpacer(projComp, 1);
        this.createMainTypeEditor(projComp, LauncherMessages.appletlauncher_maintab_mainclasslabel_name);
        this.createVerticalSpacer(projComp, 1);
        this.createAppletViewerControl(projComp);
        this.setControl((Control)projComp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IJavaDebugHelpContextIds.LAUNCH_CONFIGURATION_DIALOG_APPLET_MAIN_TAB);
    }

    public Image getImage() {
        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.class_obj.gif");
    }

    public String getName() {
        return LauncherMessages.appletlauncher_maintab_name;
    }

    private void handleAppletViewerClassDefaultSelected() {
        this.setAppletViewerTextEnabledState();
        if (this.isDefaultAppletViewerClassName()) {
            this.fAppletViewerClassText.setText("sun.applet.AppletViewer");
        } else {
            this.fAppletViewerClassText.setText("");
        }
    }

    protected void handleSearchButtonSelected() {
        Object[] scope = null;
        IJavaProject project = this.getJavaProject();
        if (project == null) {
            try {
                scope = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
            }
            catch (JavaModelException e) {
                this.setErrorMessage(e.getMessage());
                return;
            }
        } else {
            scope = new IJavaElement[]{project};
        }
        IType[] types = null;
        try {
            types = AppletLaunchConfigurationUtils.findApplets((IRunnableContext)this.getLaunchConfigurationDialog(), scope);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (InvocationTargetException e) {
            this.setErrorMessage(e.getTargetException().getMessage());
            return;
        }
        DebugTypeSelectionDialog dialog = new DebugTypeSelectionDialog(this.getShell(), types, LauncherMessages.appletlauncher_maintab_selection_applet_dialog_title);
        if (dialog.open() == 1) {
            return;
        }
        Object[] results = dialog.getResult();
        IType type = (IType)results[0];
        if (type != null) {
            this.fMainText.setText(type.getFullyQualifiedName());
            this.fProjText.setText(type.getJavaProject().getElementName());
        }
    }

    private void initializeAppletViewerClass(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_APPLETVIEWER_CLASS, null);
    }

    private void initializeDefaults(IJavaElement javaElement, ILaunchConfigurationWorkingCopy config) {
        this.initializeJavaProject(javaElement, config);
        this.initializeMainTypeAndName(javaElement, config);
        this.initializeAppletViewerClass(config);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        super.initializeFrom(config);
        this.updateMainTypeFromConfig(config);
        this.updateAppletViewerClassNameFromConfig(config);
    }

    private boolean isDefaultAppletViewerClassName() {
        return this.fAppletViewerClassDefaultButton.getSelection();
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String name = this.fProjText.getText().trim();
        if (name.length() > 0 && !ResourcesPlugin.getWorkspace().getRoot().getProject(name).exists()) {
            this.setErrorMessage(LauncherMessages.appletlauncher_maintab_project_error_doesnotexist);
            return false;
        }
        name = this.fMainText.getText().trim();
        if (name.length() == 0) {
            this.setErrorMessage(LauncherMessages.appletlauncher_maintab_type_error_doesnotexist);
            return false;
        }
        name = this.fAppletViewerClassText.getText().trim();
        if (name.length() == 0) {
            this.setErrorMessage(LauncherMessages.AppletMainTab_3);
            return false;
        }
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.fProjText.getText());
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this.fMainText.getText());
        this.mapResources(config);
        String appletViewerClassName = null;
        if (!this.isDefaultAppletViewerClassName() && (appletViewerClassName = this.fAppletViewerClassText.getText().trim()).length() <= 0) {
            appletViewerClassName = null;
        }
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_APPLETVIEWER_CLASS, appletViewerClassName);
    }

    private void setAppletViewerTextEnabledState() {
        if (this.isDefaultAppletViewerClassName()) {
            this.fAppletViewerClassText.setEnabled(false);
        } else {
            this.fAppletViewerClassText.setEnabled(true);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        IJavaElement je = this.getContext();
        if (je != null) {
            this.initializeDefaults(je, config);
        }
    }

    private void updateAppletViewerClassNameFromConfig(ILaunchConfiguration config) {
        String appletViewerClassName = "";
        try {
            appletViewerClassName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_APPLETVIEWER_CLASS, "");
            if (appletViewerClassName.equals("")) {
                this.fAppletViewerClassText.setText("sun.applet.AppletViewer");
                this.fAppletViewerClassDefaultButton.setSelection(true);
            } else {
                this.fAppletViewerClassText.setText(appletViewerClassName);
                this.fAppletViewerClassDefaultButton.setSelection(false);
            }
            this.setAppletViewerTextEnabledState();
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
    }

    public String getId() {
        return "org.eclipse.jdt.debug.ui.appletMainTab";
    }
}

