/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javadocexport;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocOptionsManager;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavadocWriter {
    private static final char PATH_SEPARATOR = '/';
    private final IJavaProject[] fJavaProjects;
    private final IPath fBasePath;

    public JavadocWriter(IPath basePath, IJavaProject[] projects) {
        this.fBasePath = basePath;
        this.fJavaProjects = projects;
    }

    public Element createXML(JavadocOptionsManager store) throws ParserConfigurationException {
        DocumentBuilder docBuilder = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        docBuilder = factory.newDocumentBuilder();
        Document document = docBuilder.newDocument();
        Element project = document.createElement("project");
        document.appendChild(project);
        project.setAttribute("default", "javadoc");
        Element javadocTarget = document.createElement("target");
        project.appendChild(javadocTarget);
        javadocTarget.setAttribute("name", "javadoc");
        Element xmlJavadocDesc = document.createElement("javadoc");
        javadocTarget.appendChild(xmlJavadocDesc);
        if (!store.isFromStandard()) {
            this.xmlWriteDoclet(store, document, xmlJavadocDesc);
        } else {
            this.xmlWriteJavadocStandardParams(store, document, xmlJavadocDesc);
        }
        return xmlJavadocDesc;
    }

    public static void writeDocument(Element javadocElement, String encoding, OutputStream outputStream) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", encoding);
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource source = new DOMSource(javadocElement.getOwnerDocument());
        StreamResult result = new StreamResult(new BufferedOutputStream(outputStream));
        transformer.transform(source, result);
    }

    private void xmlWriteJavadocStandardParams(JavadocOptionsManager store, Document document, Element xmlJavadocDesc) throws DOMException {
        String title;
        String styleSheet;
        String destination = this.getPathString(Path.fromOSString((String)store.getDestination()));
        xmlJavadocDesc.setAttribute(store.DESTINATION, destination);
        xmlJavadocDesc.setAttribute(store.VISIBILITY, store.getAccess());
        String source = store.getSource();
        if (source.length() > 0 && !source.equals("-")) {
            xmlJavadocDesc.setAttribute(store.SOURCE, store.getSource());
        }
        xmlJavadocDesc.setAttribute(store.USE, this.booleanToString(store.getBoolean("use")));
        xmlJavadocDesc.setAttribute(store.NOTREE, this.booleanToString(store.getBoolean("notree")));
        xmlJavadocDesc.setAttribute(store.NONAVBAR, this.booleanToString(store.getBoolean("nonavbar")));
        xmlJavadocDesc.setAttribute(store.NOINDEX, this.booleanToString(store.getBoolean("noindex")));
        xmlJavadocDesc.setAttribute(store.SPLITINDEX, this.booleanToString(store.getBoolean("splitindex")));
        xmlJavadocDesc.setAttribute(store.AUTHOR, this.booleanToString(store.getBoolean("author")));
        xmlJavadocDesc.setAttribute(store.VERSION, this.booleanToString(store.getBoolean("version")));
        xmlJavadocDesc.setAttribute(store.NODEPRECATEDLIST, this.booleanToString(store.getBoolean("nodeprecatedlist")));
        xmlJavadocDesc.setAttribute(store.NODEPRECATED, this.booleanToString(store.getBoolean("nodeprecated")));
        ArrayList<String> packages = new ArrayList<String>();
        ArrayList<String> sourcefiles = new ArrayList<String>();
        this.sortSourceElement(store.getSourceElements(), sourcefiles, packages);
        if (!packages.isEmpty()) {
            xmlJavadocDesc.setAttribute(store.PACKAGENAMES, this.toSeparatedList(packages));
        }
        if (!sourcefiles.isEmpty()) {
            xmlJavadocDesc.setAttribute(store.SOURCEFILES, this.toSeparatedList(sourcefiles));
        }
        xmlJavadocDesc.setAttribute(store.SOURCEPATH, this.getPathString(store.getSourcepath()));
        xmlJavadocDesc.setAttribute(store.CLASSPATH, this.getPathString(store.getClasspath()));
        String overview = store.getOverview();
        if (overview.length() > 0) {
            xmlJavadocDesc.setAttribute(store.OVERVIEW, overview);
        }
        if ((styleSheet = store.getStyleSheet()).length() > 0) {
            xmlJavadocDesc.setAttribute(store.STYLESHEETFILE, styleSheet);
        }
        if ((title = store.getTitle()).length() > 0) {
            xmlJavadocDesc.setAttribute(store.TITLE, title);
        }
        String vmArgs = store.getVMParams();
        String additionalArgs = store.getAdditionalParams();
        if (vmArgs.length() + additionalArgs.length() > 0) {
            String str = String.valueOf(vmArgs) + ' ' + additionalArgs;
            xmlJavadocDesc.setAttribute(store.EXTRAOPTIONS, str);
        }
        String[] hrefs = store.getHRefs();
        int i = 0;
        while (i < hrefs.length) {
            Element links = document.createElement("link");
            xmlJavadocDesc.appendChild(links);
            links.setAttribute(store.HREF, hrefs[i]);
            ++i;
        }
    }

    private void sortSourceElement(IJavaElement[] iJavaElements, List<String> sourcefiles, List<String> packages) {
        int i = 0;
        while (i < iJavaElements.length) {
            IJavaElement element = iJavaElements[i];
            IPath p = element.getResource().getLocation();
            if (p != null) {
                if (element instanceof ICompilationUnit) {
                    String relative = this.getPathString(p);
                    sourcefiles.add(relative);
                } else if (element instanceof IPackageFragment) {
                    packages.add(element.getElementName());
                }
            }
            ++i;
        }
    }

    private String getPathString(IPath[] paths) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < paths.length) {
            if (buf.length() != 0) {
                buf.append(File.pathSeparatorChar);
            }
            buf.append(this.getPathString(paths[i]));
            ++i;
        }
        if (buf.length() == 0) {
            buf.append('.');
        }
        return buf.toString();
    }

    private boolean hasSameDevice(IPath p1, IPath p2) {
        String dev = p1.getDevice();
        if (dev == null) {
            return p2.getDevice() == null;
        }
        return dev.equals(p2.getDevice());
    }

    private String getPathString(IPath fullPath) {
        if (this.fBasePath == null || !this.hasSameDevice(fullPath, this.fBasePath)) {
            return fullPath.toOSString();
        }
        int matchingSegments = this.fBasePath.matchingFirstSegments(fullPath);
        if (this.fBasePath.segmentCount() == matchingSegments) {
            return this.getRelativePath(fullPath, matchingSegments);
        }
        int i = 0;
        while (i < this.fJavaProjects.length) {
            IProject proj = this.fJavaProjects[i].getProject();
            IPath projLoc = proj.getLocation();
            if (projLoc != null && projLoc.segmentCount() <= matchingSegments && projLoc.isPrefixOf(fullPath)) {
                return this.getRelativePath(fullPath, matchingSegments);
            }
            ++i;
        }
        IPath workspaceLoc = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        if (workspaceLoc.segmentCount() <= matchingSegments && workspaceLoc.isPrefixOf(fullPath)) {
            return this.getRelativePath(fullPath, matchingSegments);
        }
        return fullPath.toOSString();
    }

    private String getRelativePath(IPath fullPath, int matchingSegments) {
        StringBuffer res = new StringBuffer();
        int backSegments = this.fBasePath.segmentCount() - matchingSegments;
        while (backSegments > 0) {
            res.append("..");
            res.append('/');
            --backSegments;
        }
        int segCount = fullPath.segmentCount();
        int i = matchingSegments;
        while (i < segCount) {
            if (i > matchingSegments) {
                res.append('/');
            }
            res.append(fullPath.segment(i));
            ++i;
        }
        return res.toString();
    }

    private void xmlWriteDoclet(JavadocOptionsManager store, Document document, Element xmlJavadocDesc) throws DOMException {
        ArrayList<String> packages = new ArrayList<String>();
        ArrayList<String> sourcefiles = new ArrayList<String>();
        this.sortSourceElement(store.getSourceElements(), sourcefiles, packages);
        if (!packages.isEmpty()) {
            xmlJavadocDesc.setAttribute(store.PACKAGENAMES, this.toSeparatedList(packages));
        }
        if (!sourcefiles.isEmpty()) {
            xmlJavadocDesc.setAttribute(store.SOURCEFILES, this.toSeparatedList(sourcefiles));
        }
        xmlJavadocDesc.setAttribute(store.SOURCEPATH, this.getPathString(store.getSourcepath()));
        xmlJavadocDesc.setAttribute(store.CLASSPATH, this.getPathString(store.getClasspath()));
        xmlJavadocDesc.setAttribute(store.VISIBILITY, store.getAccess());
        Element doclet = document.createElement("doclet");
        xmlJavadocDesc.appendChild(doclet);
        doclet.setAttribute(store.NAME, store.getDocletName());
        doclet.setAttribute(store.PATH, store.getDocletPath());
        String str = store.getOverview();
        if (str.length() > 0) {
            xmlJavadocDesc.setAttribute(store.OVERVIEW, str);
        }
        if ((str = store.getAdditionalParams()).length() > 0) {
            xmlJavadocDesc.setAttribute(store.EXTRAOPTIONS, str);
        }
    }

    private String toSeparatedList(List<String> packages) {
        StringBuffer buf = new StringBuffer();
        Iterator<String> iter = packages.iterator();
        int nAdded = 0;
        while (iter.hasNext()) {
            if (nAdded > 0) {
                buf.append(',');
            }
            ++nAdded;
            String curr = iter.next();
            buf.append(curr);
        }
        return buf.toString();
    }

    private String booleanToString(boolean bool) {
        if (bool) {
            return "true";
        }
        return "false";
    }
}

