/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.text.MessageFormat;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.pgm.CLIText;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(common=true, usage="usage_checkout")
class Checkout
extends TextBuiltin {
    @Option(name="-b", usage="usage_createBranchAndCheckout")
    private boolean createBranch = false;
    @Option(name="--force", aliases={"-f"}, usage="usage_forceCheckout")
    private boolean force = false;
    @Argument(required=true, metaVar="metaVar_name", usage="usage_checkout")
    private String name;

    Checkout() {
    }

    protected void run() throws Exception {
        ObjectId head;
        if (this.createBranch && (head = this.db.resolve("HEAD")) == null) {
            throw Checkout.die(CLIText.get().onBranchToBeBorn);
        }
        CheckoutCommand command = new Git(this.db).checkout();
        command.setCreateBranch(this.createBranch);
        command.setName(this.name);
        command.setForce(this.force);
        try {
            String oldBranch = this.db.getBranch();
            Ref ref = command.call();
            if (Repository.shortenRefName((String)ref.getName()).equals(oldBranch)) {
                this.out.println(MessageFormat.format(CLIText.get().alreadyOnBranch, this.name));
                return;
            }
            if (this.createBranch) {
                this.out.println(MessageFormat.format(CLIText.get().switchedToNewBranch, Repository.shortenRefName((String)ref.getName())));
            } else {
                this.out.println(MessageFormat.format(CLIText.get().switchedToBranch, Repository.shortenRefName((String)ref.getName())));
            }
        }
        catch (RefNotFoundException e) {
            this.out.println(MessageFormat.format(CLIText.get().pathspecDidNotMatch, this.name));
        }
        catch (RefAlreadyExistsException e) {
            throw Checkout.die(MessageFormat.format(CLIText.get().branchAlreadyExists, this.name));
        }
    }
}

