/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.pgm.CLIText;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(common=true, usage="usage_MergesTwoDevelopmentHistories")
class Merge
extends TextBuiltin {
    @Option(name="--strategy", aliases={"-s"}, usage="usage_mergeStrategy")
    private String strategyName;
    private MergeStrategy mergeStrategy = MergeStrategy.RESOLVE;
    @Argument(required=true)
    private String ref;

    Merge() {
    }

    protected void run() throws Exception {
        ObjectId src;
        if (this.strategyName != null) {
            this.mergeStrategy = MergeStrategy.get((String)this.strategyName);
            if (this.mergeStrategy == null) {
                throw Merge.die(MessageFormat.format(CLIText.get().unknownMergeStrategy, this.strategyName));
            }
        }
        if ((src = this.db.resolve(this.ref + "^{commit}")) == null) {
            throw Merge.die(MessageFormat.format(CLIText.get().refDoesNotExistOrNoCommit, this.ref));
        }
        Git git = new Git(this.db);
        MergeResult result = git.merge().setStrategy(this.mergeStrategy).include((AnyObjectId)src).call();
        switch (result.getMergeStatus()) {
            case ALREADY_UP_TO_DATE: 
            case FAST_FORWARD: {
                this.out.println(result.getMergeStatus().toString());
                break;
            }
            case CONFLICTING: {
                for (String collidingPath : result.getConflicts().keySet()) {
                    this.out.println(MessageFormat.format(CLIText.get().mergeConflict, collidingPath));
                }
                this.out.println(CLIText.get().mergeFailed);
                break;
            }
            case FAILED: {
                for (Map.Entry entry : result.getFailingPaths().entrySet()) {
                    switch ((ResolveMerger.MergeFailureReason)entry.getValue()) {
                        case DIRTY_WORKTREE: 
                        case DIRTY_INDEX: {
                            this.out.println(CLIText.get().dontOverwriteLocalChanges);
                            this.out.println("        " + (String)entry.getKey());
                            break;
                        }
                        case COULD_NOT_DELETE: {
                            this.out.println(CLIText.get().cannotDeleteFile);
                            this.out.println("        " + (String)entry.getKey());
                        }
                    }
                }
                break;
            }
            case MERGED: {
                this.out.println(MessageFormat.format(CLIText.get().mergeMadeBy, this.mergeStrategy.getName()));
                break;
            }
            case NOT_SUPPORTED: {
                this.out.println(MessageFormat.format(CLIText.get().unsupportedOperation, result.toString()));
            }
        }
    }
}

