/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.util.Map;
import java.util.SortedMap;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefComparator;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.util.RefMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ShowRef
extends TextBuiltin {
    ShowRef() {
    }

    @Override
    protected void run() throws Exception {
        for (Ref r : this.getSortedRefs()) {
            this.show((AnyObjectId)r.getObjectId(), r.getName());
            if (r.getPeeledObjectId() == null) continue;
            this.show((AnyObjectId)r.getPeeledObjectId(), r.getName() + "^{}");
        }
    }

    private Iterable<Ref> getSortedRefs() {
        Map all = this.db.getAllRefs();
        if (all instanceof RefMap || all instanceof SortedMap && ((SortedMap)all).comparator() == null) {
            return all.values();
        }
        return RefComparator.sort(all.values());
    }

    private void show(AnyObjectId id, String name) {
        this.out.print(id.name());
        this.out.print('\t');
        this.out.print(name);
        this.out.println();
    }
}

