/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm.debug;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.pgm.TextBuiltin;

class ShowDirCache
extends TextBuiltin {
    ShowDirCache() {
    }

    protected void run() throws Exception {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd,HH:mm:ss.SSS");
        DirCache cache = this.db.readDirCache();
        for (int i = 0; i < cache.getEntryCount(); ++i) {
            DirCacheEntry ent = cache.getEntry(i);
            FileMode mode = FileMode.fromBits((int)ent.getRawMode());
            int len = ent.getLength();
            Date mtime = new Date(ent.getLastModified());
            int stage = ent.getStage();
            this.out.print(mode);
            this.out.format(" %6d", len);
            this.out.print(' ');
            this.out.print(fmt.format(mtime));
            this.out.print(' ');
            this.out.print(ent.getObjectId().name());
            this.out.print(' ');
            this.out.print(stage);
            this.out.print('\t');
            this.out.print(ent.getPathString());
            this.out.println();
        }
    }
}

