/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.binary;

import java.util.Collection;
import java.util.Vector;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryAbstractType;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryEnumConstant;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceEnum;
import org.eclipse.jpt.common.core.resource.java.JavaResourceEnumConstant;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BinaryEnum
extends BinaryAbstractType
implements JavaResourceEnum {
    private final Vector<JavaResourceEnumConstant> enumConstants = this.buildEnumConstants();
    private static final IField[] EMPTY_FIELD_ARRAY = new IField[0];

    BinaryEnum(JavaResourceNode parent, IType type) {
        super(parent, type);
    }

    @Override
    public JavaResourceAnnotatedElement.Kind getKind() {
        return JavaResourceAnnotatedElement.Kind.ENUM;
    }

    @Override
    public void update() {
        super.update();
        this.updateEnumConstants();
    }

    private void updateEnumConstants() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<JavaResourceEnumConstant> getEnumConstants() {
        return new LiveCloneIterable(this.enumConstants);
    }

    private void addEnumConstant(JavaResourceEnumConstant enumConstants) {
        this.addItemToCollection(enumConstants, this.enumConstants, "enums");
    }

    private JavaResourceEnumConstant getEnumConstant(String enumConstantName, int occurrence) {
        for (JavaResourceEnumConstant enumConstant : this.getEnumConstants()) {
            if (!enumConstant.isFor(enumConstantName, occurrence)) continue;
            return enumConstant;
        }
        return null;
    }

    private void removeEnumConstants(Collection<JavaResourceEnumConstant> remove) {
        this.removeItemsFromCollection(remove, this.enumConstants, "enums");
    }

    private Vector<JavaResourceEnumConstant> buildEnumConstants() {
        Iterable<IField> jdtEnumConstants = this.getEnumConstants(this.getMember());
        Vector<JavaResourceEnumConstant> result = new Vector<JavaResourceEnumConstant>(CollectionTools.size(jdtEnumConstants));
        for (IField jdtEnumConstant : jdtEnumConstants) {
            result.add(this.buildEnumConstant(jdtEnumConstant));
        }
        return result;
    }

    private Iterable<IField> getEnumConstants(IType type) {
        return new FilteringIterable<IField>(CollectionTools.iterable((Object[])this.getFields(type))){

            protected boolean accept(IField jdtField) {
                return BinaryEnum.this.isEnumConstant(jdtField);
            }
        };
    }

    private IField[] getFields(IType type) {
        try {
            return type.getFields();
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return EMPTY_FIELD_ARRAY;
        }
    }

    private boolean isEnumConstant(IField field) {
        try {
            return field.isEnumConstant();
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return false;
        }
    }

    private JavaResourceEnumConstant buildEnumConstant(IField jdtEnumConstant) {
        return new BinaryEnumConstant(this, jdtEnumConstant);
    }
}

