/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.binary;

import java.util.Collection;
import java.util.Vector;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryAbstractType;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryField;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryMethod;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.utility.MethodSignature;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BinaryType
extends BinaryAbstractType
implements JavaResourceType {
    private String superclassQualifiedName;
    private boolean abstract_;
    private boolean hasNoArgConstructor;
    private boolean hasPrivateNoArgConstructor;
    private final Vector<JavaResourceField> fields;
    private final Vector<JavaResourceMethod> methods;
    private static final IField[] EMPTY_FIELD_ARRAY = new IField[0];
    private static final IMethod[] EMPTY_METHOD_ARRAY = new IMethod[0];

    BinaryType(JavaResourceNode parent, IType type) {
        super(parent, type);
        this.superclassQualifiedName = this.buildSuperclassQualifiedName(type);
        this.abstract_ = this.buildAbstract(type);
        this.hasNoArgConstructor = this.buildHasNoArgConstructor(type);
        this.hasPrivateNoArgConstructor = this.buildHasPrivateNoArgConstructor(type);
        this.fields = this.buildFields(type);
        this.methods = this.buildMethods(type);
    }

    @Override
    public JavaResourceAnnotatedElement.Kind getKind() {
        return JavaResourceAnnotatedElement.Kind.TYPE;
    }

    @Override
    protected void update(IMember member) {
        super.update(member);
        this.setSuperclassQualifiedName(this.buildSuperclassQualifiedName((IType)member));
        this.setAbstract(this.buildAbstract((IType)member));
        this.setHasNoArgConstructor(this.buildHasNoArgConstructor((IType)member));
        this.setHasPrivateNoArgConstructor(this.buildHasPrivateNoArgConstructor((IType)member));
        this.updateFields((IType)member);
        this.updateMethods((IType)member);
    }

    private void updateFields(IType type) {
        throw new UnsupportedOperationException();
    }

    private void updateMethods(IType type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSuperclassQualifiedName() {
        return this.superclassQualifiedName;
    }

    private void setSuperclassQualifiedName(String superclassQualifiedName) {
        String old = this.superclassQualifiedName;
        this.superclassQualifiedName = superclassQualifiedName;
        this.firePropertyChanged("superclassQualifiedName", old, superclassQualifiedName);
    }

    private String buildSuperclassQualifiedName(IType type) {
        return BinaryType.convertTypeSignatureToTypeName(this.getSuperclassTypeSignature(type));
    }

    private String getSuperclassTypeSignature(IType type) {
        try {
            return type.getSuperclassTypeSignature();
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return null;
        }
    }

    @Override
    public boolean isAbstract() {
        return this.abstract_;
    }

    private void setAbstract(boolean abstract_) {
        boolean old = this.abstract_;
        this.abstract_ = abstract_;
        this.firePropertyChanged("abstract", old, abstract_);
    }

    private boolean buildAbstract(IType type) {
        try {
            return Flags.isAbstract((int)type.getFlags());
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return false;
        }
    }

    @Override
    public boolean hasNoArgConstructor() {
        return this.hasNoArgConstructor;
    }

    private void setHasNoArgConstructor(boolean hasNoArgConstructor) {
        boolean old = this.hasNoArgConstructor;
        this.hasNoArgConstructor = hasNoArgConstructor;
        this.firePropertyChanged("noArgConstructor", old, hasNoArgConstructor);
    }

    private boolean buildHasNoArgConstructor(IType type) {
        return this.findNoArgConstructor(type) != null;
    }

    private IMethod findNoArgConstructor(IType type) {
        try {
            IMethod[] iMethodArray = type.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                if (method.isConstructor()) {
                    return method;
                }
                ++n2;
            }
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
        }
        return null;
    }

    @Override
    public boolean hasPrivateNoArgConstructor() {
        return this.hasPrivateNoArgConstructor;
    }

    private void setHasPrivateNoArgConstructor(boolean hasPrivateNoArgConstructor) {
        boolean old = this.hasPrivateNoArgConstructor;
        this.hasPrivateNoArgConstructor = hasPrivateNoArgConstructor;
        this.firePropertyChanged("privateNoArgConstructor", old, hasPrivateNoArgConstructor);
    }

    private boolean buildHasPrivateNoArgConstructor(IType type) {
        IMethod method = this.findNoArgConstructor(type);
        try {
            return method != null && Flags.isPrivate((int)method.getFlags());
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return false;
        }
    }

    @Override
    public boolean hasPublicOrProtectedNoArgConstructor() {
        Iterable<JavaResourceMethod> constructors = this.getConstructors();
        if (CollectionTools.size(constructors) == 0) {
            return true;
        }
        for (JavaResourceMethod constructor : constructors) {
            if (constructor.getParametersSize() != 0) continue;
            return Modifier.isPublic((int)constructor.getModifiers()) || Modifier.isProtected((int)constructor.getModifiers());
        }
        return false;
    }

    @Override
    public boolean hasPublicNoArgConstructor() {
        Iterable<JavaResourceMethod> constructors = this.getConstructors();
        if (CollectionTools.size(constructors) == 0) {
            return true;
        }
        for (JavaResourceMethod constructor : constructors) {
            if (constructor.getParametersSize() != 0) continue;
            return Modifier.isPublic((int)constructor.getModifiers());
        }
        return false;
    }

    protected Iterable<JavaResourceMethod> getConstructors() {
        return new FilteringIterable<JavaResourceMethod>(this.getMethods()){

            protected boolean accept(JavaResourceMethod method) {
                return method.isConstructor();
            }
        };
    }

    @Override
    public boolean hasAnyAnnotatedFields() {
        for (JavaResourceField field : this.getFields()) {
            if (!field.isAnnotated()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasAnyAnnotatedMethods() {
        for (JavaResourceMethod method : this.getMethods()) {
            if (!method.isAnnotated()) continue;
            return true;
        }
        return false;
    }

    @Override
    public IType getMember() {
        return super.getMember();
    }

    @Override
    public boolean hasEqualsMethod() {
        for (JavaResourceMethod method : this.getMethods()) {
            if (!StringTools.stringsAreEqual((String)method.getMethodName(), (String)"equals") || method.getParametersSize() != 1 || !StringTools.stringsAreEqual((String)method.getParameterTypeName(0), (String)Object.class.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasHashCodeMethod() {
        for (JavaResourceMethod method : this.getMethods()) {
            if (!StringTools.stringsAreEqual((String)method.getMethodName(), (String)"hashCode") || method.getParametersSize() != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public JavaResourceMethod getMethod(String propertyName) {
        for (JavaResourceMethod method : this.getMethods()) {
            if (!StringTools.stringsAreEqual((String)method.getMethodName(), (String)propertyName)) continue;
            return method;
        }
        return null;
    }

    @Override
    public Iterable<JavaResourceField> getFields() {
        return new LiveCloneIterable(this.fields);
    }

    private void addField(JavaResourceField field) {
        this.addItemToCollection(field, this.fields, "fields");
    }

    private JavaResourceField getField(String fieldName, int occurrence) {
        for (JavaResourceField field : this.getFields()) {
            if (!field.isFor(fieldName, occurrence)) continue;
            return field;
        }
        return null;
    }

    private void removeFields(Collection<JavaResourceField> remove) {
        this.removeItemsFromCollection(remove, this.fields, "fields");
    }

    private Vector<JavaResourceField> buildFields(IType type) {
        IField[] jdtFields = this.getFields(type);
        Vector<JavaResourceField> result = new Vector<JavaResourceField>(jdtFields.length);
        IField[] iFieldArray = jdtFields;
        int n = jdtFields.length;
        int n2 = 0;
        while (n2 < n) {
            IField jdtField = iFieldArray[n2];
            result.add(this.buildField(jdtField));
            ++n2;
        }
        return result;
    }

    private IField[] getFields(IType type) {
        try {
            return type.getFields();
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return EMPTY_FIELD_ARRAY;
        }
    }

    private JavaResourceField buildField(IField jdtField) {
        return new BinaryField((JavaResourceType)this, jdtField);
    }

    @Override
    public Iterable<JavaResourceMethod> getMethods() {
        return new LiveCloneIterable(this.methods);
    }

    private JavaResourceMethod getMethod(MethodSignature signature, int occurrence) {
        for (JavaResourceMethod method : this.getMethods()) {
            if (!method.isFor(signature, occurrence)) continue;
            return method;
        }
        return null;
    }

    private void addMethod(JavaResourceMethod method) {
        this.addItemToCollection(method, this.methods, "methods");
    }

    private void removeMethods(Collection<JavaResourceMethod> remove) {
        this.removeItemsFromCollection(remove, this.methods, "methods");
    }

    private Vector<JavaResourceMethod> buildMethods(IType type) {
        IMethod[] jdtMethods = this.getMethods(type);
        Vector<JavaResourceMethod> result = new Vector<JavaResourceMethod>(jdtMethods.length);
        IMethod[] iMethodArray = jdtMethods;
        int n = jdtMethods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod jdtMethod = iMethodArray[n2];
            result.add(this.buildMethod(jdtMethod));
            ++n2;
        }
        return result;
    }

    private IMethod[] getMethods(IType type) {
        try {
            return type.getMethods();
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return EMPTY_METHOD_ARRAY;
        }
    }

    private JavaResourceMethod buildMethod(IMethod jdtMethod) {
        return new BinaryMethod((JavaResourceType)this, jdtMethod);
    }
}

