/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.source;

import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jpt.common.core.AnnotationProvider;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceCompilationUnit;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceEnum;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationEditFormatter;
import org.eclipse.jpt.common.utility.command.CommandExecutor;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceTypeCompilationUnit
extends SourceCompilationUnit {
    private JavaResourceAbstractType primaryType = this.buildPrimaryType();

    public SourceTypeCompilationUnit(ICompilationUnit compilationUnit, AnnotationProvider annotationProvider, AnnotationEditFormatter annotationEditFormatter, CommandExecutor modifySharedDocumentCommandExecutor) {
        super(compilationUnit, annotationProvider, annotationEditFormatter, modifySharedDocumentCommandExecutor);
    }

    private JavaResourceAbstractType buildPrimaryType() {
        this.openCompilationUnit();
        CompilationUnit astRoot = this.buildASTRoot();
        this.closeCompilationUnit();
        return this.buildPrimaryType(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncPrimaryType(astRoot);
    }

    @Override
    public Iterable<JavaResourceAbstractType> getTypes() {
        return this.primaryType == null ? EmptyIterable.instance() : new CompositeIterable(new Iterable[]{this.primaryType.getAllTypes(), this.primaryType.getAllEnums()});
    }

    @Override
    public JptResourceType getResourceType() {
        return JptCommonCorePlugin.JAVA_SOURCE_RESOURCE_TYPE;
    }

    @Override
    public void resolveTypes() {
        if (this.primaryType != null) {
            this.primaryType.resolveTypes(this.buildASTRoot());
        }
    }

    @Override
    public JavaResourceAbstractType getPrimaryType() {
        return this.primaryType;
    }

    private JavaResourceAbstractType buildPrimaryType(CompilationUnit astRoot) {
        AbstractTypeDeclaration td = this.getPrimaryTypeOrEnumDeclaration(astRoot);
        return td == null ? null : this.buildPrimaryType(astRoot, td);
    }

    private void syncPrimaryType(CompilationUnit astRoot) {
        AbstractTypeDeclaration td = this.getPrimaryTypeOrEnumDeclaration(astRoot);
        if (td == null) {
            this.syncPrimaryType_(null);
        } else if (this.primaryType == null || !SourceTypeCompilationUnit.typeMatchesASTNodeType(this.primaryType, td)) {
            this.syncPrimaryType_(this.buildPrimaryType(astRoot, td));
        } else {
            this.primaryType.synchronizeWith(astRoot);
        }
    }

    protected static boolean typeMatchesASTNodeType(JavaResourceAbstractType type, AbstractTypeDeclaration astType) {
        return type.getKind().getAstNodeType() == astType.getNodeType();
    }

    private void syncPrimaryType_(JavaResourceAbstractType astType) {
        JavaResourceAbstractType old = this.primaryType;
        this.primaryType = astType;
        this.firePropertyChanged("types", old, astType);
    }

    private JavaResourceAbstractType buildPrimaryType(CompilationUnit astRoot, AbstractTypeDeclaration typeDeclaration) {
        if (typeDeclaration.getNodeType() == 55) {
            return SourceType.newInstance(this, (TypeDeclaration)typeDeclaration, astRoot);
        }
        if (typeDeclaration.getNodeType() == 71) {
            return SourceEnum.newInstance(this, (EnumDeclaration)typeDeclaration, astRoot);
        }
        throw new IllegalArgumentException();
    }

    private AbstractTypeDeclaration getPrimaryTypeOrEnumDeclaration(CompilationUnit astRoot) {
        String primaryTypeName = this.getPrimaryTypeName();
        for (AbstractTypeDeclaration atd : this.types(astRoot)) {
            if (!this.nodeIsPrimaryTypeOrEnumDeclaration(atd, primaryTypeName)) continue;
            return atd.resolveBinding() == null ? null : atd;
        }
        return null;
    }

    private boolean nodeIsPrimaryTypeOrEnumDeclaration(AbstractTypeDeclaration atd, String primaryTypeName) {
        return this.nodeIsTypeOrEnumDeclaration(atd) && atd.getName().getFullyQualifiedName().equals(primaryTypeName);
    }

    private boolean nodeIsTypeOrEnumDeclaration(AbstractTypeDeclaration atd) {
        return atd.getNodeType() == 55 || atd.getNodeType() == 71;
    }

    private String getPrimaryTypeName() {
        return this.getCompilationUnitName();
    }

    private List<AbstractTypeDeclaration> types(CompilationUnit astRoot) {
        return astRoot.types();
    }
}

