/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility;

import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.ArrayList;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.NotNullFilter;
import org.eclipse.jpt.common.utility.internal.iterables.ArrayIterable;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JDTTools {
    private static final IJavaElement[] EMPTY_JAVA_ELEMENT_ARRAY = new IJavaElement[0];
    private static final Filter<IPackageFragmentRoot> SOURCE_PACKAGE_FRAGMENT_ROOT_FILTER = new Filter<IPackageFragmentRoot>(){

        public boolean accept(IPackageFragmentRoot pfr) {
            return JDTTools.packageFragmentRootIsSourceFolder(pfr);
        }
    };
    public static final String SERIALIZABLE_CLASS_NAME = Serializable.class.getName();

    public static boolean packageFragmentRootIsSourceFolder(IPackageFragmentRoot pfr) {
        try {
            return JDTTools.packageFragmentRootIsSourceFolder_(pfr);
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return false;
        }
    }

    static boolean packageFragmentRootIsSourceFolder_(IPackageFragmentRoot pfr) throws JavaModelException {
        return pfr.exists() && pfr.getKind() == 1;
    }

    public static IJavaElement[] getChildren(IParent parent) {
        try {
            return parent.getChildren();
        }
        catch (JavaModelException ex) {
            if (!(ex.getCause() instanceof FileNotFoundException)) {
                JptCommonCorePlugin.log(ex);
            }
            return EMPTY_JAVA_ELEMENT_ARRAY;
        }
    }

    public static boolean typeIsSubType(IJavaProject javaProject, String potentialSubType, String potentialSuperType) {
        try {
            return JDTTools.typeIsSubType(javaProject, javaProject.findType(potentialSubType), javaProject.findType(potentialSuperType));
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return false;
        }
    }

    public static boolean typeIsSubType(IJavaProject javaProject, IType potentialSubType, String potentialSuperType) {
        try {
            return JDTTools.typeIsSubType_(javaProject, potentialSubType, potentialSuperType);
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return false;
        }
    }

    private static boolean typeIsSubType_(IJavaProject javaProject, IType potentialSubType, String potentialSuperType) throws JavaModelException {
        return JDTTools.typeIsSubType(javaProject, potentialSubType, javaProject.findType(potentialSuperType));
    }

    private static boolean typeIsSubType(IJavaProject javaProject, IType potentialSubType, IType potentialSuperType) throws JavaModelException {
        if (potentialSubType == null || potentialSuperType == null) {
            return false;
        }
        if (potentialSubType.equals(potentialSuperType)) {
            return true;
        }
        if (javaProject.findType(Object.class.getName()).equals(potentialSuperType)) {
            return true;
        }
        String potentialSuperTypeName = potentialSuperType.getFullyQualifiedName();
        for (String superTypeName : JDTTools.getResolvedSuperTypeNames(potentialSubType)) {
            if (superTypeName.equals(potentialSuperTypeName)) {
                return true;
            }
            if (!JDTTools.typeIsSubType(javaProject, javaProject.findType(superTypeName), potentialSuperType)) continue;
            return true;
        }
        return false;
    }

    private static Iterable<String> getResolvedSuperTypeNames(IType type) throws JavaModelException {
        Iterable<String> nonResolvedSuperTypeNames = JDTTools.getNonResolvedSuperTypeNames(type);
        if (type.isBinary()) {
            return nonResolvedSuperTypeNames;
        }
        ArrayList<String> resolvedSuperTypeNames = new ArrayList<String>();
        for (String superTypeName : nonResolvedSuperTypeNames) {
            resolvedSuperTypeNames.add(JDTTools.resolveType(type, superTypeName));
        }
        return resolvedSuperTypeNames;
    }

    private static Iterable<String> getNonResolvedSuperTypeNames(IType type) throws JavaModelException {
        return new CompositeIterable(new Iterable[]{new FilteringIterable((Iterable)new SingleElementIterable((Object)type.getSuperclassName()), NotNullFilter.instance()), new ArrayIterable((Object[])type.getSuperInterfaceNames())});
    }

    private static String resolveType(IType type, String className) throws JavaModelException {
        String[][] resolvedClassNames = type.resolveType(className);
        if (resolvedClassNames == null) {
            return null;
        }
        String pkg = resolvedClassNames[0][0];
        String cls = resolvedClassNames[0][1];
        return pkg.length() == 0 ? cls : String.valueOf(pkg) + '.' + cls;
    }

    public static IType findType(IJavaProject javaProject, String fullyQualifiedName) {
        try {
            return javaProject.findType(fullyQualifiedName);
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return null;
        }
    }

    public static Iterable<IPackageFragmentRoot> getJavaSourceFolders(IJavaProject javaProject) {
        return new FilteringIterable(JDTTools.getPackageFragmentRoots(javaProject), SOURCE_PACKAGE_FRAGMENT_ROOT_FILTER);
    }

    private static Iterable<IPackageFragmentRoot> getPackageFragmentRoots(IJavaProject javaProject) {
        try {
            return JDTTools.getPackageFragmentRoots_(javaProject);
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return EmptyIterable.instance();
        }
    }

    private static Iterable<IPackageFragmentRoot> getPackageFragmentRoots_(IJavaProject javaProject) throws JavaModelException {
        return new ArrayIterable((Object[])javaProject.getPackageFragmentRoots());
    }

    public static boolean typeIsEnum(IType type) {
        try {
            if (type.isEnum()) {
                return true;
            }
        }
        catch (JavaModelException e) {
            JptCommonCorePlugin.log(e);
        }
        return false;
    }

    public static boolean typeIsSerializable(IJavaProject javaProject, IType type) {
        return JDTTools.typeIsSubType(javaProject, type, SERIALIZABLE_CLASS_NAME);
    }

    public static boolean classHasPublicZeroArgConstructor(IJavaProject javaProject, String className) {
        IType type;
        if (javaProject != null && className != null && (type = JDTTools.findType(javaProject, className)) != null) {
            return JDTTools.typeHasPublicZeroArgConstructor(type);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean typeHasPublicZeroArgConstructor(IType type) {
        boolean hasDefinedConstructor = false;
        try {
            IMethod[] iMethodArray = type.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    if (hasDefinedConstructor) return false;
                    return true;
                }
                IMethod method = iMethodArray[n2];
                if (method.isConstructor()) {
                    if (method.getNumberOfParameters() == 0 && Flags.isPublic((int)method.getFlags())) {
                        return true;
                    }
                    hasDefinedConstructor = true;
                }
                ++n2;
            }
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
        }
        return false;
    }
}

