/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility.command;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jpt.common.core.internal.utility.command.RepeatingJobCommandWrapper;
import org.eclipse.jpt.common.core.utility.command.JobCommand;
import org.eclipse.jpt.common.core.utility.command.JobCommandExecutor;
import org.eclipse.jpt.common.core.utility.command.NotifyingRepeatingJobCommand;
import org.eclipse.jpt.common.utility.ExceptionHandler;
import org.eclipse.jpt.common.utility.internal.ListenerList;

public class NotifyingRepeatingJobCommandWrapper
extends RepeatingJobCommandWrapper
implements NotifyingRepeatingJobCommand {
    private final ListenerList<NotifyingRepeatingJobCommand.Listener> listenerList = new ListenerList(NotifyingRepeatingJobCommand.Listener.class);

    public NotifyingRepeatingJobCommandWrapper(JobCommand command, ExceptionHandler exceptionHandler) {
        super(command, exceptionHandler);
    }

    public NotifyingRepeatingJobCommandWrapper(JobCommand command, JobCommandExecutor startCommandExecutor, ExceptionHandler exceptionHandler) {
        super(command, startCommandExecutor, exceptionHandler);
    }

    public void addListener(NotifyingRepeatingJobCommand.Listener listener) {
        this.listenerList.add((Object)listener);
    }

    public void removeListener(NotifyingRepeatingJobCommand.Listener listener) {
        this.listenerList.remove((Object)listener);
    }

    IStatus executeCommand(IProgressMonitor monitor) {
        IStatus status = super.executeCommand(monitor);
        if (this.state.isQuiesced()) {
            this.executionQuiesced(monitor);
        }
        return status;
    }

    private void executionQuiesced(IProgressMonitor monitor) {
        for (NotifyingRepeatingJobCommand.Listener listener : this.listenerList.getListeners()) {
            this.notifyListener(listener, monitor);
        }
    }

    private void notifyListener(NotifyingRepeatingJobCommand.Listener listener, IProgressMonitor monitor) {
        try {
            listener.executionQuiesced(this, monitor);
        }
        catch (OperationCanceledException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            this.exceptionHandler.handleException(ex);
        }
    }
}

