/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.jface;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.common.ui.internal.jface.AbstractItemStructuredStateProviderManager;
import org.eclipse.jpt.common.ui.internal.util.SWTUtil;
import org.eclipse.jpt.common.ui.jface.ItemExtendedLabelProviderFactory;
import org.eclipse.jpt.common.ui.jface.ItemTreeContentProvider;
import org.eclipse.jpt.common.ui.jface.ItemTreeContentProviderFactory;
import org.eclipse.jpt.common.ui.jface.TreeStateProvider;
import org.eclipse.jpt.common.utility.internal.RunnableAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemTreeStateProviderManager
extends AbstractItemStructuredStateProviderManager<TreeViewer, ItemTreeContentProvider>
implements TreeStateProvider,
ItemTreeContentProvider.Manager {
    protected final ItemTreeContentProviderFactory itemContentProviderFactory;

    public ItemTreeStateProviderManager(ItemTreeContentProviderFactory itemContentProviderFactory) {
        this(itemContentProviderFactory, null);
    }

    public ItemTreeStateProviderManager(ItemTreeContentProviderFactory itemContentProviderFactory, ItemExtendedLabelProviderFactory itemLabelProviderFactory) {
        super(itemLabelProviderFactory);
        if (itemContentProviderFactory == null) {
            throw new NullPointerException();
        }
        this.itemContentProviderFactory = itemContentProviderFactory;
    }

    public boolean hasChildren(Object element) {
        ItemTreeContentProvider provider = (ItemTreeContentProvider)this.getItemContentProvider(element);
        return provider != null && provider.hasChildren();
    }

    public Object[] getChildren(Object parentElement) {
        ItemTreeContentProvider provider = (ItemTreeContentProvider)this.getItemContentProvider(parentElement);
        return provider == null ? EMPTY_ARRAY : provider.getChildren();
    }

    public Object getParent(Object element) {
        ItemTreeContentProvider provider = (ItemTreeContentProvider)this.getItemContentProvider(element);
        return provider == null ? null : provider.getParent();
    }

    @Override
    protected ItemTreeContentProvider buildItemContentProvider(Object item) {
        return this.itemContentProviderFactory.buildProvider(item, this);
    }

    @Override
    public void updateChildren(Object inputElement) {
        SWTUtil.execute((Viewer)this.viewer, (Runnable)((Object)new UpdateChildrenRunnable(inputElement)));
    }

    void updateChildren_(Object element) {
        if (this.viewerIsAlive()) {
            ((TreeViewer)this.viewer).refresh(element, false);
        }
    }

    class UpdateChildrenRunnable
    extends RunnableAdapter {
        private final Object element;

        UpdateChildrenRunnable(Object element) {
            this.element = element;
        }

        public void run() {
            ItemTreeStateProviderManager.this.updateChildren_(this.element);
        }
    }
}

