/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.JptResourceModel;
import org.eclipse.jpt.common.core.JptResourceModelListener;
import org.eclipse.jpt.common.core.internal.utility.PlatformTools;
import org.eclipse.jpt.common.core.resource.ProjectResourceLocator;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.resource.java.JavaResourcePackage;
import org.eclipse.jpt.common.core.resource.java.JavaResourcePackageInfoCompilationUnit;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.command.CommandExecutor;
import org.eclipse.jpt.common.utility.command.ExtendedCommandExecutor;
import org.eclipse.jpt.common.utility.internal.BitTools;
import org.eclipse.jpt.common.utility.internal.NotNullFilter;
import org.eclipse.jpt.common.utility.internal.command.ThreadLocalExtendedCommandExecutor;
import org.eclipse.jpt.common.utility.internal.iterables.ArrayIterable;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SnapshotCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.common.utility.internal.synchronizers.CallbackSynchronousSynchronizer;
import org.eclipse.jpt.common.utility.internal.synchronizers.SynchronousSynchronizer;
import org.eclipse.jpt.common.utility.synchronizers.CallbackSynchronizer;
import org.eclipse.jpt.common.utility.synchronizers.Synchronizer;
import org.eclipse.jpt.jaxb.core.JaxbFacet;
import org.eclipse.jpt.jaxb.core.JaxbFile;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.JptJaxbCorePlugin;
import org.eclipse.jpt.jaxb.core.SchemaLibrary;
import org.eclipse.jpt.jaxb.core.context.JaxbContextRoot;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbPackageInfo;
import org.eclipse.jpt.jaxb.core.context.JaxbType;
import org.eclipse.jpt.jaxb.core.context.java.JavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.AbstractJaxbNode;
import org.eclipse.jpt.jaxb.core.internal.SchemaLibraryImpl;
import org.eclipse.jpt.jaxb.core.internal.platform.JaxbPlatformImpl;
import org.eclipse.jpt.jaxb.core.internal.validation.DefaultValidationMessages;
import org.eclipse.jpt.jaxb.core.libprov.JaxbLibraryProviderInstallOperationConfig;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatform;
import org.eclipse.jpt.jaxb.core.resource.jaxbindex.JaxbIndexResource;
import org.eclipse.jpt.jaxb.core.resource.jaxbprops.JaxbPropertiesResource;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJaxbProject
extends AbstractJaxbNode
implements JaxbProject {
    protected final IProject project;
    protected final JaxbPlatform jaxbPlatform;
    protected final SchemaLibraryImpl schemaLibrary;
    protected final Vector<JaxbFile> jaxbFiles = new Vector();
    protected final JptResourceModelListener resourceModelListener;
    protected final JaxbContextRoot contextRoot;
    protected volatile Synchronizer contextModelSynchronizer;
    protected volatile boolean synchronizingContextModel = false;
    protected volatile CallbackSynchronizer updateSynchronizer;
    protected final CallbackSynchronizer.Listener updateSynchronizerListener;
    protected final ThreadLocalExtendedCommandExecutor modifySharedDocumentCommandExecutor;

    protected AbstractJaxbProject(JaxbProject.Config config) {
        super(null);
        if (config.getProject() == null || config.getPlatformDefinition() == null) {
            throw new NullPointerException();
        }
        this.project = config.getProject();
        this.jaxbPlatform = new JaxbPlatformImpl(config.getPlatformDefinition());
        this.schemaLibrary = new SchemaLibraryImpl(this);
        this.modifySharedDocumentCommandExecutor = this.buildModifySharedDocumentCommandExecutor();
        this.resourceModelListener = this.buildResourceModelListener();
        InitialResourceProxyVisitor visitor = this.buildInitialResourceProxyVisitor();
        visitor.visitProject(this.project);
        this.contextRoot = this.buildContextRoot();
        this.setContextModelSynchronizer_(this.buildSynchronousContextModelSynchronizer());
        this.updateSynchronizerListener = this.buildUpdateSynchronizerListener();
        this.setUpdateSynchronizer_(this.buildSynchronousUpdateSynchronizer());
    }

    @Override
    protected boolean requiresParent() {
        return false;
    }

    @Override
    public IResource getResource() {
        return this.project;
    }

    protected ThreadLocalExtendedCommandExecutor buildModifySharedDocumentCommandExecutor() {
        return new ThreadLocalExtendedCommandExecutor();
    }

    protected InitialResourceProxyVisitor buildInitialResourceProxyVisitor() {
        return new InitialResourceProxyVisitor();
    }

    protected JaxbContextRoot buildContextRoot() {
        return this.getFactory().buildContextRoot(this);
    }

    @Override
    public JaxbProject getJaxbProject() {
        return this;
    }

    @Override
    public String getName() {
        return this.project.getName();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public IJavaProject getJavaProject() {
        return JavaCore.create((IProject)this.project);
    }

    @Override
    public JaxbPlatform getPlatform() {
        return this.jaxbPlatform;
    }

    @Override
    public SchemaLibrary getSchemaLibrary() {
        return this.schemaLibrary;
    }

    protected Iterable<JavaResourceCompilationUnit> getCombinedJavaResourceCompilationUnits() {
        return this.getInternalJavaResourceCompilationUnits();
    }

    @Override
    public Iterable<JaxbFile> getJaxbFiles() {
        return new LiveCloneIterable(this.jaxbFiles);
    }

    @Override
    public int getJaxbFilesSize() {
        return this.jaxbFiles.size();
    }

    protected Iterable<JaxbFile> getJaxbFiles(final IContentType contentType) {
        return new FilteringIterable<JaxbFile>(this.getJaxbFiles()){

            protected boolean accept(JaxbFile jaxbFile) {
                return jaxbFile.getContentType().isKindOf(contentType);
            }
        };
    }

    @Override
    public JaxbFile getJaxbFile(IFile file) {
        for (JaxbFile jaxbFile : this.getJaxbFiles()) {
            if (!jaxbFile.getFile().equals((Object)file)) continue;
            return jaxbFile;
        }
        return null;
    }

    protected boolean addJaxbFile(IFile file) {
        JaxbFile jaxbFile = this.addJaxbFile_(file);
        if (jaxbFile != null) {
            this.fireItemAdded("jaxbFiles", jaxbFile);
            return true;
        }
        return false;
    }

    protected JaxbFile addJaxbFile_(IFile file) {
        if (this.isJavaFile(file) ? !this.getJavaProject().isOnClasspath((IResource)file) : !this.fileResourceLocationIsValid(file)) {
            return null;
        }
        JaxbFile jaxbFile = null;
        try {
            jaxbFile = this.getPlatform().buildJaxbFile(this, file);
        }
        catch (Exception e) {
            JptJaxbCorePlugin.log(e);
        }
        if (jaxbFile == null) {
            return null;
        }
        jaxbFile.getResourceModel().addResourceModelListener(this.resourceModelListener);
        this.jaxbFiles.add(jaxbFile);
        return jaxbFile;
    }

    protected boolean isJavaFile(IFile file) {
        IContentType contentType = PlatformTools.getContentType((IFile)file);
        return contentType != null && (contentType.isKindOf(JptCommonCorePlugin.JAVA_SOURCE_CONTENT_TYPE) || contentType.isKindOf(JptCommonCorePlugin.JAR_CONTENT_TYPE));
    }

    protected boolean fileResourceLocationIsValid(IFile file) {
        return this.getProjectResourceLocator().resourceLocationIsValid(file.getParent());
    }

    protected ProjectResourceLocator getProjectResourceLocator() {
        return (ProjectResourceLocator)this.project.getAdapter(ProjectResourceLocator.class);
    }

    protected boolean removeJaxbFile(IFile file) {
        JaxbFile jaxbFile = this.getJaxbFile(file);
        if (jaxbFile != null) {
            this.removeJaxbFile(jaxbFile);
            return true;
        }
        return false;
    }

    protected void removeJaxbFile(JaxbFile jaxbFile) {
        jaxbFile.getResourceModel().removeResourceModelListener(this.resourceModelListener);
        if (!this.removeItemFromCollection(jaxbFile, this.jaxbFiles, "jaxbFiles")) {
            throw new IllegalArgumentException(jaxbFile.toString());
        }
    }

    @Override
    public JaxbContextRoot getContextRoot() {
        return this.contextRoot;
    }

    @Override
    public Iterable<? extends JavaContextNode> getPrimaryJavaNodes(ICompilationUnit cu) {
        IFile file = this.getCorrespondingResource(cu);
        if (file == null) {
            return EmptyIterable.instance();
        }
        IContentType contentType = PlatformTools.getContentType((IFile)file);
        if (contentType == null) {
            return EmptyIterable.instance();
        }
        if (contentType.isKindOf(JptCommonCorePlugin.JAVA_SOURCE_PACKAGE_INFO_CONTENT_TYPE)) {
            try {
                return new FilteringIterable((Iterable)new TransformationIterable<IPackageDeclaration, JaxbPackageInfo>((Iterable)new ArrayIterable((Object[])cu.getPackageDeclarations())){

                    protected JaxbPackageInfo transform(IPackageDeclaration o) {
                        JaxbPackage jaxbPackage = AbstractJaxbProject.this.getContextRoot().getPackage(o.getElementName());
                        return jaxbPackage != null ? jaxbPackage.getPackageInfo() : null;
                    }
                }, NotNullFilter.instance());
            }
            catch (JavaModelException javaModelException) {
                return EmptyIterable.instance();
            }
        }
        if (contentType.isKindOf(JptCommonCorePlugin.JAVA_SOURCE_CONTENT_TYPE)) {
            try {
                return new FilteringIterable((Iterable)new TransformationIterable<IType, JaxbType>((Iterable)new ArrayIterable((Object[])cu.getAllTypes())){

                    protected JaxbType transform(IType o) {
                        JaxbType jaxbType = AbstractJaxbProject.this.getContextRoot().getType(o.getFullyQualifiedName('.'));
                        return jaxbType;
                    }
                }, NotNullFilter.instance());
            }
            catch (JavaModelException javaModelException) {
                return EmptyIterable.instance();
            }
        }
        return EmptyIterable.instance();
    }

    private IFile getCorrespondingResource(ICompilationUnit cu) {
        try {
            return (IFile)cu.getCorrespondingResource();
        }
        catch (JavaModelException ex) {
            JptJaxbCorePlugin.log(ex);
            return null;
        }
    }

    @Override
    public Iterable<JavaResourceAbstractType> getJavaSourceResourceTypes() {
        return new CompositeIterable(this.getInternalJavaSourceResourceTypeSets());
    }

    @Override
    public Iterable<JavaResourceAbstractType> getAnnotatedJavaSourceResourceTypes() {
        return new FilteringIterable<JavaResourceAbstractType>(this.getJavaSourceResourceTypes()){

            protected boolean accept(JavaResourceAbstractType type) {
                return type.isAnnotated();
            }
        };
    }

    protected Iterable<Iterable<JavaResourceAbstractType>> getInternalJavaSourceResourceTypeSets() {
        return new TransformationIterable<JavaResourceCompilationUnit, Iterable<JavaResourceAbstractType>>(this.getInternalJavaResourceCompilationUnits()){

            protected Iterable<JavaResourceAbstractType> transform(JavaResourceCompilationUnit compilationUnit) {
                return compilationUnit.getTypes();
            }
        };
    }

    protected Iterable<JavaResourceCompilationUnit> getInternalJavaResourceCompilationUnits() {
        return new TransformationIterable<JaxbFile, JavaResourceCompilationUnit>(this.getJavaSourceJaxbFiles()){

            protected JavaResourceCompilationUnit transform(JaxbFile jaxbFile) {
                return (JavaResourceCompilationUnit)jaxbFile.getResourceModel();
            }
        };
    }

    protected Iterable<JaxbFile> getJavaSourceJaxbFiles() {
        return this.getJaxbFiles(JptCommonCorePlugin.JAVA_SOURCE_CONTENT_TYPE);
    }

    @Override
    public Iterable<JavaResourcePackage> getJavaResourcePackages() {
        return new FilteringIterable<JavaResourcePackage>((Iterable)new TransformationIterable<JaxbFile, JavaResourcePackage>(this.getPackageInfoSourceJaxbFiles()){

            protected JavaResourcePackage transform(JaxbFile jaxbFile) {
                return ((JavaResourcePackageInfoCompilationUnit)jaxbFile.getResourceModel()).getPackage();
            }
        }){

            protected boolean accept(JavaResourcePackage resourcePackage) {
                return resourcePackage != null;
            }
        };
    }

    @Override
    public JavaResourcePackage getJavaResourcePackage(String packageName) {
        for (JavaResourcePackage jrp : this.getJavaResourcePackages()) {
            if (!jrp.getName().equals(packageName)) continue;
            return jrp;
        }
        return null;
    }

    @Override
    public Iterable<JavaResourcePackage> getAnnotatedJavaResourcePackages() {
        return new FilteringIterable<JavaResourcePackage>(this.getJavaResourcePackages()){

            protected boolean accept(JavaResourcePackage resourcePackage) {
                return resourcePackage.isAnnotated();
            }
        };
    }

    @Override
    public JavaResourcePackage getAnnotatedJavaResourcePackage(String packageName) {
        JavaResourcePackage jrp = this.getJavaResourcePackage(packageName);
        return jrp != null && jrp.isAnnotated() ? jrp : null;
    }

    protected Iterable<JaxbFile> getPackageInfoSourceJaxbFiles() {
        return this.getJaxbFiles(JptCommonCorePlugin.JAVA_SOURCE_PACKAGE_INFO_CONTENT_TYPE);
    }

    @Override
    public JavaResourceAbstractType getJavaResourceType(String typeName) {
        for (JavaResourceAbstractType type : this.getJavaResourceTypes()) {
            if (!type.getQualifiedName().equals(typeName)) continue;
            return type;
        }
        return null;
    }

    @Override
    public JavaResourceAbstractType getJavaResourceType(String typeName, JavaResourceAnnotatedElement.Kind kind) {
        JavaResourceAbstractType resourceType = this.getJavaResourceType(typeName);
        if (resourceType == null || resourceType.getKind() != kind) {
            return null;
        }
        return resourceType;
    }

    protected Iterable<JavaResourceAbstractType> getJavaResourceTypes() {
        return new CompositeIterable(this.getJavaResourceTypeSets());
    }

    protected Iterable<Iterable<JavaResourceAbstractType>> getJavaResourceTypeSets() {
        return new TransformationIterable<JavaResourceNode.Root, Iterable<JavaResourceAbstractType>>(this.getJavaResourceNodeRoots()){

            protected Iterable<JavaResourceAbstractType> transform(JavaResourceNode.Root root) {
                return root.getTypes();
            }
        };
    }

    protected Iterable<JavaResourceNode.Root> getJavaResourceNodeRoots() {
        return new CompositeIterable(new Iterable[]{this.getInternalJavaResourceCompilationUnits()});
    }

    @Override
    public Iterable<JaxbIndexResource> getJaxbIndexResources() {
        return new TransformationIterable<JaxbFile, JaxbIndexResource>(this.getJaxbFiles(JptJaxbCorePlugin.JAXB_INDEX_CONTENT_TYPE)){

            protected JaxbIndexResource transform(JaxbFile o) {
                return (JaxbIndexResource)o.getResourceModel();
            }
        };
    }

    @Override
    public JaxbIndexResource getJaxbIndexResource(String packageName) {
        for (JaxbIndexResource jir : this.getJaxbIndexResources()) {
            if (!packageName.equals(jir.getPackageName())) continue;
            return jir;
        }
        return null;
    }

    @Override
    public Iterable<JaxbPropertiesResource> getJaxbPropertiesResources() {
        return new TransformationIterable<JaxbFile, JaxbPropertiesResource>(this.getJaxbFiles(JptJaxbCorePlugin.JAXB_PROPERTIES_CONTENT_TYPE)){

            protected JaxbPropertiesResource transform(JaxbFile o) {
                return (JaxbPropertiesResource)o.getResourceModel();
            }
        };
    }

    @Override
    public JaxbPropertiesResource getJaxbPropertiesResource(String packageName) {
        for (JaxbPropertiesResource jpr : this.getJaxbPropertiesResources()) {
            if (!packageName.equals(jpr.getPackageName())) continue;
            return jpr;
        }
        return null;
    }

    @Override
    public void javaElementChanged(ElementChangedEvent event) {
        this.processJavaDelta(event.getDelta());
    }

    protected void processJavaDelta(IJavaElementDelta delta) {
        switch (delta.getElement().getElementType()) {
            case 1: {
                this.processJavaModelDelta(delta);
                break;
            }
            case 2: {
                this.processJavaProjectDelta(delta);
                break;
            }
            case 3: {
                this.processJavaPackageFragmentRootDelta(delta);
                break;
            }
            case 4: {
                this.processJavaPackageFragmentDelta(delta);
                break;
            }
            case 5: {
                this.processJavaCompilationUnitDelta(delta);
                break;
            }
        }
    }

    protected void processJavaDeltaChildren(IJavaElementDelta delta) {
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta child = iJavaElementDeltaArray[n2];
            this.processJavaDelta(child);
            ++n2;
        }
    }

    protected boolean deltaFlagIsSet(IJavaElementDelta delta, int flag) {
        return delta.getKind() == 4 && BitTools.flagIsSet((int)delta.getFlags(), (int)flag);
    }

    protected void processJavaModelDelta(IJavaElementDelta delta) {
        this.processJavaDeltaChildren(delta);
    }

    protected void processJavaProjectDelta(IJavaElementDelta delta) {
        this.processJavaDeltaChildren(delta);
        if (this.classpathHasChanged(delta)) {
            this.rebuild((IJavaProject)delta.getElement());
        }
    }

    protected void rebuild(IJavaProject javaProject) {
        if (javaProject.equals(this.getJavaProject())) {
            this.removeDeadJpaFiles();
            this.synchronizeWithJavaSource(this.getInternalJavaResourceCompilationUnits());
        }
    }

    protected void removeDeadJpaFiles() {
        for (JaxbFile jaxbFile : this.getJaxbFiles()) {
            if (!this.jaxbFileIsDead(jaxbFile)) continue;
            this.removeJaxbFile(jaxbFile);
        }
    }

    protected boolean jaxbFileIsDead(JaxbFile jaxbFile) {
        return !this.jaxbFileIsAlive(jaxbFile);
    }

    protected boolean jaxbFileIsAlive(JaxbFile jaxbFile) {
        IFile file = jaxbFile.getFile();
        return this.getJavaProject().isOnClasspath((IResource)file) && file.exists();
    }

    protected boolean classpathHasChanged(IJavaElementDelta delta) {
        return this.deltaFlagIsSet(delta, 0x200000);
    }

    protected void synchronizeWithJavaSource(Iterable<JavaResourceCompilationUnit> javaResourceCompilationUnits) {
        for (JavaResourceCompilationUnit javaResourceCompilationUnit : javaResourceCompilationUnits) {
            javaResourceCompilationUnit.synchronizeWithJavaSource();
        }
    }

    protected void processJavaPackageFragmentRootDelta(IJavaElementDelta delta) {
        this.processJavaDeltaChildren(delta);
        if (!this.classpathEntryHasBeenAdded(delta)) {
            this.classpathEntryHasBeenRemoved(delta);
        }
    }

    protected boolean classpathEntryHasBeenAdded(IJavaElementDelta delta) {
        return this.deltaFlagIsSet(delta, 64);
    }

    protected boolean classpathEntryHasBeenRemoved(IJavaElementDelta delta) {
        return this.deltaFlagIsSet(delta, 128);
    }

    protected void processJavaPackageFragmentDelta(IJavaElementDelta delta) {
        this.processJavaDeltaChildren(delta);
    }

    protected void processJavaCompilationUnitDelta(IJavaElementDelta delta) {
        if (this.javaCompilationUnitDeltaIsRelevant(delta)) {
            ICompilationUnit compilationUnit = (ICompilationUnit)delta.getElement();
            for (JavaResourceCompilationUnit jrcu : this.getCombinedJavaResourceCompilationUnits()) {
                if (!jrcu.getCompilationUnit().equals(compilationUnit)) continue;
                jrcu.synchronizeWithJavaSource();
                break;
            }
        }
    }

    protected boolean javaCompilationUnitDeltaIsRelevant(IJavaElementDelta delta) {
        if (BitTools.onlyFlagIsSet((int)delta.getFlags(), (int)65536)) {
            return false;
        }
        return delta.getKind() == 4;
    }

    @Override
    public Iterable<IMessage> getValidationMessages(IReporter reporter) {
        ArrayList<IMessage> messages = new ArrayList<IMessage>();
        this.validate(messages, reporter);
        return new SnapshotCloneIterable(messages);
    }

    protected void validate(List<IMessage> messages, IReporter reporter) {
        if (reporter.isCancelled()) {
            throw new ValidationCancelledException();
        }
        this.getSchemaLibrary().refreshAllSchemas();
        this.validateLibraryProvider(messages);
        this.validateSchemaLibrary(messages);
        this.contextRoot.validate(messages, reporter);
    }

    protected void validateLibraryProvider(List<IMessage> messages) {
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)this.getProject());
        }
        catch (CoreException ce) {
            JptJaxbCorePlugin.log(ce);
        }
        IProjectFacetVersion facetVersion = facetedProject.getInstalledVersion(JaxbFacet.FACET);
        LibraryInstallDelegate lid = new LibraryInstallDelegate((IFacetedProjectBase)facetedProject, facetVersion);
        ILibraryProvider lp = lid.getLibraryProvider();
        if (lid.getLibraryProviderOperationConfig() instanceof JaxbLibraryProviderInstallOperationConfig) {
            ((JaxbLibraryProviderInstallOperationConfig)lid.getLibraryProviderOperationConfig()).setJaxbPlatform(this.getPlatform().getDescription());
        }
        if (!lp.isEnabledFor((IFacetedProjectBase)facetedProject, facetVersion) || !lid.validate().isOK()) {
            messages.add(DefaultValidationMessages.buildMessage(1, "PROJECT_INVALID_LIBRARY_PROVIDER", this));
        }
        lid.dispose();
    }

    protected void validateSchemaLibrary(List<IMessage> messages) {
        this.schemaLibrary.validate(messages);
    }

    @Override
    public void dispose() {
        this.contextModelSynchronizer.stop();
        this.updateSynchronizer.stop();
        this.updateSynchronizer.removeListener(this.updateSynchronizerListener);
        this.schemaLibrary.dispose();
        for (JaxbFile jaxbFile : this.getJaxbFiles()) {
            jaxbFile.getResourceModel().removeResourceModelListener(this.resourceModelListener);
        }
    }

    protected JptResourceModelListener buildResourceModelListener() {
        return new DefaultResourceModelListener();
    }

    protected void synchronizeContextModel(JptResourceModel jpaResourceModel) {
        this.synchronizeContextModel();
    }

    @Override
    public void projectChanged(IResourceDelta delta) {
        if (delta.getResource().equals((Object)this.getProject())) {
            this.internalProjectChanged(delta);
        }
    }

    protected void internalProjectChanged(IResourceDelta delta) {
        ResourceDeltaVisitor resourceDeltaVisitor = this.buildInternalResourceDeltaVisitor();
        resourceDeltaVisitor.visitDelta(delta);
        if (resourceDeltaVisitor.encounteredSignificantChange()) {
            this.resolveInternalJavaTypes();
        }
    }

    protected ResourceDeltaVisitor buildInternalResourceDeltaVisitor() {
        return new ResourceDeltaVisitor(){

            public boolean fileChangeIsSignificant(IFile file, int deltaKind) {
                return AbstractJaxbProject.this.synchronizeJaxbFiles(file, deltaKind);
            }
        };
    }

    protected boolean synchronizeJaxbFiles(IFile file, int deltaKind) {
        switch (deltaKind) {
            case 1: {
                return this.addJaxbFile(file);
            }
            case 2: {
                return this.removeJaxbFile(file);
            }
            case 4: {
                return this.checkForChangedFileContent(file);
            }
            case 8: {
                break;
            }
            case 16: {
                break;
            }
        }
        return false;
    }

    protected boolean checkForChangedFileContent(IFile file) {
        JaxbFile jaxbFile = this.getJaxbFile(file);
        if (jaxbFile == null) {
            return this.addJaxbFile(file);
        }
        if (jaxbFile.getContentType().equals(PlatformTools.getContentType((IFile)file))) {
            return false;
        }
        this.removeJaxbFile(jaxbFile);
        this.addJaxbFile(file);
        return true;
    }

    protected void resolveInternalJavaTypes() {
        for (JavaResourceCompilationUnit jrcu : this.getInternalJavaResourceCompilationUnits()) {
            jrcu.resolveTypes();
        }
    }

    @Override
    public void setThreadLocalModifySharedDocumentCommandExecutor(ExtendedCommandExecutor commandExecutor) {
        this.modifySharedDocumentCommandExecutor.set((CommandExecutor)commandExecutor);
    }

    @Override
    public ExtendedCommandExecutor getModifySharedDocumentCommandExecutor() {
        return this.modifySharedDocumentCommandExecutor;
    }

    @Override
    public Synchronizer getContextModelSynchronizer() {
        return this.contextModelSynchronizer;
    }

    @Override
    public void setContextModelSynchronizer(Synchronizer synchronizer) {
        if (synchronizer == null) {
            throw new NullPointerException();
        }
        this.contextModelSynchronizer.stop();
        this.setContextModelSynchronizer_(synchronizer);
    }

    protected void setContextModelSynchronizer_(Synchronizer synchronizer) {
        this.contextModelSynchronizer = synchronizer;
        this.contextModelSynchronizer.start();
    }

    @Override
    public void synchronizeContextModel() {
        this.synchronizingContextModel = true;
        this.contextModelSynchronizer.synchronize();
        this.synchronizingContextModel = false;
        this.update();
    }

    @Override
    public IStatus synchronizeContextModel(IProgressMonitor monitor) {
        this.contextRoot.synchronizeWithResourceModel();
        return Status.OK_STATUS;
    }

    @Override
    public void synchronizeContextModelAndWait() {
        Synchronizer temp = this.contextModelSynchronizer;
        this.setContextModelSynchronizer(this.buildSynchronousContextModelSynchronizer());
        this.synchronizeContextModel();
        this.setContextModelSynchronizer(temp);
    }

    protected Synchronizer buildSynchronousContextModelSynchronizer() {
        return new SynchronousSynchronizer(this.buildSynchronousContextModelSynchronizerCommand());
    }

    protected Command buildSynchronousContextModelSynchronizerCommand() {
        return new SynchronousContextModelSynchronizerCommand();
    }

    @Override
    public CallbackSynchronizer getUpdateSynchronizer() {
        return this.updateSynchronizer;
    }

    @Override
    public void setUpdateSynchronizer(CallbackSynchronizer synchronizer) {
        if (synchronizer == null) {
            throw new NullPointerException();
        }
        this.updateSynchronizer.stop();
        this.updateSynchronizer.removeListener(this.updateSynchronizerListener);
        this.setUpdateSynchronizer_(synchronizer);
    }

    protected void setUpdateSynchronizer_(CallbackSynchronizer synchronizer) {
        this.updateSynchronizer = synchronizer;
        this.updateSynchronizer.addListener(this.updateSynchronizerListener);
        this.updateSynchronizer.start();
    }

    @Override
    public void stateChanged() {
        super.stateChanged();
        this.update();
    }

    protected void update() {
        if (!this.synchronizingContextModel) {
            this.updateSynchronizer.synchronize();
        }
    }

    @Override
    public IStatus update(IProgressMonitor monitor) {
        this.contextRoot.update();
        return Status.OK_STATUS;
    }

    public void updateQuiesced() {
    }

    @Override
    public void updateAndWait() {
        CallbackSynchronizer temp = this.updateSynchronizer;
        this.setUpdateSynchronizer(this.buildSynchronousUpdateSynchronizer());
        this.update();
        this.setUpdateSynchronizer(temp);
    }

    protected CallbackSynchronizer buildSynchronousUpdateSynchronizer() {
        return new CallbackSynchronousSynchronizer(this.buildSynchronousUpdateSynchronizerCommand());
    }

    protected Command buildSynchronousUpdateSynchronizerCommand() {
        return new SynchronousUpdateSynchronizerCommand();
    }

    protected CallbackSynchronizer.Listener buildUpdateSynchronizerListener() {
        return new UpdateSynchronizerListener();
    }

    protected class DefaultResourceModelListener
    implements JptResourceModelListener {
        protected DefaultResourceModelListener() {
        }

        public void resourceModelChanged(JptResourceModel jpaResourceModel) {
            AbstractJaxbProject.this.synchronizeContextModel(jpaResourceModel);
        }

        public void resourceModelReverted(JptResourceModel jpaResourceModel) {
        }

        public void resourceModelUnloaded(JptResourceModel jpaResourceModel) {
        }
    }

    protected class InitialResourceProxyVisitor
    implements IResourceProxyVisitor {
        protected InitialResourceProxyVisitor() {
        }

        protected void visitProject(IProject p) {
            try {
                p.accept((IResourceProxyVisitor)this, 0);
            }
            catch (CoreException ex) {
                throw new RuntimeException(ex);
            }
        }

        public boolean visit(IResourceProxy resource) {
            switch (resource.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    return true;
                }
                case 2: {
                    return true;
                }
                case 1: {
                    AbstractJaxbProject.this.addJaxbFile_((IFile)resource.requestResource());
                    return false;
                }
            }
            return false;
        }
    }

    protected abstract class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        protected boolean encounteredSignificantChange = false;

        protected ResourceDeltaVisitor() {
        }

        protected void visitDelta(IResourceDelta delta) {
            try {
                delta.accept((IResourceDeltaVisitor)this);
            }
            catch (CoreException ex) {
                throw new RuntimeException(ex);
            }
        }

        public boolean visit(IResourceDelta delta) {
            IResource res = delta.getResource();
            switch (res.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    return true;
                }
                case 2: {
                    return true;
                }
                case 1: {
                    this.fileChanged((IFile)res, delta.getKind());
                    return false;
                }
            }
            return false;
        }

        protected void fileChanged(IFile file, int deltaKind) {
            if (this.fileChangeIsSignificant(file, deltaKind)) {
                this.encounteredSignificantChange = true;
            }
        }

        protected abstract boolean fileChangeIsSignificant(IFile var1, int var2);

        protected boolean encounteredSignificantChange() {
            return this.encounteredSignificantChange;
        }
    }

    protected class SynchronousContextModelSynchronizerCommand
    implements Command {
        protected SynchronousContextModelSynchronizerCommand() {
        }

        public void execute() {
            AbstractJaxbProject.this.synchronizeContextModel((IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected class SynchronousUpdateSynchronizerCommand
    implements Command {
        protected SynchronousUpdateSynchronizerCommand() {
        }

        public void execute() {
            AbstractJaxbProject.this.update((IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected class UpdateSynchronizerListener
    implements CallbackSynchronizer.Listener {
        protected UpdateSynchronizerListener() {
        }

        public void synchronizationQuiesced(CallbackSynchronizer synchronizer) {
            AbstractJaxbProject.this.updateQuiesced();
        }
    }
}

