/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.XmlID;
import org.eclipse.jpt.jaxb.core.context.XmlNamedNodeMapping;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.validation.DefaultValidationMessages;
import org.eclipse.jpt.jaxb.core.resource.java.XmlIDAnnotation;
import org.eclipse.jpt.jaxb.core.xsd.XsdFeature;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.jpt.jaxb.core.xsd.XsdUtil;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaXmlID
extends AbstractJavaContextNode
implements XmlID {
    protected final XmlIDAnnotation resourceXmlID;

    public GenericJavaXmlID(XmlNamedNodeMapping parent, XmlIDAnnotation resource) {
        super(parent);
        this.resourceXmlID = resource;
    }

    public XmlNamedNodeMapping getMapping() {
        return (XmlNamedNodeMapping)this.getParent();
    }

    protected JaxbPersistentAttribute getPersistentAttribute() {
        return this.getMapping().getPersistentAttribute();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateAttributeType(messages, astRoot);
        XsdFeature xsdFeature = this.getMapping().getXsdFeature();
        if (xsdFeature == null) {
            return;
        }
        XsdTypeDefinition idrefType = XsdUtil.getSchemaForSchema().getTypeDefinition("ID");
        if (!xsdFeature.typeIsValid(idrefType, false)) {
            messages.add(DefaultValidationMessages.buildMessage(1, "XML_ID__SCHEMA_TYPE_NOT_ID", new String[]{xsdFeature.getName()}, this, this.getValidationTextRange(astRoot)));
        }
    }

    protected void validateAttributeType(List<IMessage> messages, CompilationUnit astRoot) {
        if (!this.getPersistentAttribute().isJavaResourceAttributeTypeSubTypeOf(String.class.getName())) {
            messages.add(DefaultValidationMessages.buildMessage(1, "XML_ID__ATTRIBUTE_TYPE_NOT_STRING", this, this.getValidationTextRange(astRoot)));
        }
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.resourceXmlID.getTextRange(astRoot);
    }
}

