/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.jaxb.core.JaxbNode;
import org.eclipse.jpt.jaxb.core.context.JaxbClassMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.java.JavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.jpt.jaxb.eclipselink.core.context.java.ELClassMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.context.java.ELXmlJoinNode;
import org.eclipse.jpt.jaxb.eclipselink.core.context.java.ELXmlJoinNodesMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.xpath.java.XPath;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.xpath.java.XPathFactory;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.validation.ELJaxbValidationMessageBuilder;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.java.XmlJoinNodeAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELJavaXmlJoinNode
extends AbstractJavaContextNode
implements ELXmlJoinNode {
    protected String xmlPath;
    protected String referencedXmlPath;
    protected Context context;

    public ELJavaXmlJoinNode(JavaContextNode parent, Context context) {
        super((JaxbNode)parent);
        this.context = context;
        this.initXmlPath();
        this.initReferencedXmlPath();
    }

    protected JaxbPackage getJaxbPackage() {
        return this.getClassMapping().getJaxbType().getJaxbPackage();
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncXmlPath();
        this.syncReferencedXmlPath();
    }

    @Override
    public String getXmlPath() {
        return this.xmlPath;
    }

    @Override
    public void setXmlPath(String xmlPath) {
        this.getAnnotation().setXmlPath(xmlPath);
        this.setXmlPath_(xmlPath);
    }

    protected void setXmlPath_(String xmlPath) {
        String old = this.xmlPath;
        this.xmlPath = xmlPath;
        this.firePropertyChanged("xmlPath", old, this.xmlPath);
    }

    protected void initXmlPath() {
        this.xmlPath = this.getAnnotation().getXmlPath();
    }

    protected void syncXmlPath() {
        this.setXmlPath_(this.getAnnotation().getXmlPath());
    }

    @Override
    public String getReferencedXmlPath() {
        return this.referencedXmlPath;
    }

    @Override
    public void setReferencedXmlPath(String referencedXmlPath) {
        this.getAnnotation().setReferencedXmlPath(referencedXmlPath);
        this.setReferencedXmlPath_(referencedXmlPath);
    }

    protected void setReferencedXmlPath_(String referencedXmlPath) {
        String old = this.referencedXmlPath;
        this.referencedXmlPath = referencedXmlPath;
        this.firePropertyChanged("referencedXmlPath", old, this.referencedXmlPath);
    }

    protected void initReferencedXmlPath() {
        this.referencedXmlPath = this.getAnnotation().getReferencedXmlPath();
    }

    protected void syncReferencedXmlPath() {
        this.setReferencedXmlPath_(this.getAnnotation().getReferencedXmlPath());
    }

    protected XmlJoinNodeAnnotation getAnnotation() {
        return this.context.getAnnotation();
    }

    protected ELXmlJoinNodesMapping getAttributeMapping() {
        return this.context.getAttributeMapping();
    }

    protected JaxbClassMapping getClassMapping() {
        return this.getAttributeMapping().getClassMapping();
    }

    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        if (this.getAnnotation().xmlPathTouches(pos, astRoot) && this.xmlPath != null) {
            XsdTypeDefinition xsdType = this.getClassMapping().getXsdTypeDefinition();
            XPath xpath = XPathFactory.instance().getXpath(this.xmlPath);
            return xpath.getCompletionProposals(new XmlPathContext(astRoot), xsdType, pos, filter);
        }
        if (this.getAnnotation().referencedXmlPathTouches(pos, astRoot) && this.referencedXmlPath != null) {
            XsdTypeDefinition xsdType = this.getAttributeMapping().getReferencedXsdTypeDefinition();
            XPath xpath = XPathFactory.instance().getXpath(this.referencedXmlPath);
            CompositeIterable result = xpath.getCompletionProposals(new ReferencedXmlPathContext(astRoot), xsdType, pos, filter);
            ELClassMapping referencedClassMapping = this.context.getAttributeMapping().getReferencedClassMapping();
            if (referencedClassMapping != null) {
                result = new CompositeIterable(new Iterable[]{result, StringTools.convertToJavaStringLiterals(referencedClassMapping.getKeyXPaths())});
            }
            return CollectionTools.sortedSet(result);
        }
        return EmptyIterable.instance();
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getAnnotation().getTextRange(astRoot);
    }

    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateXmlPath(messages, astRoot);
        this.validateReferencedXmlPath(messages, astRoot);
    }

    protected void validateXmlPath(List<IMessage> messages, CompilationUnit astRoot) {
        if (StringTools.stringIsEmpty((String)this.xmlPath)) {
            messages.add(ELJaxbValidationMessageBuilder.buildMessage(1, "XML_JOIN_NODE__XML_PATH_NOT_SPECIFIED", (JaxbNode)this, this.getXmlPathTextRange(astRoot)));
            return;
        }
        if (this.xmlPath.startsWith(XPath.DELIM)) {
            messages.add(ELJaxbValidationMessageBuilder.buildMessage(1, "XPATH__ROOT_NOT_SUPPORTED", (JaxbNode)this, this.getXmlPathTextRange(astRoot)));
            return;
        }
        XsdTypeDefinition xsdType = this.getClassMapping().getXsdTypeDefinition();
        XPath xpath = XPathFactory.instance().getXpath(this.xmlPath);
        xpath.validate(new XmlPathContext(astRoot), xsdType, messages);
    }

    protected void validateReferencedXmlPath(List<IMessage> messages, CompilationUnit astRoot) {
        if (StringTools.stringIsEmpty((String)this.referencedXmlPath)) {
            messages.add(ELJaxbValidationMessageBuilder.buildMessage(1, "XML_JOIN_NODE__REFERENCED_XML_PATH_NOT_SPECIFIED", (JaxbNode)this, this.getReferencedXmlPathTextRange(astRoot)));
            return;
        }
        if (this.referencedXmlPath.startsWith(XPath.DELIM)) {
            messages.add(ELJaxbValidationMessageBuilder.buildMessage(1, "XPATH__ROOT_NOT_SUPPORTED", (JaxbNode)this, this.getReferencedXmlPathTextRange(astRoot)));
            return;
        }
        ELClassMapping referencedClassMapping = this.context.getAttributeMapping().getReferencedClassMapping();
        if (referencedClassMapping != null && !CollectionTools.contains(referencedClassMapping.getKeyXPaths(), (Object)this.referencedXmlPath)) {
            messages.add(ELJaxbValidationMessageBuilder.buildMessage(1, "XML_JOIN_NODE__REFERENCED_XML_PATH_NOT_IN_REFERENCED_CLASS_KEYS", new String[]{referencedClassMapping.getJaxbType().getFullyQualifiedName(), this.referencedXmlPath}, (JaxbNode)this, this.getReferencedXmlPathTextRange(astRoot)));
        }
        XsdTypeDefinition xsdType = this.getAttributeMapping().getReferencedXsdTypeDefinition();
        XPath xpath = XPathFactory.instance().getXpath(this.referencedXmlPath);
        xpath.validate(new ReferencedXmlPathContext(astRoot), xsdType, messages);
    }

    protected TextRange getXmlPathTextRange(CompilationUnit astRoot) {
        return this.getAnnotation().getXmlPathTextRange(astRoot);
    }

    protected TextRange getReferencedXmlPathTextRange(CompilationUnit astRoot) {
        return this.getAnnotation().getReferencedXmlPathTextRange(astRoot);
    }

    public static interface Context {
        public XmlJoinNodeAnnotation getAnnotation();

        public ELXmlJoinNodesMapping getAttributeMapping();
    }

    protected class ReferencedXmlPathContext
    extends XPathContext {
        protected ReferencedXmlPathContext(CompilationUnit astRoot) {
            super(astRoot);
        }

        public TextRange getTextRange() {
            return ELJavaXmlJoinNode.this.getReferencedXmlPathTextRange(this.astRoot);
        }
    }

    protected abstract class XPathContext
    implements XPath.Context {
        protected CompilationUnit astRoot;

        protected XPathContext(CompilationUnit astRoot) {
            this.astRoot = astRoot;
        }

        public JaxbNode getContextObject() {
            return ELJavaXmlJoinNode.this;
        }

        public JaxbPackage getJaxbPackage() {
            return ELJavaXmlJoinNode.this.getJaxbPackage();
        }
    }

    protected class XmlPathContext
    extends XPathContext {
        protected XmlPathContext(CompilationUnit astRoot) {
            super(astRoot);
        }

        public TextRange getTextRange() {
            return ELJavaXmlJoinNode.this.getXmlPathTextRange(this.astRoot);
        }
    }
}

