/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.internal.validation;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IResource;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jaxb.core.JaxbNode;
import org.eclipse.jpt.jaxb.core.internal.validation.DefaultValidationMessages;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public class ELJaxbValidationMessageBuilder {
    private static String[] DEFAULT_PARMS = new String[0];
    private static TextRange DEFAULT_TEXT_RANGE = TextRange.Empty.instance();
    private static final DefaultValidationMessages.MessageFactory MESSAGE_FACTORY = new EclipseLinkMessageFactory();

    public static IMessage buildMessage(int defaultSeverity, String messageId, JaxbNode targetObject) {
        return ELJaxbValidationMessageBuilder.buildMessage(defaultSeverity, messageId, targetObject.getResource());
    }

    public static IMessage buildMessage(int defaultSeverity, String messageId, IResource targetObject) {
        return ELJaxbValidationMessageBuilder.buildMessage(defaultSeverity, messageId, DEFAULT_PARMS, targetObject);
    }

    public static IMessage buildMessage(int defaultSeverity, String messageId, String[] parms, JaxbNode targetObject) {
        return ELJaxbValidationMessageBuilder.buildMessage(defaultSeverity, messageId, parms, targetObject.getResource());
    }

    public static IMessage buildMessage(int defaultSeverity, String messageId, String[] parms, IResource targetObject) {
        return ELJaxbValidationMessageBuilder.buildMessage(defaultSeverity, messageId, parms, targetObject, DEFAULT_TEXT_RANGE);
    }

    public static IMessage buildMessage(int defaultSeverity, String messageId, JaxbNode targetObject, TextRange textRange) {
        return ELJaxbValidationMessageBuilder.buildMessage(defaultSeverity, messageId, targetObject.getResource(), textRange);
    }

    public static IMessage buildMessage(int defaultSeverity, String messageId, IResource targetObject, TextRange textRange) {
        return ELJaxbValidationMessageBuilder.buildMessage(defaultSeverity, messageId, DEFAULT_PARMS, targetObject, textRange);
    }

    public static IMessage buildMessage(int defaultSeverity, String messageId, String[] parms, JaxbNode targetObject, TextRange textRange) {
        return ELJaxbValidationMessageBuilder.buildMessage(defaultSeverity, messageId, parms, targetObject.getResource(), textRange);
    }

    public static IMessage buildMessage(int defaultSeverity, String messageId, String[] parms, IResource targetObject, TextRange textRange) {
        return DefaultValidationMessages.buildMessage((int)defaultSeverity, (String)messageId, (String[])parms, (IResource)targetObject, (TextRange)textRange, (DefaultValidationMessages.MessageFactory)MESSAGE_FACTORY);
    }

    private ELJaxbValidationMessageBuilder() {
        throw new UnsupportedOperationException();
    }

    static class EclipseLinkMessage
    extends Message {
        EclipseLinkMessage(String bundleName, int severity, String id, String[] params, Object target) {
            super(bundleName, severity, id, params, target);
        }

        public ResourceBundle getBundle(Locale locale, ClassLoader classLoader) {
            try {
                return super.getBundle(locale, ((Object)((Object)this)).getClass().getClassLoader());
            }
            catch (MissingResourceException missingResourceException) {
                return super.getBundle(locale, classLoader);
            }
        }
    }

    static class EclipseLinkMessageFactory
    implements DefaultValidationMessages.MessageFactory {
        EclipseLinkMessageFactory() {
        }

        public IMessage buildMessage(int severity, String messageId, String[] parms, IResource targetObject) {
            EclipseLinkMessage message = new EclipseLinkMessage("el_jaxb_validation", severity, messageId, parms, targetObject);
            message.setMarkerId("org.eclipse.jpt.jaxb.core.jaxbProblemMarker");
            return message;
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }
}

