/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.platform;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jpt.common.core.internal.utility.XPointTools;
import org.eclipse.jpt.common.utility.internal.KeyedSet;
import org.eclipse.jpt.common.utility.internal.iterables.SuperIterableWrapper;
import org.eclipse.jpt.jpa.core.JpaFacet;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.internal.platform.JpaPlatformDescriptionImpl;
import org.eclipse.jpt.jpa.core.internal.platform.JpaPlatformGroupDescriptionImpl;
import org.eclipse.jpt.jpa.core.platform.JpaPlatformDescription;
import org.eclipse.jpt.jpa.core.platform.JpaPlatformGroupDescription;
import org.eclipse.jpt.jpa.core.platform.JpaPlatformManager;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaPlatformManagerImpl
implements JpaPlatformManager {
    static final String EXTENSION_POINT_ID = "jpaPlatforms";
    static final String QUALIFIED_EXTENSION_POINT_ID = "org.eclipse.jpt.jpa.core.jpaPlatforms";
    static final String PLATFORM_GROUP_ELEMENT = "jpaPlatformGroup";
    static final String PLATFORM_ELEMENT = "jpaPlatform";
    static final String ID_ATTRIBUTE = "id";
    static final String LABEL_ATTRIBUTE = "label";
    static final String FACTORY_CLASS_ATTRIBUTE = "factoryClass";
    static final String JPA_FACET_VERSION_ATTRIBUTE = "jpaFacetVersion";
    static final String DEFAULT_ATTRIBUTE = "default";
    static final String GROUP_ELEMENT = "group";
    private static final JpaPlatformManagerImpl INSTANCE = new JpaPlatformManagerImpl();
    private KeyedSet<String, JpaPlatformGroupDescriptionImpl> jpaPlatformGroupDescriptions = new KeyedSet();
    private KeyedSet<String, JpaPlatformDescriptionImpl> jpaPlatformDescriptions = new KeyedSet();

    public static JpaPlatformManagerImpl instance() {
        return INSTANCE;
    }

    private JpaPlatformManagerImpl() {
        this.readExtensions();
    }

    private void readExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint xpoint = registry.getExtensionPoint("org.eclipse.jpt.jpa.core", EXTENSION_POINT_ID);
        if (xpoint == null) {
            throw new IllegalStateException();
        }
        ArrayList<IConfigurationElement> platformGroupConfigs = new ArrayList<IConfigurationElement>();
        ArrayList<IConfigurationElement> platformConfigs = new ArrayList<IConfigurationElement>();
        IExtension[] iExtensionArray = xpoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equals(PLATFORM_GROUP_ELEMENT)) {
                    platformGroupConfigs.add(element);
                } else if (element.getName().equals(PLATFORM_ELEMENT)) {
                    platformConfigs.add(element);
                }
                ++n4;
            }
            ++n2;
        }
        for (IConfigurationElement element : platformGroupConfigs) {
            this.readPlatformGroupExtension(element);
        }
        for (IConfigurationElement element : platformConfigs) {
            this.readPlatformExtension(element);
        }
    }

    private void readPlatformGroupExtension(IConfigurationElement element) {
        try {
            JpaPlatformGroupDescriptionImpl desc = new JpaPlatformGroupDescriptionImpl();
            desc.setPluginId(element.getContributor().getName());
            desc.setId(XPointTools.findRequiredAttribute((IConfigurationElement)element, (String)ID_ATTRIBUTE));
            if (this.jpaPlatformGroupDescriptions.containsKey((Object)desc.getId())) {
                XPointTools.logDuplicateExtension((String)QUALIFIED_EXTENSION_POINT_ID, (String)ID_ATTRIBUTE, (String)desc.getId());
                throw new XPointTools.XPointException();
            }
            desc.setLabel(XPointTools.findRequiredAttribute((IConfigurationElement)element, (String)LABEL_ATTRIBUTE));
            this.jpaPlatformGroupDescriptions.addItem((Object)desc.getId(), (Object)desc);
        }
        catch (XPointTools.XPointException xPointException) {}
    }

    private void readPlatformExtension(IConfigurationElement element) {
        try {
            String groupId;
            String defaultString;
            JpaPlatformDescriptionImpl desc = new JpaPlatformDescriptionImpl();
            desc.setPluginId(element.getContributor().getName());
            desc.setId(XPointTools.findRequiredAttribute((IConfigurationElement)element, (String)ID_ATTRIBUTE));
            if (this.jpaPlatformDescriptions.containsKey((Object)desc.getId())) {
                XPointTools.logDuplicateExtension((String)QUALIFIED_EXTENSION_POINT_ID, (String)ID_ATTRIBUTE, (String)desc.getId());
                throw new XPointTools.XPointException();
            }
            desc.setLabel(XPointTools.findRequiredAttribute((IConfigurationElement)element, (String)LABEL_ATTRIBUTE));
            desc.setFactoryClassName(XPointTools.findRequiredAttribute((IConfigurationElement)element, (String)FACTORY_CLASS_ATTRIBUTE));
            String jpaFacetVersionString = element.getAttribute(JPA_FACET_VERSION_ATTRIBUTE);
            if (jpaFacetVersionString != null) {
                IProjectFacetVersion jpaFacetVersion = JpaFacet.FACET.getVersion(jpaFacetVersionString);
                if (jpaFacetVersion != null) {
                    desc.setJpaFacetVersion(jpaFacetVersion);
                } else {
                    XPointTools.logInvalidValue((IConfigurationElement)element, (String)JPA_FACET_VERSION_ATTRIBUTE, (String)jpaFacetVersionString);
                    throw new XPointTools.XPointException();
                }
            }
            if ((defaultString = element.getAttribute(DEFAULT_ATTRIBUTE)) != null) {
                if (defaultString.equals("true")) {
                    desc.setDefault(true);
                } else if (defaultString.equals("false")) {
                    desc.setDefault(false);
                } else {
                    XPointTools.logInvalidValue((IConfigurationElement)element, (String)DEFAULT_ATTRIBUTE, (String)defaultString);
                    throw new XPointTools.XPointException();
                }
            }
            if ((groupId = element.getAttribute(GROUP_ELEMENT)) != null) {
                JpaPlatformGroupDescriptionImpl group = (JpaPlatformGroupDescriptionImpl)this.jpaPlatformGroupDescriptions.getItem((Object)groupId);
                if (group != null) {
                    desc.setGroup(group);
                    group.addPlatform(desc);
                } else {
                    XPointTools.logInvalidValue((IConfigurationElement)element, (String)GROUP_ELEMENT, (String)groupId);
                    throw new XPointTools.XPointException();
                }
            }
            this.jpaPlatformDescriptions.addItem((Object)desc.getId(), (Object)desc);
        }
        catch (XPointTools.XPointException xPointException) {}
    }

    @Override
    public Iterable<JpaPlatformGroupDescription> getJpaPlatformGroups() {
        return new SuperIterableWrapper((Iterable)this.jpaPlatformGroupDescriptions.getItemSet());
    }

    @Override
    public JpaPlatformGroupDescription getJpaPlatformGroup(String groupId) {
        return (JpaPlatformGroupDescription)this.jpaPlatformGroupDescriptions.getItem((Object)groupId);
    }

    @Override
    public Iterable<JpaPlatformDescription> getJpaPlatforms() {
        return new SuperIterableWrapper((Iterable)this.jpaPlatformDescriptions.getItemSet());
    }

    @Override
    public JpaPlatformDescription getJpaPlatform(String platformId) {
        return (JpaPlatformDescription)this.jpaPlatformDescriptions.getItem((Object)platformId);
    }

    @Override
    public JpaPlatformDescription getDefaultJpaPlatform(IProjectFacetVersion jpaFacetVersion) {
        for (JpaPlatformDescription platform : this.getJpaPlatforms()) {
            if (!platform.isDefault() || !platform.supportsJpaFacetVersion(jpaFacetVersion)) continue;
            return platform;
        }
        return null;
    }

    @Override
    public JpaPlatform buildJpaPlatformImplementation(IProject project) {
        String jpaPlatformId = JptJpaCorePlugin.getJpaPlatformId(project);
        JpaPlatformDescriptionImpl platformDesc = (JpaPlatformDescriptionImpl)this.jpaPlatformDescriptions.getItem((Object)jpaPlatformId);
        if (platformDesc == null) {
            throw new IllegalArgumentException("Project does not have a recognized JPA platform: " + jpaPlatformId);
        }
        return platformDesc.buildJpaPlatform();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

