/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.jpql.spi;

import org.eclipse.jdt.core.BindingKey;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jpt.jpa.core.jpql.spi.JpaType;
import org.eclipse.jpt.jpa.core.jpql.spi.JpaTypeDeclaration;
import org.eclipse.persistence.jpa.jpql.spi.IConstructor;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeDeclaration;
import org.eclipse.persistence.jpa.jpql.spi.ITypeRepository;

public class ClassConstructor
implements IConstructor {
    private IMethod method;
    private JpaType type;
    private ITypeDeclaration[] typeDeclarations;

    public ClassConstructor(JpaType type, IMethod method) {
        this.type = type;
        this.method = method;
    }

    protected ITypeDeclaration[] buildParameterTypes() {
        BindingKey bindingKey = new BindingKey(this.method.getKey());
        String signature = bindingKey.toSignature();
        int count = Signature.getParameterCount((String)signature);
        ITypeDeclaration[] typeDeclarations = new ITypeDeclaration[count];
        int index = 0;
        String[] stringArray = Signature.getParameterTypes((String)signature);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String parameterType = stringArray[n2];
            String parameterTypeName = Signature.getTypeErasure((String)parameterType);
            parameterTypeName = Signature.toString((String)parameterTypeName);
            typeDeclarations[index++] = new JpaTypeDeclaration(this.getTypeRepository().getType(parameterTypeName), this.buildTypeParameters(parameterType), Signature.getArrayCount((String)parameterType));
            ++n2;
        }
        return typeDeclarations;
    }

    protected ITypeDeclaration[] buildTypeParameters(String signature) {
        String[] typeParameters = Signature.getTypeArguments((String)signature);
        ITypeDeclaration[] generics = new ITypeDeclaration[typeParameters.length];
        int index = 0;
        while (index < typeParameters.length) {
            String typeParameter = typeParameters[index];
            switch (Signature.getTypeSignatureKind((String)typeParameter)) {
                case 5: {
                    typeParameter = typeParameter.substring(1);
                }
            }
            if (typeParameter.length() == 0) {
                generics[index] = this.getTypeRepository().getTypeHelper().objectTypeDeclaration();
            } else {
                String typeParameterName = Signature.getTypeErasure((String)typeParameter);
                typeParameterName = Signature.toString((String)typeParameterName);
                IType genericType = this.getTypeRepository().getType(typeParameterName);
                generics[index] = genericType.isResolvable() ? genericType.getTypeDeclaration() : this.getTypeRepository().getTypeHelper().objectTypeDeclaration();
            }
            ++index;
        }
        return generics;
    }

    public ITypeDeclaration[] getParameterTypes() {
        if (this.typeDeclarations == null) {
            this.typeDeclarations = this.buildParameterTypes();
        }
        return this.typeDeclarations;
    }

    protected ITypeRepository getTypeRepository() {
        return this.type.getTypeRepository();
    }
}

