/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.jdt.CombinationIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementIndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.jpa.eclipselink.core.internal.resource.java.source.SourceEclipseLinkNamedConverterAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkStructConverterAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceEclipseLinkStructConverterAnnotation
extends SourceEclipseLinkNamedConverterAnnotation
implements EclipseLinkStructConverterAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.annotations.StructConverter");
    private static final DeclarationAnnotationAdapter CONTAINER_DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.annotations.StructConverters");
    private final DeclarationAnnotationElementAdapter<String> converterDeclarationAdapter = this.buildConverterDeclarationAdapter();
    private final AnnotationElementAdapter<String> converterAdapter = this.buildConverterAdapter();
    private String converter;
    private TextRange converterTextRange;

    public static SourceEclipseLinkStructConverterAnnotation buildSourceStructConverterAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element, int index) {
        IndexedDeclarationAnnotationAdapter idaa = SourceEclipseLinkStructConverterAnnotation.buildStructConverterDeclarationAnnotationAdapter(index);
        IndexedAnnotationAdapter iaa = SourceEclipseLinkStructConverterAnnotation.buildStructConverterAnnotationAdapter(element, idaa);
        return new SourceEclipseLinkStructConverterAnnotation(parent, element, idaa, iaa);
    }

    private SourceEclipseLinkStructConverterAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element, IndexedDeclarationAnnotationAdapter daa, IndexedAnnotationAdapter annotationAdapter) {
        super(parent, element, daa, annotationAdapter);
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.StructConverter";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.converter = this.buildConverter(astRoot);
        this.converterTextRange = this.buildConverterTextRange(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        this.syncConverter(this.buildConverter(astRoot));
        this.converterTextRange = this.buildConverterTextRange(astRoot);
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.converter == null;
    }

    @Override
    String getNameElementName() {
        return "name";
    }

    @Override
    public String getConverter() {
        return this.converter;
    }

    @Override
    public void setConverter(String converter) {
        if (this.attributeValueHasChanged(this.converter, converter)) {
            this.converter = converter;
            this.converterAdapter.setValue((Object)converter);
        }
    }

    private void syncConverter(String astConverter) {
        String old = this.converter;
        this.converter = astConverter;
        this.firePropertyChanged("converter", old, astConverter);
    }

    private String buildConverter(CompilationUnit astRoot) {
        return (String)this.converterAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getConverterTextRange() {
        return this.converterTextRange;
    }

    private TextRange buildConverterTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.converterDeclarationAdapter, astRoot);
    }

    private DeclarationAnnotationElementAdapter<String> buildConverterDeclarationAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)this.daa, (String)"converter");
    }

    private AnnotationElementAdapter<String> buildConverterAdapter() {
        return this.buildStringElementAdapter(this.converterDeclarationAdapter);
    }

    private static IndexedAnnotationAdapter buildStructConverterAnnotationAdapter(AnnotatedElement annotatedElement, IndexedDeclarationAnnotationAdapter idaa) {
        return new ElementIndexedAnnotationAdapter(annotatedElement, idaa);
    }

    private static IndexedDeclarationAnnotationAdapter buildStructConverterDeclarationAnnotationAdapter(int index) {
        CombinationIndexedDeclarationAnnotationAdapter idaa = new CombinationIndexedDeclarationAnnotationAdapter(DECLARATION_ANNOTATION_ADAPTER, CONTAINER_DECLARATION_ANNOTATION_ADAPTER, index, "org.eclipse.persistence.annotations.StructConverter");
        return idaa;
    }
}

