/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.actions.link;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.actions.link.ExtensionReader;
import org.eclipse.jst.pagedesigner.actions.link.ILinkCreator;
import org.eclipse.jst.pagedesigner.commands.DesignerCommand;
import org.eclipse.jst.pagedesigner.viewer.DesignRange;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MakeLinkCommand
extends DesignerCommand {
    private String _identifier = null;
    private EditPart _part = null;
    private DesignRange _range = null;
    private ILinkCreator _linkcreator = null;
    private Element _ele = null;

    public MakeLinkCommand(String identifier, IHTMLGraphicalViewer viewer, EditPart part, DesignRange range) {
        super(identifier, viewer);
        this.setLabel(PDPlugin.getResourceString("MakeLinkCommand.Label.MakeLink"));
        this._identifier = identifier;
        this._part = part;
        this._range = range;
    }

    public boolean canExecute() {
        List<ILinkCreator> creators = ExtensionReader.getAllLinkHandlers();
        if (creators != null) {
            for (ILinkCreator linkCreator : creators) {
                String identifier = linkCreator.getLinkIdentifier();
                if (!this._identifier.equalsIgnoreCase(identifier)) continue;
                this._linkcreator = linkCreator;
                break;
            }
        }
        if (this._linkcreator != null) {
            return this._linkcreator.canExecute(this._range);
        }
        return super.canExecute();
    }

    protected void doExecute() {
        if (this._linkcreator != null) {
            Element ele = this._linkcreator.makeLinkElement(this._part, this._range);
            Node node = (Node)this._part.getModel();
            Node parent = node.getParentNode();
            this.formatNode(parent);
            this._ele = ele;
        }
    }

    protected ISelection getAfterCommandDesignerSelection() {
        return this.toDesignSelection(this._ele);
    }
}

