/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.app.dbtool.core;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jubula.app.dbtool.i18n.Messages;
import org.eclipse.jubula.client.archive.businessprocess.FileStorageBP;
import org.eclipse.jubula.client.cmd.AbstractCmdlineClient;
import org.eclipse.jubula.client.cmd.JobConfiguration;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.DatabaseConnectionInfo;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.core.persistence.TestResultPM;
import org.eclipse.jubula.client.core.persistence.TestResultSummaryPM;
import org.eclipse.jubula.client.core.progress.IProgressConsole;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.exception.JBFatalException;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.utils.TimeUtil;
import org.eclipse.osgi.util.NLS;

public class DBToolClient
extends AbstractCmdlineClient {
    private static final String OPTION_DELETE = "delete";
    private static final String OPTION_DELETE_ALL = "deleteall";
    private static final String OPTION_KEEPSUMMARY_ON_DELETE = "keepsummary";
    private static final String PAR_PROJECT = "project-name project-version";
    private static final String OPTION_EXPORT_ALL = "exportall";
    private static final String OPTION_EXPORT = "export";
    private static final String OPTION_DIR = "directory";
    private static final String PAR_DIR = "directory path";
    private static final String OPTION_IMPORT = "import";
    private static final String PAR_IMPORT = "import file";
    private static DBToolClient instance;

    private DBToolClient() {
    }

    public static DBToolClient getInstance() {
        if (instance == null) {
            instance = new DBToolClient();
        }
        return instance;
    }

    protected void extendOptions(Options opt, boolean req) {
        Option delOption = DBToolClient.createOption((String)OPTION_DELETE, (boolean)true, (String)PAR_PROJECT, (String)Messages.DBToolDelete, (boolean)false);
        delOption.setArgs(2);
        opt.addOption(delOption);
        opt.addOption(DBToolClient.createOption((String)OPTION_DELETE_ALL, (boolean)false, null, (String)Messages.DBToolDeleteAll, (boolean)false));
        opt.addOption(DBToolClient.createOption((String)OPTION_KEEPSUMMARY_ON_DELETE, (boolean)false, null, (String)Messages.DBToolDeleteKeepSummary, (boolean)false));
        opt.addOption(DBToolClient.createOption((String)OPTION_DIR, (boolean)true, (String)PAR_DIR, (String)Messages.DBToolDir, (boolean)false));
        opt.addOption(DBToolClient.createOption((String)OPTION_EXPORT_ALL, (boolean)false, null, (String)Messages.DBToolExportAll, (boolean)false));
        Option exportOption = DBToolClient.createOption((String)OPTION_EXPORT, (boolean)true, (String)PAR_PROJECT, (String)Messages.DBToolExport, (boolean)false);
        exportOption.setArgs(2);
        opt.addOption(exportOption);
        opt.addOption(DBToolClient.createOption((String)OPTION_IMPORT, (boolean)true, (String)PAR_IMPORT, (String)Messages.DBToolImport, (boolean)false));
    }

    protected void extendValidate(JobConfiguration job, StringBuilder errorMsgs) {
        String[] args = this.getCmdLine().getOptionValues(OPTION_DELETE);
        if (args != null && args.length != 2) {
            this.appendError(errorMsgs, OPTION_DELETE, PAR_PROJECT);
        }
        if ((args = this.getCmdLine().getOptionValues(OPTION_EXPORT)) != null && args.length != 2) {
            this.appendError(errorMsgs, OPTION_EXPORT, PAR_PROJECT);
        }
    }

    public int doRun() {
        Job dbToolOperation = new Job(Messages.DBToolPerforming){

            protected IStatus run(IProgressMonitor monitor) {
                String[] projValues;
                String[] projValues2;
                boolean keepTRSummaries;
                monitor.beginTask(Messages.DBToolPerforming, -1);
                DBToolClient.this.setupDB();
                CommandLine cmdLine = DBToolClient.this.getCmdLine();
                boolean bl = keepTRSummaries = cmdLine.hasOption(DBToolClient.OPTION_KEEPSUMMARY_ON_DELETE);
                if (cmdLine.hasOption(DBToolClient.OPTION_DELETE) && (projValues2 = cmdLine.getOptionValues(DBToolClient.OPTION_DELETE)) != null && projValues2.length == 2) {
                    DBToolClient.this.deleteProject(projValues2[0], projValues2[1], keepTRSummaries, monitor);
                }
                if (cmdLine.hasOption(DBToolClient.OPTION_DELETE_ALL)) {
                    DBToolClient.this.deleteAllProjects(keepTRSummaries, monitor);
                }
                String projectDir = cmdLine.getOptionValue(DBToolClient.OPTION_DIR, ".");
                if (cmdLine.hasOption(DBToolClient.OPTION_EXPORT) && (projValues = cmdLine.getOptionValues(DBToolClient.OPTION_EXPORT)) != null && projValues.length == 2) {
                    DBToolClient.this.exportProject(projValues[0], projValues[1], projectDir, monitor);
                }
                if (cmdLine.hasOption(DBToolClient.OPTION_EXPORT_ALL)) {
                    DBToolClient.this.exportAll(projectDir, monitor);
                }
                if (cmdLine.hasOption(DBToolClient.OPTION_IMPORT)) {
                    DBToolClient.this.importProject(cmdLine.getOptionValue(DBToolClient.OPTION_IMPORT), projectDir, monitor);
                }
                return Status.OK_STATUS;
            }
        };
        dbToolOperation.schedule();
        while (dbToolOperation.getState() != 0) {
            TimeUtil.delay((long)500L);
        }
        IStatus result = dbToolOperation.getResult();
        if (result.getSeverity() == 0) {
            return 0;
        }
        return 1;
    }

    private void importProject(String fileName, String exportDir, IProgressMonitor monitor) {
        File impFile = new File(fileName);
        if (!impFile.isAbsolute()) {
            impFile = new File(new File(exportDir), fileName);
        }
        try {
            ArrayList<URL> fileURLs = new ArrayList<URL>(1);
            fileURLs.add(impFile.toURI().toURL());
            FileStorageBP.importFiles(fileURLs, (IProgressMonitor)monitor, (IProgressConsole)this, (boolean)false);
        }
        catch (PMException pme) {
            this.writeErrorLine(pme.getLocalizedMessage());
        }
        catch (ProjectDeletedException gdpde) {
            this.writeErrorLine(gdpde.getLocalizedMessage());
        }
        catch (MalformedURLException e) {
            this.writeErrorLine(e.getLocalizedMessage());
        }
    }

    private void exportProject(String name, String version, String exportDir, IProgressMonitor monitor) {
        int[] versionNrs = this.buildVersionNrs(name, version);
        if (versionNrs != null) {
            File export = new File(exportDir);
            if (!export.isDirectory() || !export.canWrite()) {
                this.reportBadDirectory(exportDir);
                return;
            }
            String dirName = String.valueOf(export.getAbsolutePath()) + File.separator;
            EntityManager session = Persistor.instance().openSession();
            try {
                List projects = ProjectPM.findAllProjects((EntityManager)session);
                ArrayList<IProjectPO> exportProjects = new ArrayList<IProjectPO>(1);
                for (IProjectPO project : projects) {
                    if (!project.getName().equals(name) || !project.getMajorProjectVersion().equals(new Integer(versionNrs[0])) || !project.getMinorProjectVersion().equals(new Integer(versionNrs[1]))) continue;
                    exportProjects.add(project);
                }
                if (exportProjects.size() == 0) {
                    this.reportMissingProject(name, version);
                    return;
                }
                try {
                    ArrayList listOfProjectFiles = new ArrayList(exportProjects.size());
                    FileStorageBP.exportProjectList(exportProjects, (String)dirName, (EntityManager)session, (IProgressMonitor)monitor, (boolean)false, listOfProjectFiles, (IProgressConsole)this);
                }
                catch (JBException e) {
                    this.reportExportAllFailed(exportDir, e);
                }
                catch (InterruptedException interruptedException) {}
            }
            finally {
                Persistor.instance().dropSession(session);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void exportAll(String exportDir, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index: 0, Size: 0
         *     at java.base/java.util.LinkedList.checkElementIndex(LinkedList.java:566)
         *     at java.base/java.util.LinkedList.get(LinkedList.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.combineInlineable(Block.java:226)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:560)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredCatch.transformStructuredChildren(StructuredCatch.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.transformStructuredChildren(StructuredTry.java:129)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.transformStructuredChildren(StructuredTry.java:127)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.inlinePossibles(Op04StructuredStatement.java:709)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:855)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void deleteProject(String name, String version, boolean keepSummaryOnDelete, IProgressMonitor monitor) {
        int[] versionNr = this.buildVersionNrs(name, version);
        if (versionNr != null) {
            IProjectPO project;
            try {
                project = ProjectPM.loadProjectByNameAndVersion((String)name, (int)versionNr[0], (int)versionNr[1]);
            }
            catch (JBException jBException) {
                this.reportMissingProject(name, version);
                return;
            }
            if (project == null) {
                this.reportMissingProject(name, version);
            } else {
                try {
                    String pName = project.getName();
                    int pMajVer = project.getMajorProjectVersion();
                    int pMinVer = project.getMinorProjectVersion();
                    monitor.subTask(NLS.bind((String)Messages.DBToolDeletingProject, (Object[])new Object[]{pName, pMajVer, pMinVer}));
                    ProjectPM.deleteProject((IProjectPO)project, (boolean)false);
                    monitor.subTask(NLS.bind((String)Messages.DBToolDeleteFinished, (Object)pName));
                    monitor.subTask(Messages.DBToolDeletingTestResultDetails);
                    if (keepSummaryOnDelete) {
                        TestResultSummaryPM.deleteTestrunsByProject((String)project.getGuid(), (int)pMajVer, (int)pMinVer, (boolean)true);
                    } else {
                        TestResultSummaryPM.deleteTestrunsByProject((String)project.getGuid(), (int)pMajVer, (int)pMinVer, (boolean)false);
                    }
                    monitor.subTask(Messages.DBToolDeletingTestResultDetailsFinished);
                }
                catch (JBException e) {
                    this.reportDeleteFailed(name, version, (Exception)((Object)e));
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private void deleteAllProjects(boolean keepSummaryOnDelete, IProgressMonitor monitor) {
        try {
            List projects = ProjectPM.findAllProjects();
            monitor.subTask(NLS.bind((String)Messages.DBToolDeletingAllProjects, (Object)projects.size()));
            for (IProjectPO proj : projects) {
                String pName = proj.getName();
                monitor.subTask(NLS.bind((String)Messages.DBToolDeletingProject, (Object[])new Object[]{pName, proj.getMajorProjectVersion(), proj.getMinorProjectVersion()}));
                ProjectPM.deleteProject((IProjectPO)proj, (boolean)false);
                monitor.subTask(NLS.bind((String)Messages.DBToolDeleteFinished, (Object)pName));
            }
            if (!keepSummaryOnDelete) {
                monitor.subTask(Messages.DBToolDeletingTestResultSummaries);
                TestResultSummaryPM.deleteAllTestresultSummaries();
                monitor.subTask(Messages.DBToolDeletingTestResultSummariesFinished);
            }
            monitor.subTask(Messages.DBToolDeletingTestResultDetails);
            TestResultPM.deleteAllTestresultDetails();
            monitor.subTask(Messages.DBToolDeletingTestResultDetailsFinished);
        }
        catch (JBException e) {
            DBToolClient.printlnConsoleError((String)e.getMessage());
        }
        catch (InterruptedException interruptedException) {}
    }

    private int[] buildVersionNrs(String name, String version) {
        int sepPos = version.indexOf(46);
        if (sepPos == -1 || sepPos == 0) {
            this.reportBadVersion(name, version);
            return null;
        }
        String majorStr = version.substring(0, sepPos);
        String minorStr = version.substring(sepPos + 1);
        int[] versionNr = new int[2];
        try {
            versionNr[0] = Integer.parseInt(majorStr);
            versionNr[1] = Integer.parseInt(minorStr);
        }
        catch (NumberFormatException numberFormatException) {
            this.reportBadVersion(name, version);
            return null;
        }
        return versionNr;
    }

    private void reportDeleteFailed(String name, String version, Exception e) {
        StringBuilder msg = new StringBuilder(Messages.DBToolDeleteFailed);
        msg.append(" ");
        msg.append(name);
        msg.append(" [");
        msg.append(version);
        msg.append("]");
        msg.append("\n");
        msg.append(e.getLocalizedMessage());
        DBToolClient.printlnConsoleError((String)msg.toString());
    }

    private void reportBadVersion(String name, String version) {
        StringBuilder msg = new StringBuilder(Messages.DBToolInvalidVersion);
        msg.append(" ");
        msg.append(name);
        msg.append(" [");
        msg.append(version);
        msg.append("]");
        DBToolClient.printlnConsoleError((String)msg.toString());
    }

    private void reportMissingProject(String name, String version) {
        StringBuilder msg = new StringBuilder(Messages.DBToolMissingProject);
        msg.append(" ");
        msg.append(name);
        msg.append(" [");
        msg.append(version);
        msg.append("]");
        DBToolClient.printlnConsoleError((String)msg.toString());
    }

    private void reportBadDirectory(String dirName) {
        StringBuilder msg = new StringBuilder(Messages.DBToolInvalidExportDirectory);
        msg.append(" ");
        msg.append(dirName);
        DBToolClient.printlnConsoleError((String)msg.toString());
    }

    private void reportNonEmptyDirectory(String dirName) {
        StringBuilder msg = new StringBuilder(Messages.DBToolNonEmptyExportDirectory);
        msg.append(" ");
        msg.append(dirName);
        DBToolClient.printlnConsoleError((String)msg.toString());
    }

    private void reportExportAllFailed(String exportDir, JBException e) {
        StringBuilder msg = new StringBuilder(Messages.DBToolExportAllFailed);
        msg.append(" ");
        msg.append(exportDir);
        msg.append("\n");
        msg.append(e.getLocalizedMessage());
        DBToolClient.printlnConsoleError((String)msg.toString());
    }

    private void setupDB() {
        Persistor.setDbConnectionName((DatabaseConnectionInfo)this.getJob().getDbscheme());
        Persistor.setUser((String)this.getJob().getDbuser());
        Persistor.setPw((String)this.getJob().getDbpw());
        Persistor.setUrl((String)this.getJob().getDb());
        try {
            if (!Persistor.init()) {
                throw new IllegalArgumentException(Messages.ExecutionControllerInvalidDBDataError, null);
            }
        }
        catch (JBFatalException e) {
            throw new IllegalArgumentException(Messages.ExecutionControllerInvalidDBDataError, e);
        }
    }

    public String getCmdlineClientExecName() {
        return Messages.DBToolName;
    }
}

