/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.analyze.impl.standard.analyze;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jubula.client.analyze.definition.IAnalyze;
import org.eclipse.jubula.client.analyze.impl.standard.i18n.Messages;
import org.eclipse.jubula.client.analyze.internal.AnalyzeParameter;
import org.eclipse.jubula.client.analyze.internal.AnalyzeResult;
import org.eclipse.jubula.client.analyze.internal.helper.ProjectContextHelper;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IRefTestSuitePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.utils.AbstractNonPostOperatingTreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.client.core.utils.TreeTraverser;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.xml.businessmodell.CompSystem;
import org.eclipse.jubula.tools.xml.businessmodell.Component;
import org.eclipse.jubula.tools.xml.businessmodell.ToolkitPluginDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ratio
implements IAnalyze {
    public AnalyzeResult execute(Object obj2analyze, IProgressMonitor monitor, String resultType, List<AnalyzeParameter> param, String analyzeName) {
        int workAmount = 1;
        if (obj2analyze instanceof IProjectPO) {
            workAmount = (int)NodePM.getNumNodes((long)((IProjectPO)obj2analyze).getId(), (EntityManager)GeneralStorage.getInstance().getMasterSession());
        } else if (obj2analyze instanceof INodePO) {
            workAmount = (int)NodePM.getNumNodes((long)((INodePO)obj2analyze).getParentProjectId(), (EntityManager)GeneralStorage.getInstance().getMasterSession());
        }
        monitor.beginTask("", workAmount);
        monitor.subTask(analyzeName);
        CountToolkitLvl c = new CountToolkitLvl(monitor);
        c.setRefTestSuites(new ArrayList<IRefTestSuitePO>());
        this.traverse(c, obj2analyze, ProjectContextHelper.getObjContType());
        monitor.worked(1);
        if (monitor.isCanceled()) {
            monitor.done();
            throw new OperationCanceledException();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        int complete = 0;
        for (Map.Entry<String, Integer> e : c.getAmount().entrySet()) {
            complete += e.getValue().intValue();
        }
        double d = Double.parseDouble(Integer.toString(complete));
        for (Map.Entry<String, Integer> e : c.getAmount().entrySet()) {
            double curr = Double.parseDouble(Integer.toString(e.getValue()));
            double resNF = curr / d;
            DecimalFormat df = new DecimalFormat("0.00");
            String resu = String.valueOf(df.format(resNF * 100.0)) + "%";
            result.put(e.getKey(), resu);
        }
        return new AnalyzeResult(resultType, result);
    }

    private void traverse(CountToolkitLvl count, Object obj, String objContType) {
        TreeTraverser tt;
        INodePO root;
        if (obj instanceof INodePO && objContType.equals("IExecObjContPO")) {
            root = (INodePO)obj;
            tt = new TreeTraverser(root, (ITreeNodeOperation)count, true, true){

                protected void traverseReusedProjectSpecPart(ITreeTraverserContext<INodePO> context, IProjectPO project) {
                }
            };
            tt.traverse(true);
        } else if (obj instanceof INodePO && objContType.equals("ISpecObjContPO")) {
            root = (INodePO)obj;
            tt = new TreeTraverser(root, (ITreeNodeOperation)count, true, false){

                protected void traverseReusedProjectSpecPart(ITreeTraverserContext<INodePO> context, IProjectPO project) {
                }
            };
            tt.traverse(true);
        }
        if (obj instanceof INodePO && objContType.equals("project")) {
            root = (INodePO)obj;
            tt = new TreeTraverser(root, (ITreeNodeOperation)count, true, true){

                protected void traverseReusedProjectSpecPart(ITreeTraverserContext<INodePO> context, IProjectPO project) {
                }
            };
            tt.traverse(true);
        }
        if (obj instanceof INodePO && objContType.equals("")) {
            root = (INodePO)obj;
            tt = new TreeTraverser(root, (ITreeNodeOperation)count, true, true){

                protected void traverseReusedProjectSpecPart(ITreeTraverserContext<INodePO> context, IProjectPO project) {
                }
            };
            tt.traverse(true);
        }
        if (count.getRefTestSuites().size() != 0) {
            int i = 0;
            while (i < count.getRefTestSuites().size()) {
                IRefTestSuitePO ref = count.getRefTestSuites().get(i);
                ITestSuitePO tsRoot = NodePM.getTestSuite((String)ref.getTestSuiteGuid());
                TreeTraverser tt2 = new TreeTraverser((INodePO)tsRoot);
                tt2.addOperation((ITreeNodeOperation)count);
                tt2.traverse(true);
                ++i;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CountToolkitLvl
    extends AbstractNonPostOperatingTreeNodeOperation<INodePO> {
        private Map<String, Integer> m_amount = new HashMap<String, Integer>();
        private IProgressMonitor m_pm;
        private String m_ratioElements;
        private String m_ratioValue;
        private List<IRefTestSuitePO> m_refTestSuites;
        private long m_projectid;
        private CompSystem m_compSystem;

        public CountToolkitLvl(IProgressMonitor monitor) {
            this.setProgressMonitor(monitor);
            this.setLoadedProjectID(GeneralStorage.getInstance().getProject().getId());
            this.setCompSystem(ComponentBuilder.getInstance().getCompSystem());
            this.setRatioElements("");
            this.setRatioValue("");
        }

        public String getRatioElements() {
            return this.m_ratioElements;
        }

        public void setRatioElements(String ratioElements) {
            this.m_ratioElements = ratioElements;
        }

        public String getRatioValue() {
            return this.m_ratioValue;
        }

        public void setRatioValue(String ratioValue) {
            this.m_ratioValue = ratioValue;
        }

        public CompSystem getCompSystem() {
            return this.m_compSystem;
        }

        public void setCompSystem(CompSystem compSystem) {
            this.m_compSystem = compSystem;
        }

        public long getLoadedProjectID() {
            return this.m_projectid;
        }

        public void setLoadedProjectID(long id) {
            this.m_projectid = id;
        }

        public List<IRefTestSuitePO> getRefTestSuites() {
            return this.m_refTestSuites;
        }

        public void setRefTestSuites(List<IRefTestSuitePO> reftestSuite) {
            this.m_refTestSuites = reftestSuite;
        }

        public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            if (node instanceof IRefTestSuitePO) {
                this.getRefTestSuites().add((IRefTestSuitePO)node);
            }
            if (node instanceof ICapPO) {
                ICapPO cap = (ICapPO)node;
                Component comp = this.getCompSystem().findComponent(cap.getComponentType());
                String type = "";
                if (comp.getToolkitDesriptor().getName().equals("abstract") || comp.getToolkitDesriptor().getName().equals("concrete") || comp.getToolkitDesriptor().getName().equals("")) {
                    type = Messages.General;
                } else {
                    ToolkitPluginDescriptor tkpd = this.getParentToolkitPluginDescriptor(comp.getToolkitDesriptor());
                    type = tkpd.getName();
                }
                Integer ccount = this.getAmount().get(type);
                if (ccount == null) {
                    ccount = new Integer(0);
                }
                Integer nCount = ccount + 1;
                this.getAmount().put(type, nCount);
                this.getProgressMonitor().worked(1);
                if (this.getProgressMonitor().isCanceled()) {
                    this.getProgressMonitor().done();
                    throw new OperationCanceledException();
                }
            }
            return true;
        }

        private ToolkitPluginDescriptor getParentToolkitPluginDescriptor(ToolkitPluginDescriptor toolkitdesc) {
            if (toolkitdesc.getDepends().equals("null")) {
                return toolkitdesc;
            }
            ToolkitPluginDescriptor desc = ComponentBuilder.getInstance().getCompSystem().getToolkitPluginDescriptor(toolkitdesc.getDepends());
            return this.getParentToolkitPluginDescriptor(desc);
        }

        public Map<String, Integer> getAmount() {
            return this.m_amount;
        }

        public IProgressMonitor getProgressMonitor() {
            return this.m_pm;
        }

        public void setProgressMonitor(IProgressMonitor monitor) {
            this.m_pm = monitor;
        }
    }
}

