/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess.db;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.ListUtils;
import org.eclipse.jubula.client.core.businessprocess.db.NodeBP;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IRefTestSuitePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.PMAlreadyLockedException;
import org.eclipse.jubula.client.core.persistence.PMDirtyVersionException;
import org.eclipse.jubula.client.core.persistence.PMObjectDeletedException;
import org.eclipse.jubula.client.core.utils.AbstractNonPostOperatingTreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.client.core.utils.TreeTraverser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSuiteBP
extends NodeBP {
    private TestSuiteBP() {
    }

    public static IRefTestSuitePO addReferencedTestSuite(EditSupport editSupport, INodePO tj, ITestSuitePO referencedTS, Integer position) throws PMAlreadyLockedException, PMDirtyVersionException, PMObjectDeletedException {
        TestSuiteBP.handleFirstReference(editSupport, referencedTS, false);
        IRefTestSuitePO newRefTs = NodeMaker.createRefTestSuitePO(referencedTS);
        if (position != null) {
            tj.addNode(position, newRefTs);
        } else {
            tj.addNode(newRefTs);
        }
        return newRefTs;
    }

    private static void handleFirstReference(EditSupport editSupport, ITestSuitePO referencedTS, boolean isReferencedByThisAction) throws PMAlreadyLockedException, PMDirtyVersionException, PMObjectDeletedException {
        int minSize = 0;
        if (isReferencedByThisAction) {
            minSize = 1;
        }
        if (NodePM.getInternalRefTestSuites(referencedTS.getGuid(), referencedTS.getParentProjectId()).size() <= minSize) {
            TestSuiteBP.lockPO(editSupport, referencedTS);
        }
    }

    public static List<ITestSuitePO> getListOfTestSuites() {
        return TestSuiteBP.getListOfTestSuites(GeneralStorage.getInstance().getProject());
    }

    public static List<ITestSuitePO> getListOfTestSuites(IProjectPO project) {
        if (project != null) {
            ExecNodeFinder<ITestSuitePO> op = new ExecNodeFinder<ITestSuitePO>(ITestSuitePO.class);
            new TreeTraverser((INodePO)project, op, false, true).traverse(false);
            return op.getListOfExecNodes();
        }
        return ListUtils.EMPTY_LIST;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExecNodeFinder<T>
    extends AbstractNonPostOperatingTreeNodeOperation<INodePO> {
        private List<T> m_listOfExecNodes = new ArrayList<T>();
        private final Class<T> m_nodeType;

        public ExecNodeFinder(Class<T> nodeType) {
            this.m_nodeType = nodeType;
        }

        @Override
        public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            if (this.m_nodeType.isAssignableFrom(node.getClass())) {
                this.m_listOfExecNodes.add(node);
                return false;
            }
            return true;
        }

        public List<T> getListOfExecNodes() {
            return this.m_listOfExecNodes;
        }
    }
}

