/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.persistence;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBP;
import org.eclipse.jubula.client.core.businessprocess.ProjectNameBP;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.IEntityManagerProvider;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMReadException;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.tools.exception.JBFatalAbortException;
import org.eclipse.jubula.tools.exception.JBRuntimeException;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralStorage
implements IEntityManagerProvider {
    private static final Logger LOG = LoggerFactory.getLogger(GeneralStorage.class);
    private static GeneralStorage instance = null;
    private IProjectPO m_project = null;
    private EntityManager m_masterSession = null;
    private Set<IReloadedSessionListener> m_reloadSessionListeners = new HashSet<IReloadedSessionListener>();
    private Set<IDataModifiedListener> m_dataModifiedListeners = new HashSet<IDataModifiedListener>();

    private GeneralStorage() {
    }

    public static synchronized GeneralStorage getInstance() {
        if (instance == null) {
            instance = new GeneralStorage();
        }
        return instance;
    }

    public IProjectPO getProject() {
        return this.m_project;
    }

    public void setProject(IProjectPO project) {
        this.m_project = project;
    }

    public EntityManager getMasterSession() {
        if (this.m_masterSession == null) {
            this.m_masterSession = Persistor.instance().openSession();
        }
        return this.m_masterSession;
    }

    public void dispose() {
        try {
            this.clearMasterSession();
        }
        catch (PMException e) {
            LOG.error(Messages.ClearingOfMasterSessionFailed, (Throwable)((Object)e));
        }
        Persistor.instance().dropSession(this.m_masterSession);
        this.m_masterSession = null;
        this.m_project = null;
    }

    public void reset() {
        EntityManager masterSession = GeneralStorage.getInstance().getMasterSession();
        try {
            this.clearMasterSession();
            Persistor.instance().dropSession(masterSession);
            this.m_masterSession = Persistor.instance().openSession();
        }
        catch (PMException e) {
            LOG.warn(Messages.ResetFailed, (Throwable)((Object)e));
        }
        this.m_project = null;
    }

    private void clearMasterSession() throws PMException {
        EntityManager masterSession = GeneralStorage.getInstance().getMasterSession();
        ParamNameBP.getInstance().clearParamNames();
        try {
            masterSession.clear();
        }
        catch (PersistenceException persistenceException) {
            throw new PMException(Messages.ClearingOfMasterSessionFailed, MessageIDs.E_DATABASE_GENERAL);
        }
    }

    public void recoverSession() {
        try {
            if (this.getMasterSession() != null && this.getMasterSession().isOpen()) {
                Persistor.instance().dropSession(this.getMasterSession());
            }
            this.m_masterSession = Persistor.instance().openSession();
            if (this.m_project != null) {
                this.getMasterSession().lock((Object)this.m_project, LockModeType.NONE);
            }
        }
        catch (PersistenceException e) {
            GeneralStorage.handleFatalError(e);
        }
        catch (JBRuntimeException e) {
            GeneralStorage.handleFatalError(e);
        }
    }

    public static void handleFatalError(Throwable t) {
        String msg = String.valueOf(Messages.NonRecoverableError) + ".";
        LOG.error(msg, t);
        throw new JBFatalAbortException(msg, t, MessageIDs.E_NON_RECOVERABLE);
    }

    public void reloadMasterSession(IProgressMonitor monitor) throws ProjectDeletedException {
        ProjectNameBP.getInstance().clearCache();
        try {
            try {
                NodePM.getInstance().setUseCache(true);
                if (this.m_project != null) {
                    ProjectPM.loadProjectInROSession(this.m_project);
                    if (this.m_project == null) {
                        this.reset();
                        throw new ProjectDeletedException(Messages.ProjectWasDeleted, MessageIDs.E_CURRENT_PROJ_DEL);
                    }
                    this.fireSessionReloaded(monitor);
                }
            }
            catch (PersistenceException e) {
                GeneralStorage.handleFatalError(e);
                NodePM.getInstance().setUseCache(false);
            }
            catch (PMReadException e) {
                GeneralStorage.handleFatalError((Throwable)((Object)e));
                NodePM.getInstance().setUseCache(false);
            }
        }
        finally {
            NodePM.getInstance().setUseCache(false);
        }
    }

    public void addReloadedSessListener(IReloadedSessionListener listener) {
        this.m_reloadSessionListeners.add(listener);
    }

    public void removeReloadedSessListener(IReloadedSessionListener listener) {
        this.m_reloadSessionListeners.remove(listener);
    }

    public void fireSessionReloaded(IProgressMonitor monitor) {
        HashSet<IReloadedSessionListener> listeners = new HashSet<IReloadedSessionListener>(this.m_reloadSessionListeners);
        for (IReloadedSessionListener listener : listeners) {
            try {
                listener.reloadData(monitor);
            }
            catch (Throwable throwable) {
                LOG.error(String.valueOf(Messages.InvocationOfListenerForReloadingSessionFailed) + ".");
            }
        }
    }

    public void addDataModifiedListener(IDataModifiedListener l) {
        this.m_dataModifiedListeners.add(l);
    }

    public void removeDataModifiedListener(IDataModifiedListener l) {
        this.m_dataModifiedListeners.remove(l);
    }

    public void fireDataModified(IPersistentObject po) {
        HashSet<IDataModifiedListener> listeners = new HashSet<IDataModifiedListener>(this.m_dataModifiedListeners);
        for (IDataModifiedListener listener : listeners) {
            try {
                listener.dataModified(po);
            }
            catch (Throwable throwable) {
                LOG.error(String.valueOf(Messages.InvocationOfListenerForReloadingSessionFailed) + ".");
            }
        }
    }

    public void validateProjectExists(IProjectPO project) throws ProjectDeletedException {
        if (!ProjectPM.doesProjectExist(project.getId())) {
            throw new ProjectDeletedException(Messages.ProjectNotInDB, MessageIDs.E_CURRENT_PROJ_DEL);
        }
    }

    public EntityManager getEntityManager() {
        return this.getMasterSession();
    }

    public static interface IDataModifiedListener {
        public void dataModified(IPersistentObject var1);
    }

    public static interface IReloadedSessionListener {
        public void reloadData(IProgressMonitor var1);
    }
}

