/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.businessprocess;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jubula.client.archive.businessprocess.FileStorageBP;
import org.eclipse.jubula.client.archive.errorhandling.IProjectNameConflictResolver;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.progress.AbstractRunnableWithProgress;
import org.eclipse.jubula.client.core.progress.IProgressConsole;
import org.eclipse.jubula.client.core.utils.DatabaseStateDispatcher;
import org.eclipse.jubula.client.core.utils.DatabaseStateEvent;
import org.eclipse.jubula.client.core.utils.IDatabaseStateListener;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.dialogs.ComboBoxDialog;
import org.eclipse.jubula.client.ui.rcp.handlers.project.OpenProjectHandler;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportFileBP
implements IProjectNameConflictResolver,
IDatabaseStateListener {
    private static Logger log = LoggerFactory.getLogger(ImportFileBP.class);
    private static ImportFileBP instance = null;

    public ImportFileBP() {
        FileStorageBP.setProjectNameConflictResolver((IProjectNameConflictResolver)this);
        DatabaseStateDispatcher.addDatabaseStateListener((IDatabaseStateListener)this);
    }

    public static ImportFileBP getInstance() {
        if (instance == null) {
            instance = new ImportFileBP();
        }
        return instance;
    }

    public void importProject(final int elements, final List<URL> fileURLs, final boolean openProject) {
        block12: {
            try {
                if (fileURLs == null) {
                    return;
                }
                try {
                    AbstractRunnableWithProgress<IProjectPO> importProjectRunnable = new AbstractRunnableWithProgress<IProjectPO>(){

                        public void run(IProgressMonitor monitor) throws InterruptedException {
                            monitor.setTaskName(Messages.ImportFileBPWaitWhileImporting);
                            try {
                                this.setResult(FileStorageBP.importProject((int)elements, (List)fileURLs, (IProgressMonitor)monitor, (IProgressConsole)Plugin.getDefault(), (boolean)openProject));
                            }
                            catch (PMException pme) {
                                PMExceptionHandler.handlePMExceptionForMasterSession(pme);
                            }
                            catch (ProjectDeletedException projectDeletedException) {
                                PMExceptionHandler.handleGDProjectDeletedException();
                            }
                        }
                    };
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)importProjectRunnable);
                    IProjectPO projectToOpen = (IProjectPO)importProjectRunnable.getResult();
                    if (projectToOpen == null) break block12;
                    OpenProjectHandler.OpenProjectOperation openOp = new OpenProjectHandler.OpenProjectOperation(projectToOpen);
                    try {
                        PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)openOp);
                    }
                    catch (InvocationTargetException ite) {
                        log.error(Messages.ErrorOccurredDuringImport, ite.getCause());
                        openOp.handleOperationException();
                    }
                    catch (InterruptedException interruptedException) {
                        openOp.handleOperationException();
                    }
                }
                catch (InvocationTargetException ite) {
                    log.error(Messages.ErrorOccurredDuringImport, ite.getCause());
                }
                catch (InterruptedException interruptedException) {
                    this.showCancelImport(Plugin.getDefault());
                }
            }
            finally {
                Plugin.stopLongRunning();
            }
        }
    }

    public void importProjects(IProjectImportInfoProvider importInfo, IProgressMonitor monitor) throws InterruptedException {
        List<URL> fileURLs = importInfo.getFileURLs();
        boolean openProject = importInfo.getIsOpenProject();
        try {
            FileStorageBP.importProject((int)0, fileURLs, (IProgressMonitor)monitor, (IProgressConsole)Plugin.getDefault(), (boolean)openProject);
        }
        catch (PMException pme) {
            PMExceptionHandler.handlePMExceptionForMasterSession(pme);
        }
        catch (ProjectDeletedException projectDeletedException) {
            PMExceptionHandler.handleGDProjectDeletedException();
        }
    }

    public String resolveNameConflict(List<String> availableNames) {
        ComboBoxDialog dialog = new ComboBoxDialog(Plugin.getShell(), new ArrayList<String>(availableNames), Messages.ImportFileComboActionProjMessage, Messages.ImportFileActionProjTitle, Plugin.getImage("importProject.gif"), Messages.ImportFileActionProjShell, Messages.ImportFileActionProjLabel);
        dialog.setHelpAvailable(true);
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        Plugin.getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jubula.client.ua.help.dialogProjectImportRenameContextId");
        dialog.open();
        return dialog.getReturnCode() == 0 ? dialog.getSelection() : null;
    }

    protected void writeLineToConsole(String string, boolean b) {
        Plugin.getDefault().writeLineToConsole(string, b);
    }

    protected void writeErrorLineToConsole(String string, boolean b) {
        Plugin.getDefault().writeErrorLineToConsole(string, b);
    }

    private void showCancelImport(IProgressConsole console) {
        console.writeErrorLine(NLS.bind((String)Messages.ImportFileActionErrorImportFailed, (Object)Messages.ImportOperationCancelledByUser));
    }

    public void reactOnDatabaseEvent(DatabaseStateEvent e) {
        switch (e.getState()) {
            case DB_SCHEME_CREATED: {
                ImportUnboundModulesJob importUnboundModules = new ImportUnboundModulesJob(org.eclipse.jubula.client.archive.i18n.Messages.ImportUnboundModulesJob);
                importUnboundModules.setUser(true);
                importUnboundModules.schedule();
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IProjectImportInfoProvider {
        public List<URL> getFileURLs();

        public boolean getIsOpenProject();
    }

    private final class ImportUnboundModulesJob
    extends Job {
        public ImportUnboundModulesJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            Plugin.getDisplay().syncExec(new Runnable(){

                public void run() {
                    Bundle b = Platform.getBundle((String)"org.eclipse.jubula.client.ui.rcp");
                    Enumeration e = b.findEntries("resources/library/", "*.xml", false);
                    ArrayList<URL> unboundModuleURLs = new ArrayList<URL>();
                    while (e.hasMoreElements()) {
                        unboundModuleURLs.add((URL)e.nextElement());
                    }
                    ImportFileBP.this.importProject(0, unboundModuleURLs, false);
                }
            });
            return Status.OK_STATUS;
        }
    }
}

