/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.businessprocess;

import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.dialogs.ProjectDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectUIBP {
    private static ProjectUIBP instance;
    private static final Logger LOG;
    private final IPreferenceStore m_prefStore = Plugin.getDefault().getPreferenceStore();

    static {
        LOG = LoggerFactory.getLogger(ProjectUIBP.class);
    }

    private ProjectUIBP() {
    }

    public static ProjectUIBP getInstance() {
        if (instance == null) {
            instance = new ProjectUIBP();
        }
        return instance;
    }

    public boolean shouldPerformAutoProjectLoad() {
        return this.m_prefStore.getBoolean("PERFORM_AUTO_PROJECT_LOAD_KEY");
    }

    public static ProjectDialog.ProjectData getMostRecentProjectData() {
        ISecurePreferences node = ProjectUIBP.getSecurePreferenceNode();
        ProjectDialog.ProjectData projectData = new ProjectDialog.ProjectData("", "");
        if (node != null) {
            try {
                projectData.setGUID(node.get("project.guid", ""));
                projectData.setVersionString(node.get("project.version", ""));
            }
            catch (StorageException e) {
                LOG.error("An error occured: ", (Throwable)e);
            }
        }
        return projectData;
    }

    public void saveMostRecentProjectData(ProjectDialog.ProjectData projectData) {
        this.m_prefStore.setValue("PERFORM_AUTO_PROJECT_LOAD_KEY", true);
        ISecurePreferences node = ProjectUIBP.getSecurePreferenceNode();
        if (node != null) {
            try {
                node.put("project.guid", projectData.getGUID(), true);
                node.put("project.version", projectData.getVersionString(), true);
            }
            catch (StorageException e1) {
                LOG.error("An error occured: ", (Throwable)e1);
            }
        } else {
            LOG.error("An error occured: ");
        }
    }

    public void removeMostRecentProjectData() {
        ISecurePreferences node = ProjectUIBP.getSecurePreferenceNode();
        this.m_prefStore.setValue("PERFORM_AUTO_PROJECT_LOAD_KEY", false);
        if (node != null) {
            node.removeNode();
        }
    }

    private static ISecurePreferences getSecurePreferenceNode() {
        ISecurePreferences root;
        ISecurePreferences node = root = SecurePreferencesFactory.getDefault();
        if (root != null) {
            node = root.node("org.eclipse.jubula.MostRecentProjectdata");
        }
        return node;
    }
}

