/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.jubula.client.ui.widgets.DirectCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectComboBoxDialog<ObjectType>
extends TitleAreaDialog {
    private static final int NUM_COLUMNS_1 = 1;
    private static final int NUM_COLUMNS_4 = 4;
    private static final int VERTICAL_SPACING = 2;
    private static final int MARGIN_WIDTH = 10;
    private static final int MARGIN_HEIGHT = 10;
    private static final int WIDTH_HINT = 300;
    private static final int HORIZONTAL_SPAN = 3;
    private String m_message;
    private DirectCombo<ObjectType> m_comboBox;
    private List<ObjectType> m_objectList;
    private ObjectType m_selection = null;
    private List<String> m_displayList;
    private String m_label;
    private String m_title;
    private Image m_image;
    private String m_shellTitle;

    public DirectComboBoxDialog(Shell parentShell, List<ObjectType> objectList, List<String> displayList, String message, String title, Image image, String shellTitle, String label) {
        super(parentShell);
        this.m_objectList = objectList;
        this.m_displayList = displayList;
        this.m_message = message;
        this.m_label = label;
        this.m_title = title;
        this.m_image = image;
        this.m_shellTitle = shellTitle;
    }

    protected Control createDialogArea(Composite parent) {
        this.setMessage(this.m_message);
        this.setTitle(this.m_title);
        this.setTitleImage(this.m_image);
        this.getShell().setText(this.m_shellTitle);
        GridLayout gridLayoutParent = new GridLayout();
        gridLayoutParent.numColumns = 1;
        gridLayoutParent.verticalSpacing = 2;
        gridLayoutParent.marginWidth = 10;
        gridLayoutParent.marginHeight = 10;
        parent.setLayout((Layout)gridLayoutParent);
        LayoutUtil.createSeparator((Composite)parent);
        Composite area = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        area.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.widthHint = 300;
        area.setLayoutData((Object)gridData);
        this.createComboBox(area);
        LayoutUtil.createSeparator((Composite)parent);
        return area;
    }

    private void createComboBox(Composite parent) {
        new Label(parent, 0).setLayoutData((Object)new GridData(4, 2, false, false, 4, 1));
        new Label(parent, 0).setText(this.m_label);
        this.m_comboBox = new DirectCombo(parent, 2060, this.m_objectList, this.m_displayList, false, null);
        if (this.m_comboBox.getItemCount() > 0) {
            this.m_comboBox.select(0);
        }
        GridData gridData = this.newGridData();
        LayoutUtil.addToolTipAndMaxWidth((GridData)gridData, this.m_comboBox);
        this.m_comboBox.setLayoutData((Object)gridData);
        this.m_comboBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DirectComboBoxDialog.this.enableOKButton();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void enableOKButton() {
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(true);
        }
        this.setMessage(this.m_message);
    }

    protected void okPressed() {
        this.m_selection = this.m_comboBox.getSelectedObject();
        this.setReturnCode(0);
        this.close();
    }

    private GridData newGridData() {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 3;
        return gridData;
    }

    public ObjectType getSelection() {
        return this.m_selection;
    }
}

