/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.dialogs;

import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.ui.rcp.dialogs.AbstractEditParametersDialog;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.ControlDecorator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public final class EditParametersDialog
extends AbstractEditParametersDialog {
    private ISpecTestCasePO m_specTc;
    private boolean m_isInterfaceLocked;
    private Button m_lockInterfaceCheckBox;

    public EditParametersDialog(Shell parentShell, ISpecTestCasePO testCase) {
        super(parentShell, (IParameterInterfacePO)testCase);
        this.m_specTc = testCase;
        this.m_isInterfaceLocked = this.m_specTc.isInterfaceLocked();
    }

    protected Control createDialogArea(Composite parent) {
        String dialogTitle = Messages.EditParametersDialogEditParameters;
        this.setTitle(dialogTitle);
        this.setMessage(Messages.EditParametersDialogEditParamsOfTestCase);
        this.getShell().setText(dialogTitle);
        return super.createDialogArea(parent);
    }

    protected boolean generalButtonEnablement() {
        return !this.isInterfaceLocked();
    }

    protected ICellModifier getParamTableCellModifier() {
        return new ParamTableCellModifier();
    }

    protected void createAdditionalWidgetsAtTop(Composite parent) {
        this.createLockInterfaceCheckBox(parent);
    }

    private void createLockInterfaceCheckBox(Composite parent) {
        this.m_lockInterfaceCheckBox = new Button(parent, 32);
        this.m_lockInterfaceCheckBox.setText(Messages.EditParametersDialogLockInterface);
        this.m_lockInterfaceCheckBox.setSelection(this.m_isInterfaceLocked);
        this.m_lockInterfaceCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.handleSelection(e);
            }

            public void widgetSelected(SelectionEvent e) {
                this.handleSelection(e);
            }

            private void handleSelection(SelectionEvent e) {
                Button checkBox = (Button)e.widget;
                EditParametersDialog.this.m_isInterfaceLocked = checkBox.getSelection();
            }
        });
        ControlDecorator.decorateInfo((Control)this.m_lockInterfaceCheckBox, "GDControlDecorator.EditParameterLock", false);
    }

    protected void createParameterTable(Composite parent) {
        super.createParameterTable(parent);
        Table table = this.getParamTableViewer().getTable();
        this.m_lockInterfaceCheckBox.addSelectionListener((SelectionListener)new ButtonSelectedListener((Control)table));
        table.setEnabled(!this.m_isInterfaceLocked);
    }

    protected void afterDeleteButtonCreation(Button deleteButton, AbstractEditParametersDialog.SelectionBasedButtonEnabler buttonEnabler) {
        this.m_lockInterfaceCheckBox.addSelectionListener((SelectionListener)buttonEnabler);
        deleteButton.setEnabled(!this.m_isInterfaceLocked);
    }

    protected void afterUpButtonCreation(Button upButton, AbstractEditParametersDialog.SelectionBasedButtonEnabler buttonEnabler) {
        this.m_lockInterfaceCheckBox.addSelectionListener((SelectionListener)buttonEnabler);
        upButton.setEnabled(!this.m_isInterfaceLocked);
    }

    protected void afterDownButtonCreation(Button downButton, AbstractEditParametersDialog.SelectionBasedButtonEnabler buttonEnabler) {
        this.m_lockInterfaceCheckBox.addSelectionListener((SelectionListener)buttonEnabler);
        downButton.setEnabled(!this.m_isInterfaceLocked);
    }

    protected void afterAddButtonCreation(Button addButton) {
        this.m_lockInterfaceCheckBox.addSelectionListener((SelectionListener)new ButtonSelectedListener((Control)addButton));
        addButton.setEnabled(!this.m_isInterfaceLocked);
    }

    public boolean isInterfaceLocked() {
        return this.m_isInterfaceLocked;
    }

    protected String getEditedObjectNameString() {
        return Messages.EditParametersDialogTestCaseName;
    }

    private static final class ButtonSelectedListener
    implements SelectionListener {
        private Control m_component;

        public ButtonSelectedListener(Control control) {
            this.m_component = control;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.handleSelection(e);
        }

        public void widgetSelected(SelectionEvent e) {
            this.handleSelection(e);
        }

        private void handleSelection(SelectionEvent e) {
            Button button = (Button)e.widget;
            this.m_component.setEnabled(!button.getSelection());
        }
    }

    private final class ParamTableCellModifier
    extends AbstractEditParametersDialog.AbstractTableCellModifier {
        private ParamTableCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return !EditParametersDialog.this.m_isInterfaceLocked;
        }
    }
}

