/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.delete;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.ui.handlers.AbstractSelectionBasedHandler;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDeleteTreeItemHandler
extends AbstractSelectionBasedHandler {
    protected boolean confirmDelete(IStructuredSelection sel) {
        ArrayList<String> itemNames = new ArrayList<String>();
        for (Object obj : sel.toList()) {
            if (obj instanceof INodePO) {
                itemNames.add(((INodePO)obj).getName());
                continue;
            }
            String name = this.getName(obj);
            if (StringUtils.isBlank((String)name)) continue;
            itemNames.add(name);
        }
        return this.confirmDelete(itemNames);
    }

    public boolean confirmDelete(Collection<String> itemNames) {
        String label = "";
        if (itemNames.size() == 1) {
            label = NLS.bind((String)Messages.DeleteTreeItemActionDeleteOneItem, (Object)itemNames.iterator().next());
        } else {
            if (itemNames.size() == 0) {
                return false;
            }
            label = NLS.bind((String)Messages.DeleteTreeItemActionDeleteMultipleItems, (Object)itemNames.size());
        }
        MessageDialog dialog = new MessageDialog(this.getActiveShell(), Messages.DeleteTreeItemActionShellTitle, null, label, 3, new String[]{Messages.DialogMessageButton_YES, Messages.DialogMessageButton_NO}, 0);
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        dialog.open();
        return dialog.getReturnCode() == 0;
    }

    protected void closeOpenEditor(IPersistentObject node) {
        IEditorPart editor = Utils.getEditorByPO(node);
        if (editor != null) {
            editor.getSite().getPage().closeEditor(editor, false);
        }
    }

    protected String getName(Object obj) {
        return String.valueOf(obj);
    }
}

