/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.delete;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.ListUtils;
import org.eclipse.jubula.client.core.businessprocess.db.TestSuiteBP;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.IExecPersistable;
import org.eclipse.jubula.client.core.persistence.MultipleNodePM;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.editors.ObjectMappingMultiPageEditor;
import org.eclipse.jubula.client.ui.rcp.editors.TestJobEditor;
import org.eclipse.jubula.client.ui.rcp.editors.TestSuiteEditor;
import org.eclipse.jubula.client.ui.rcp.handlers.delete.AbstractDeleteBrowserTreeItemHandler;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteTreeItemHandlerTSBrowser
extends AbstractDeleteBrowserTreeItemHandler {
    @Override
    protected List<MultipleNodePM.AbstractCmdHandle> getDeleteCommands(List<INodePO> nodesToDelete) {
        IEditorReference[] editors = Plugin.getActivePage().getEditorReferences();
        ArrayList<MultipleNodePM.AbstractCmdHandle> cmds = new ArrayList<MultipleNodePM.AbstractCmdHandle>(nodesToDelete.size());
        for (INodePO node : nodesToDelete) {
            MultipleNodePM.DeleteCatHandle cmd = null;
            if (node instanceof ITestSuitePO) {
                ITestSuitePO testSuite = (ITestSuitePO)node;
                List refTs = NodePM.getInternalRefTestSuites((String)testSuite.getGuid(), (long)testSuite.getParentProjectId());
                if (refTs.size() > 0) {
                    ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_REUSED_TS);
                    return ListUtils.EMPTY_LIST;
                }
                this.closeEditors(testSuite, editors);
                cmd = new MultipleNodePM.DeleteExecHandle((IExecPersistable)testSuite);
            } else if (node instanceof ITestJobPO) {
                ITestJobPO testjob = (ITestJobPO)node;
                this.closeEditors(testjob, editors);
                cmd = new MultipleNodePM.DeleteExecHandle((IExecPersistable)testjob);
            } else if (node instanceof ICategoryPO) {
                ICategoryPO category = (ICategoryPO)node;
                cmd = new MultipleNodePM.DeleteCatHandle(category);
            }
            cmds.add((MultipleNodePM.AbstractCmdHandle)cmd);
        }
        return cmds;
    }

    @Override
    protected void collectNodesToDelete(List<INodePO> nodesToDelete, INodePO node) {
        nodesToDelete.add(node);
        if (node instanceof ICategoryPO) {
            Iterator iter = node.getNodeListIterator();
            while (iter.hasNext()) {
                this.collectNodesToDelete(nodesToDelete, (INodePO)iter.next());
            }
        }
    }

    private void closeEditors(ITestJobPO testjob, IEditorReference[] editors) {
        IEditorReference[] iEditorReferenceArray = editors;
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            TestJobEditor tjEditor;
            IEditorReference editor = iEditorReferenceArray[n2];
            if (editor.getPart(true) instanceof TestJobEditor && (tjEditor = (TestJobEditor)editor.getPart(true)).getEditorInput().getName().endsWith(testjob.getName())) {
                tjEditor.getEditorSite().getPage().closeEditor((IEditorPart)tjEditor, true);
            }
            ++n2;
        }
    }

    private void closeEditors(ITestSuitePO execTS, IEditorReference[] editors) {
        IEditorReference[] iEditorReferenceArray = editors;
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            TestSuiteEditor tsEditor;
            IEditorReference editor = iEditorReferenceArray[n2];
            if (editor.getPart(true) instanceof TestSuiteEditor && (tsEditor = (TestSuiteEditor)editor.getPart(true)).getEditorInput().getName().endsWith(execTS.getName())) {
                tsEditor.getEditorSite().getPage().closeEditor((IEditorPart)tsEditor, true);
            }
            if (editor.getPart(true) instanceof ObjectMappingMultiPageEditor) {
                int autCounter = 0;
                ObjectMappingMultiPageEditor omEditor = (ObjectMappingMultiPageEditor)editor.getPart(true);
                IAUTMainPO omAut = omEditor.getAut();
                List tsList = TestSuiteBP.getListOfTestSuites();
                for (ITestSuitePO ts : tsList) {
                    if (ts.getAut() == null || !ts.getAut().equals(omAut)) continue;
                    ++autCounter;
                }
                if (execTS.getAut() != null && execTS.getAut().equals(omAut)) {
                    --autCounter;
                }
                if (autCounter == 0) {
                    omEditor.getEditorSite().getPage().closeEditor((IEditorPart)omEditor, true);
                }
            }
            ++n2;
        }
    }
}

