/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.preferences;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.ControlDecorator;
import org.eclipse.jubula.client.ui.rcp.widgets.CheckedDirnameText;
import org.eclipse.jubula.client.ui.rcp.widgets.CheckedText;
import org.eclipse.jubula.tools.exception.Assert;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PrefPageBasic
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int NUM_COLUMNS_1 = 1;
    private static final int HORIZONTAL_SPACING_10 = 10;
    private static final int VERTICAL_SPACING_10 = 10;
    private static final int MARGIN_HEIGHT_10 = 10;
    private static final int MARGIN_WIDTH_10 = 10;
    private Button m_minimize;
    private Button m_showOrigName;
    private Button m_treeScroll;
    private Button m_askStopAUT;
    private Button m_capInfoCheckbox;
    private Button m_showTransientChildrenCheckBox;
    private Button m_loadDefaultProjectCheckBox;
    private Button m_perspChange0Button;
    private Button m_perspChange1Button;
    private Button m_perspChange2Button;
    private Button m_dataDirIsWorkspaceButton;
    private CheckedText m_dataDirPathTextfield;
    private Button m_dataDirPathButton;
    private int m_perspChangeValue;
    private boolean m_rememberValue;
    private boolean m_dataDirIsWorkspaceValue;
    private IPreferenceStore m_store = Plugin.getDefault().getPreferenceStore();
    private final WidgetSelectionListener m_selectionListener = new WidgetSelectionListener();
    private final SelectionListener m_dataDirIsWsButtonListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
            PrefPageBasic.this.dataDirIsWsChanged(PrefPageBasic.this.m_dataDirIsWorkspaceButton.getSelection());
        }

        public void widgetSelected(SelectionEvent e) {
            PrefPageBasic.this.dataDirIsWsChanged(PrefPageBasic.this.m_dataDirIsWorkspaceButton.getSelection());
        }
    };
    private final SelectionListener m_dataDirPathButtonListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
            PrefPageBasic.this.browseForDir();
        }

        public void widgetSelected(SelectionEvent e) {
            PrefPageBasic.this.browseForDir();
        }
    };

    public PrefPageBasic() {
        this.setPreferenceStore(this.m_store);
    }

    protected Control createContents(Composite parent) {
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        Composite composite = new Composite((Composite)scrollComposite, 0);
        this.setGridLayout(composite, 1);
        this.createTreeScrollButton(composite);
        this.createMinimizeClientButton(composite);
        this.createAskStopAUTButton(composite);
        this.createShowOrigTestCaseName(composite);
        this.createShowCAPInfosCheckbox(composite);
        this.createShowTransientChildrensCheckbox(composite);
        this.createDefaultProjectCheckbox(composite);
        this.createSeparator(composite, 3);
        this.createRememberGroup(composite);
        this.createSeparator(composite, 3);
        this.createDataDirGroup(composite);
        Label hint = new Label(composite, 0);
        hint.setText(Messages.JubulaPrefPageBasicHint);
        this.addListener();
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.prefPageBasicContextId");
        scrollComposite.setContent((Control)composite);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        scrollComposite.setMinSize(composite.computeSize(-1, -1));
        this.validatePage();
        return scrollComposite;
    }

    private void createShowOrigTestCaseName(Composite composite) {
        this.m_showOrigName = new Button(composite, 32);
        this.m_showOrigName.setText(Messages.JubulaPrefPageBasicShowOrig);
        this.m_showOrigName.setSelection(this.getPreferenceStore().getBoolean("SHOWORIGINALNAME_PREF_KEY"));
    }

    private void createShowCAPInfosCheckbox(Composite composite) {
        this.m_capInfoCheckbox = new Button(composite, 32);
        this.m_capInfoCheckbox.setText(Messages.EditorPreferencePageShowCapInfo);
        this.m_capInfoCheckbox.setSelection(Plugin.getDefault().getPreferenceStore().getBoolean("SHOWCAPINFO_PREF_KEY"));
        ControlDecorator.decorateInfo((Control)this.m_capInfoCheckbox, "GDControlDecorator.ShowCapInfo", false);
    }

    private void createShowTransientChildrensCheckbox(Composite composite) {
        this.m_showTransientChildrenCheckBox = new Button(composite, 32);
        this.m_showTransientChildrenCheckBox.setText(Messages.EditorPreferencePageShowTransientChildrenCheckBox);
        this.m_showTransientChildrenCheckBox.setSelection(Plugin.getDefault().getPreferenceStore().getBoolean("SHOW_TRANSIENT_CHILDREN_KEY"));
        ControlDecorator.decorateInfo((Control)this.m_showTransientChildrenCheckBox, "GDControlDecorator.showTransientChildrenCheckBox", false);
    }

    private void createDefaultProjectCheckbox(Composite composite) {
        this.m_loadDefaultProjectCheckBox = new Button(composite, 32);
        this.m_loadDefaultProjectCheckBox.setText(Messages.LoadDefaultProject);
        this.m_loadDefaultProjectCheckBox.setSelection(Plugin.getDefault().getPreferenceStore().getBoolean("PERFORM_AUTO_PROJECT_LOAD_KEY"));
    }

    private void setGridLayout(Composite composite, int numColumns) {
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = numColumns;
        compositeLayout.horizontalSpacing = 10;
        compositeLayout.verticalSpacing = 10;
        compositeLayout.marginHeight = 10;
        compositeLayout.marginWidth = 10;
        composite.setLayout((Layout)compositeLayout);
        GridData compositeData = new GridData(1808);
        compositeData.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)compositeData);
    }

    private void createSeparator(Composite composite, int horSpan) {
        Label sep = new Label(composite, 258);
        GridData sepData = new GridData();
        sepData.horizontalAlignment = 4;
        sepData.horizontalSpan = horSpan;
        sep.setLayoutData((Object)sepData);
    }

    private void createRememberGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(Messages.PrefPageBasicOpenPerspective);
        RowLayout layout = new RowLayout();
        group.setLayout((Layout)layout);
        GridData layoutData = new GridData(768);
        layoutData.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)layoutData);
        this.m_perspChange0Button = new Button((Composite)group, 16);
        this.m_perspChange0Button.setText(Messages.PrefPageBasicAlways);
        this.m_perspChange1Button = new Button((Composite)group, 16);
        this.m_perspChange1Button.setText(Messages.PrefPageBasicNever);
        this.m_perspChange2Button = new Button((Composite)group, 16);
        this.m_perspChange2Button.setText(Messages.PrefPageBasicPrompt);
        this.m_perspChangeValue = this.m_store.getInt("PERSP_CHANGE_KEY");
        this.setRadioSelection();
    }

    private void createDataDirGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.PrefPageBasicSelectDataDir);
        group.setLayout((Layout)new GridLayout());
        GridData layoutData = new GridData(768);
        layoutData.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)layoutData);
        Composite content = new Composite((Composite)group, 0);
        this.setGridLayout(content, 3);
        this.m_dataDirIsWorkspaceButton = new Button(content, 32);
        this.m_dataDirIsWorkspaceButton.setText(Messages.PrefPageBasicDataDirWSLabel);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        this.m_dataDirIsWorkspaceButton.setLayoutData((Object)data);
        Label l = new Label(content, 0);
        l.setText(Messages.PrefPageBasicDataDirLabel);
        this.m_dataDirPathTextfield = new CheckedDirnameText(content, 2052);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.m_dataDirPathTextfield.setLayoutData(data);
        this.m_dataDirPathButton = new Button(content, 8);
        this.m_dataDirPathButton.setText(Messages.PrefPageBasicDataDirBrowse);
        this.m_store.setDefault("DATADIR_WS_KEY", true);
        this.m_store.setDefault("DATADIR_PATH_KEY", Platform.getLocation().toOSString());
        this.m_dataDirIsWorkspaceValue = this.m_store.getBoolean("DATADIR_WS_KEY");
        this.setDataDirFields();
    }

    private void setDataDirFields() {
        this.m_dataDirIsWorkspaceButton.setSelection(this.m_dataDirIsWorkspaceValue);
        this.m_dataDirPathTextfield.setEnabled(!this.m_dataDirIsWorkspaceValue);
        this.m_dataDirPathTextfield.setText(this.m_store.getString("DATADIR_PATH_KEY"));
    }

    private void addListener() {
        this.m_perspChange0Button.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_perspChange1Button.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_perspChange2Button.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_dataDirIsWorkspaceButton.addSelectionListener(this.m_dataDirIsWsButtonListener);
        this.m_dataDirPathButton.addSelectionListener(this.m_dataDirPathButtonListener);
        this.m_dataDirPathTextfield.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PrefPageBasic.this.validatePage();
            }
        });
    }

    private void dataDirIsWsChanged(boolean selection) {
        this.m_dataDirPathButton.setEnabled(!selection);
        this.m_dataDirPathTextfield.setEnabled(!selection);
        this.m_dataDirIsWorkspaceValue = selection;
        this.m_dataDirPathTextfield.setText(this.m_dataDirPathTextfield.getText());
        this.validatePage();
    }

    private void browseForDir() {
        DirectoryDialog dialog = new DirectoryDialog(Plugin.getShell(), 69632);
        dialog.setFilterPath(this.m_dataDirPathTextfield.getText());
        dialog.setText(Messages.PrefPageBasicDataDirFileDialogTitle);
        String path = dialog.open();
        if (path != null) {
            this.m_dataDirPathTextfield.setText(path);
        }
    }

    private void validatePage() {
        this.setValid(true);
        this.setErrorMessage(null);
        if (!this.m_dataDirIsWorkspaceValue && !this.m_dataDirPathTextfield.isValid()) {
            this.setValid(false);
            this.setErrorMessage(Messages.PrefPageBasicDataDirInvalid);
        }
    }

    private void removeListener() {
        this.m_perspChange0Button.removeSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_perspChange1Button.removeSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_perspChange2Button.removeSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_dataDirIsWorkspaceButton.removeSelectionListener(this.m_dataDirIsWsButtonListener);
    }

    private void setRadioSelection() {
        if (this.m_perspChangeValue == 0) {
            this.m_perspChange0Button.setSelection(true);
            this.m_perspChange1Button.setSelection(false);
            this.m_perspChange2Button.setSelection(false);
        }
        if (this.m_perspChangeValue == 1) {
            this.m_perspChange1Button.setSelection(true);
            this.m_perspChange0Button.setSelection(false);
            this.m_perspChange2Button.setSelection(false);
        }
        if (this.m_perspChangeValue == 2) {
            this.m_perspChange2Button.setSelection(true);
            this.m_perspChange0Button.setSelection(false);
            this.m_perspChange1Button.setSelection(false);
        }
    }

    private void createMinimizeClientButton(Composite composite) {
        this.m_minimize = new Button(composite, 32);
        this.m_minimize.setText(Messages.JubulaPrefPageBasicMinimize);
        this.m_minimize.setSelection(this.getPreferenceStore().getBoolean("MINIMIZEONSUITESTART_PREF_KEY"));
    }

    private void createAskStopAUTButton(Composite composite) {
        this.m_askStopAUT = new Button(composite, 32);
        this.m_askStopAUT.setText(Messages.JubulaPrefPageBasicAskStopAUT);
        this.m_askStopAUT.setSelection(this.getPreferenceStore().getBoolean("ASKSTOPAUT_PREF_KEY"));
    }

    private void createTreeScrollButton(Composite composite) {
        this.m_treeScroll = new Button(composite, 32);
        this.m_treeScroll.setText(Messages.JubulaPrefPageBasicScroll);
        this.m_treeScroll.setSelection(this.getPreferenceStore().getBoolean("TREEAUTOSCROLL_PREF_KEY"));
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.m_minimize.setSelection(this.m_store.getDefaultBoolean("MINIMIZEONSUITESTART_PREF_KEY"));
        this.m_treeScroll.setSelection(this.m_store.getDefaultBoolean("TREEAUTOSCROLL_PREF_KEY"));
        this.m_askStopAUT.setSelection(this.m_store.getDefaultBoolean("ASKSTOPAUT_PREF_KEY"));
        this.m_showOrigName.setSelection(this.m_store.getDefaultBoolean("SHOWORIGINALNAME_PREF_KEY"));
        this.m_capInfoCheckbox.setSelection(this.m_store.getDefaultBoolean("SHOWCAPINFO_PREF_KEY"));
        this.m_showTransientChildrenCheckBox.setSelection(this.m_store.getDefaultBoolean("SHOW_TRANSIENT_CHILDREN_KEY"));
        this.m_loadDefaultProjectCheckBox.setSelection(this.m_store.getDefaultBoolean("PERFORM_AUTO_PROJECT_LOAD_KEY"));
        this.m_perspChangeValue = this.m_store.getDefaultInt("PERSP_CHANGE_KEY");
        this.m_rememberValue = this.m_store.getDefaultBoolean("REMEMBER_KEY");
        this.setRadioSelection();
        this.m_dataDirIsWorkspaceValue = this.m_store.getDefaultBoolean("DATADIR_WS_KEY");
        this.setDataDirFields();
        this.m_dataDirPathTextfield.setText(this.m_store.getDefaultString("DATADIR_PATH_KEY"));
        this.validatePage();
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("MINIMIZEONSUITESTART_PREF_KEY", this.m_minimize.getSelection());
        this.getPreferenceStore().setValue("REMEMBER_KEY", this.m_rememberValue);
        this.getPreferenceStore().setValue("PERSP_CHANGE_KEY", this.m_perspChangeValue);
        this.getPreferenceStore().setValue("TREEAUTOSCROLL_PREF_KEY", this.m_treeScroll.getSelection());
        this.getPreferenceStore().setValue("ASKSTOPAUT_PREF_KEY", this.m_askStopAUT.getSelection());
        this.getPreferenceStore().setValue("DATADIR_WS_KEY", this.m_dataDirIsWorkspaceValue);
        this.getPreferenceStore().setValue("DATADIR_PATH_KEY", this.m_dataDirPathTextfield.getText());
        this.getPreferenceStore().setValue("SHOWORIGINALNAME_PREF_KEY", this.m_showOrigName.getSelection());
        this.getPreferenceStore().setValue("SHOWCAPINFO_PREF_KEY", this.m_capInfoCheckbox.getSelection());
        this.getPreferenceStore().setValue("SHOW_TRANSIENT_CHILDREN_KEY", this.m_showTransientChildrenCheckBox.getSelection());
        this.getPreferenceStore().setValue("PERFORM_AUTO_PROJECT_LOAD_KEY", this.m_loadDefaultProjectCheckBox.getSelection());
        this.removeListener();
        return super.performOk();
    }

    private class WidgetSelectionListener
    extends SelectionAdapter {
        private WidgetSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object o = e.getSource();
            if (o == PrefPageBasic.this.m_perspChange0Button) {
                PrefPageBasic.this.m_perspChangeValue = 0;
                return;
            }
            if (o == PrefPageBasic.this.m_perspChange1Button) {
                PrefPageBasic.this.m_perspChangeValue = 1;
                return;
            }
            if (o == PrefPageBasic.this.m_perspChange2Button) {
                PrefPageBasic.this.m_perspChangeValue = 2;
                return;
            }
            Assert.notReached((String)(String.valueOf(Messages.EventActivatedUnknownWidget) + "(" + o + ")" + "."));
        }
    }
}

