/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.wizards;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import org.dom4j.Document;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jubula.client.core.businessprocess.CompleteXMLReportGenerator;
import org.eclipse.jubula.client.core.businessprocess.FileXMLReportWriter;
import org.eclipse.jubula.client.core.model.ITestResult;
import org.eclipse.jubula.client.core.model.ITestResultSummary;
import org.eclipse.jubula.client.core.model.ITestResultSummaryPO;
import org.eclipse.jubula.client.core.model.SummarizedTestResult;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.persistence.TestResultPM;
import org.eclipse.jubula.client.ui.editors.TestResultViewer;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.wizards.pages.ExportTestResultDetailsDestinationWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportTestResultDetailsWizard
extends Wizard
implements IExportWizard {
    public static final String ID = "org.eclipse.jubula.client.ui.rcp.exportWizard.ExportTestResultDetailsWizard";
    private static final Logger LOG = LoggerFactory.getLogger(ExportTestResultDetailsWizard.class);
    private static final String[] OVERWRITE_DIALOG_BUTTON_LABELS = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL};
    private static final int[] OVERWRITE_DIALOG_BUTTON_IDS = new int[]{2, 4, 3, 21, 1};
    private ITestResultSummaryPO[] m_selectedSummaries;
    private ExportTestResultDetailsDestinationWizardPage m_destinationPage;

    public void addPages() {
        super.addPages();
        this.m_destinationPage = new ExportTestResultDetailsDestinationWizardPage();
        this.addPage((IWizardPage)this.m_destinationPage);
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)new ExportTestResultDetailsOperation());
        }
        catch (InvocationTargetException e) {
            LOG.error(String.valueOf(Messages.ErrorOccurredWhileExportingTestResultDetails) + ".", e.getCause());
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setNeedsProgressMonitor(true);
        ArrayList<ITestResultSummaryPO> selectedSummaryList = new ArrayList<ITestResultSummaryPO>(selection.size());
        if (Persistor.instance() != null) {
            List idsWithDetails = TestResultPM.computeTestresultIdsWithDetails((EntityManager)GeneralStorage.getInstance().getMasterSession());
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object selectedElement = objectArray[n2];
                if (selectedElement instanceof ITestResultSummaryPO && idsWithDetails.contains(((ITestResultSummaryPO)selectedElement).getId())) {
                    selectedSummaryList.add((ITestResultSummaryPO)selectedElement);
                }
                ++n2;
            }
        }
        this.m_selectedSummaries = selectedSummaryList.toArray(new ITestResultSummaryPO[selectedSummaryList.size()]);
        this.setWindowTitle(NLS.bind((String)Messages.ExportTestResultDetailsWizardWindowTitle, (Object)this.m_selectedSummaries.length));
    }

    private class ExportTestResultDetailsOperation
    implements IRunnableWithProgress {
        private static final int OVERWRITE_NOT_SET = 0;
        private static final int OVERWRITE_NONE = 1;
        private static final int OVERWRITE_ALL = 2;
        private int m_overwriteState = 0;

        private ExportTestResultDetailsOperation() {
        }

        public void run(IProgressMonitor monitor) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Exporting...", (int)(ExportTestResultDetailsWizard.this.m_selectedSummaries.length * 2));
            try {
                ITestResultSummaryPO[] iTestResultSummaryPOArray = ExportTestResultDetailsWizard.this.m_selectedSummaries;
                int n = iTestResultSummaryPOArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITestResultSummaryPO summary = iTestResultSummaryPOArray[n2];
                    TestResultViewer.GenerateTestResultTreeOperation operation = new TestResultViewer.GenerateTestResultTreeOperation(summary.getId(), summary.getInternalProjectID());
                    operation.run((IProgressMonitor)subMonitor.newChild(1));
                    TestResultNode rootDetailNode = operation.getRootNode();
                    CompleteXMLReportGenerator generator = new CompleteXMLReportGenerator((ITestResult)new SummarizedTestResult((ITestResultSummary)summary, rootDetailNode));
                    this.exportDocument(generator.generateXmlReport(), summary, (IProgressMonitor)subMonitor);
                    ++n2;
                }
            }
            finally {
                monitor.done();
            }
        }

        private void exportDocument(Document document, ITestResultSummaryPO summary, IProgressMonitor monitor) {
            try {
                boolean isWriteFile;
                File fileToWrite = new File(ExportTestResultDetailsWizard.this.m_destinationPage.getDestination(), String.valueOf(summary.getTestsuiteName()) + "_" + summary.getTestsuiteStartTime().getTime());
                FileXMLReportWriter reportWriter = new FileXMLReportWriter(fileToWrite.getAbsolutePath());
                boolean bl = isWriteFile = this.m_overwriteState == 2 || !this.doesFileExist(reportWriter);
                if (!isWriteFile && this.m_overwriteState != 1) {
                    final MessageDialog dialog = new MessageDialog(ExportTestResultDetailsWizard.this.getContainer().getShell(), Messages.ExportTestResultDetailsConfirmOverwriteTitle, null, NLS.bind((String)Messages.ExportTestResultDetailsWizardPageDescription, (Object)fileToWrite.getCanonicalPath()), 3, OVERWRITE_DIALOG_BUTTON_LABELS, 0);
                    ExportTestResultDetailsWizard.this.getShell().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            dialog.open();
                        }
                    });
                    int dialogResult = dialog.getReturnCode();
                    dialogResult = dialogResult == -1 ? 1 : OVERWRITE_DIALOG_BUTTON_IDS[dialogResult];
                    switch (dialogResult) {
                        case 4: {
                            this.m_overwriteState = 2;
                        }
                        case 2: {
                            isWriteFile = true;
                            break;
                        }
                        case 21: {
                            this.m_overwriteState = 1;
                        }
                        case 3: {
                            isWriteFile = false;
                            break;
                        }
                        case 1: {
                            return;
                        }
                        default: {
                            LOG.warn(String.valueOf(Messages.UnexpectedDialogReturnCode) + ":" + " " + dialogResult);
                        }
                    }
                }
                if (isWriteFile) {
                    reportWriter.write(document);
                }
                monitor.worked(1);
            }
            catch (IOException ioe) {
                Plugin.getDefault().handleError(ioe);
            }
        }

        private boolean doesFileExist(FileXMLReportWriter reportWriter) {
            boolean doesXmlFileExist = new File(reportWriter.getXmlFileName()).exists();
            boolean doesHtmlFileExist = new File(reportWriter.getHtmlFileName()).exists();
            return doesHtmlFileExist || doesXmlFileExist;
        }
    }
}

