/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.views.imageview;

import org.apache.commons.lang.ObjectUtils;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.JobUtils;
import org.eclipse.jubula.client.ui.views.IJBPart;
import org.eclipse.jubula.client.ui.views.NonSortedPropertySheetPage;
import org.eclipse.jubula.client.ui.views.imageview.ImageProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class ImageView
extends ViewPart
implements IJBPart,
ISelectionProvider {
    private Label m_imgWidget;
    private Image m_img;
    private ISelection m_currSelection = null;
    private ScrolledComposite m_scrollComposite;
    private Composite m_child;
    private ISelectionListener m_selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            ImageView.this.handleSelection(selection);
        }
    };

    private void handleSelection(ISelection selection) {
        IStructuredSelection ss;
        ImageProvider provider = null;
        if (selection != null && selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() > 0) {
            Object object = ss.getFirstElement();
            if (this.m_currSelection != null && ObjectUtils.equals((Object)object, (Object)((IStructuredSelection)this.m_currSelection).getFirstElement())) {
                return;
            }
            this.m_currSelection = ss;
            if (object instanceof IAdaptable) {
                provider = (ImageProvider)((IAdaptable)object).getAdapter(ImageProvider.class);
            }
            if (provider == null) {
                provider = (ImageProvider)Platform.getAdapterManager().getAdapter(object, ImageProvider.class);
            }
        }
        if (provider == null) {
            this.clearImage();
        } else {
            this.handleSelection(provider);
        }
    }

    private void handleSelection(final ImageProvider provider) {
        final String jobName = Messages.UIJobLoadingImage;
        Job job = new Job(jobName){

            public IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(jobName, -1);
                ImageView.this.setImage(provider);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        JobUtils.executeJob(job, null);
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.m_scrollComposite = new ScrolledComposite(parent, 768);
        this.m_child = new Composite((Composite)this.m_scrollComposite, 0);
        this.m_child.setLayout((Layout)new FillLayout());
        this.m_imgWidget = new Label(this.m_child, 0);
        this.m_scrollComposite.setExpandHorizontal(true);
        this.m_scrollComposite.setExpandVertical(true);
        this.m_scrollComposite.setMinSize(this.m_child.computeSize(-1, -1));
        this.m_scrollComposite.setContent((Control)this.m_child);
        this.getSelectionService().addSelectionListener(this.m_selectionListener);
        this.handleSelection(this.getSelectionService().getSelection());
        this.getSite().setSelectionProvider((ISelectionProvider)this);
    }

    protected void setImage(final ImageProvider provider) {
        this.m_scrollComposite.getDisplay().syncExec(new Runnable(){

            public void run() {
                ImageView.this.clearImage();
                ImageView.this.m_img = provider.getImage((Device)ImageView.this.m_scrollComposite.getDisplay());
                ImageView.this.m_imgWidget.setImage(ImageView.this.m_img);
                if (ImageView.this.m_img != null) {
                    ImageView.this.m_imgWidget.setSize(((ImageView)ImageView.this).m_img.getBounds().width, ((ImageView)ImageView.this).m_img.getBounds().height);
                }
                ImageView.this.m_scrollComposite.setMinSize(ImageView.this.m_child.computeSize(-1, -1));
            }
        });
    }

    protected void clearImage() {
        Image oldImage = this.m_imgWidget.getImage();
        this.m_imgWidget.setImage(null);
        if (oldImage != null) {
            oldImage.dispose();
        }
    }

    public void dispose() {
        this.getSelectionService().removeSelectionListener(this.m_selectionListener);
        if (this.m_img != null) {
            this.m_img.dispose();
        }
        super.dispose();
    }

    public void setFocus() {
        this.m_imgWidget.setFocus();
    }

    private ISelectionService getSelectionService() {
        return this.getSite().getWorkbenchWindow().getSelectionService();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public ISelection getSelection() {
        return this.m_currSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void setSelection(ISelection selection) {
    }

    public Object getAdapter(Class key) {
        if (key.equals(IPropertySheetPage.class)) {
            return new NonSortedPropertySheetPage();
        }
        return super.getAdapter(key);
    }
}

