/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jubula.communication.ICommand;
import org.eclipse.jubula.communication.message.AUTStartStateMessage;
import org.eclipse.jubula.communication.message.Message;
import org.eclipse.jubula.communication.message.SendAUTListOfSupportedComponentsMessage;
import org.eclipse.jubula.rc.common.AUTServerConfiguration;
import org.eclipse.jubula.rc.common.exception.UnsupportedComponentException;
import org.eclipse.jubula.rc.common.implclasses.IComponentFactory;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.objects.ComponentIdentifier;
import org.eclipse.jubula.tools.objects.IComponentIdentifier;
import org.eclipse.jubula.tools.xml.businessmodell.Component;
import org.eclipse.jubula.tools.xml.businessmodell.ConcreteComponent;
import org.eclipse.jubula.tools.xml.businessmodell.DefaultMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSendAUTListOfSupportedComponentsCommand
implements ICommand {
    private static Logger log;
    private SendAUTListOfSupportedComponentsMessage m_message;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.common.commands.AbstractSendAUTListOfSupportedComponentsCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    public Message getMessage() {
        return this.m_message;
    }

    public void setMessage(Message message) {
        this.m_message = (SendAUTListOfSupportedComponentsMessage)message;
    }

    protected IComponentIdentifier createIdentifier(ConcreteComponent c) throws UnsupportedComponentException {
        DefaultMapping defaultMapping = c.getDefaultMapping();
        String typeFactoryName = defaultMapping.getTypeFactory();
        String technicalName = defaultMapping.getTechnicalName();
        try {
            Class<?> typeFactoryClass = Class.forName(typeFactoryName);
            IComponentFactory factory = (IComponentFactory)typeFactoryClass.newInstance();
            this.addToHierarchy(factory, c, technicalName);
            ComponentIdentifier id = new ComponentIdentifier();
            id.setComponentClassName(c.getType());
            id.setSupportedClassName(c.getComponentClass());
            ArrayList<String> list = new ArrayList<String>();
            list.add(technicalName);
            id.setHierarchyNames(list);
            return id;
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedComponentException(e.getMessage(), MessageIDs.E_CLASS_NOT_FOUND);
        }
        catch (InstantiationException e) {
            throw new UnsupportedComponentException(e.getMessage(), MessageIDs.E_INSTANTIATION);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedComponentException(e.getMessage(), MessageIDs.E_ILLEGAL_ACCESS);
        }
    }

    protected abstract void addToHierarchy(IComponentFactory var1, ConcreteComponent var2, String var3) throws UnsupportedComponentException;

    public Message execute() {
        log.info("Entering method " + this.getClass().getName() + ".execute().");
        List componentIds = new ArrayList();
        AUTServerConfiguration.getInstance().setProfile(this.m_message.getProfile());
        Iterator it = this.m_message.getComponents().iterator();
        while (it.hasNext()) {
            Component component = (Component)it.next();
            if (!component.isConcrete()) continue;
            ConcreteComponent concrete = (ConcreteComponent)component;
            try {
                AUTServerConfiguration.getInstance().registerComponent(concrete);
                if (!concrete.hasDefaultMapping()) continue;
                componentIds = this.addComponentID(componentIds, concrete);
            }
            catch (UnsupportedComponentException e) {
                log.error("An error occurred while registering a component.", (Throwable)((Object)e));
            }
            catch (IllegalArgumentException e) {
                log.error("An error occurred while registering a component.", (Throwable)e);
            }
        }
        log.info("Exiting method " + this.getClass().getName() + ".execute().");
        return new AUTStartStateMessage(componentIds);
    }

    protected abstract List addComponentID(List var1, ConcreteComponent var2) throws UnsupportedComponentException;

    public void timeout() {
        log.error(String.valueOf(this.getClass().getName()) + ".timeout() called");
    }
}

