/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.implclasses;

import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.IndexConverter;
import org.eclipse.jubula.rc.common.implclasses.MatchUtil;
import org.eclipse.jubula.rc.common.implclasses.Verifier;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.swt.implclasses.AbstractTabFolderImplClass;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public class CTabFolderImplClass
extends AbstractTabFolderImplClass {
    private static AutServerLogger log;
    private CTabFolder m_ctabFolder;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swt.implclasses.CTabFolderImplClass");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = new AutServerLogger((Class)clazz);
    }

    public void setComponent(Object graphicsComponent) {
        this.m_ctabFolder = (CTabFolder)graphicsComponent;
    }

    public Control getComponent() {
        return this.m_ctabFolder;
    }

    protected int getIndexOfTab(final String title, final String operator) {
        int index = (Integer)this.getEventThreadQueuer().invokeAndWait("indexOfTab", new IRunnable(){

            public Object run() throws StepExecutionException {
                int i = 0;
                while (i < CTabFolderImplClass.this.m_ctabFolder.getItemCount()) {
                    if (MatchUtil.getInstance().match(SwtUtils.removeMnemonics(CTabFolderImplClass.this.m_ctabFolder.getItem(i).getText()), title, operator)) {
                        int j = CTabFolderImplClass.this.m_ctabFolder.indexOf(CTabFolderImplClass.this.m_ctabFolder.getItem(i));
                        return new Integer(j);
                    }
                    ++i;
                }
                return new Integer(-1);
            }
        });
        if (index == -1) {
            throw new StepExecutionException("Can not find tab: '" + title + "' using operator: '" + operator + "'", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        return index;
    }

    protected String getTitleOfTab(final int index) {
        String tabTitle = (String)this.getEventThreadQueuer().invokeAndWait("verifyTextOfTabByIndex", new IRunnable(){

            public Object run() throws StepExecutionException {
                CTabFolderImplClass.this.verifyIndexExists(index);
                return CTabFolderImplClass.this.m_ctabFolder.getItem(index).getText();
            }
        });
        return tabTitle;
    }

    protected Rectangle getBoundsAt(final int index) {
        return (Rectangle)this.getEventThreadQueuer().invokeAndWait("getBoundsAt", new IRunnable(){

            public Object run() throws StepExecutionException {
                return SwtUtils.getRelativeWidgetBounds((Widget)CTabFolderImplClass.this.m_ctabFolder.getItem(index), (Control)CTabFolderImplClass.this.m_ctabFolder);
            }
        });
    }

    protected void verifyIndexExists(final int index) throws StepExecutionException {
        Boolean exists = (Boolean)this.getEventThreadQueuer().invokeAndWait("indexOfTab", new IRunnable(){

            public Object run() throws StepExecutionException {
                int i = CTabFolderImplClass.this.m_ctabFolder.getItemCount();
                return index >= 0 && index < i ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        if (!exists.booleanValue()) {
            throw new StepExecutionException("The tab index doesn't exist: " + index, EventFactory.createActionError((String)"TestErrorEvent.InvalidIndex"));
        }
    }

    public void gdVerifySelectedTabByIndex(int index, boolean selected) throws StepExecutionException {
        int implIdx = IndexConverter.toImplementationIndex((int)index);
        int selIndex = (Integer)this.getEventThreadQueuer().invokeAndWait("getSelectedIndex", new IRunnable(){

            public Object run() throws StepExecutionException {
                return new Integer(CTabFolderImplClass.this.m_ctabFolder.getSelectionIndex());
            }
        });
        if (selIndex == -1) {
            if (!selected) {
                return;
            }
            throw new StepExecutionException(I18n.getString((String)"TestErrorEvent.NoSelection"), EventFactory.createActionError((String)"TestErrorEvent.NoSelection"));
        }
        Verifier.equals((boolean)selected, (selIndex == implIdx ? 1 : 0) != 0);
    }

    public void gdVerifySelectedTab(String title, String operator, boolean selected) throws StepExecutionException {
        String selectedTabTitle = (String)this.getEventThreadQueuer().invokeAndWait("getSelectedTitle", new IRunnable(){

            public Object run() throws StepExecutionException {
                CTabItem selectedItem = CTabFolderImplClass.this.m_ctabFolder.getSelection();
                if (selectedItem == null) {
                    return null;
                }
                return SwtUtils.removeMnemonics(selectedItem.getText());
            }
        });
        if (selectedTabTitle == null) {
            if (!selected) {
                return;
            }
            throw new StepExecutionException(I18n.getString((String)"TestErrorEvent.NoSelection"), EventFactory.createActionError((String)"TestErrorEvent.NoSelection"));
        }
        Verifier.match((String)selectedTabTitle, (String)title, (String)operator, (boolean)selected);
    }

    public void gdVerifyEnabled(String title, String operator, boolean isEnabled) throws StepExecutionException {
        final int tabIndex = this.getIndexOfTab(title, operator);
        this.verify(isEnabled, "isEnabledAt", new IRunnable(){

            public Object run() throws StepExecutionException {
                Control control = CTabFolderImplClass.this.m_ctabFolder.getItem(tabIndex).getControl();
                if (control == null) {
                    log.debug((Object)(this + ".getControl() returned null."));
                    return Boolean.TRUE;
                }
                return control.isEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    public void gdVerifyEnabledByIndex(int index, boolean enabled) throws StepExecutionException {
        final int implIdx = IndexConverter.toImplementationIndex((int)index);
        this.verifyIndexExists(implIdx);
        this.verify(enabled, "isEnabledAt", new IRunnable(){

            public Object run() throws StepExecutionException {
                Control control = CTabFolderImplClass.this.m_ctabFolder.getItem(implIdx).getControl();
                if (control == null) {
                    log.debug((Object)(this + ".getControl() returned null."));
                    return Boolean.TRUE;
                }
                return control.isEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    public String[] getTextArrayFromComponent() {
        CTabItem[] itemArray = this.m_ctabFolder.getItems();
        String[] componentTextArray = this.getTextArrayFromItemArray((Item[])itemArray);
        return componentTextArray;
    }

    protected void ensureTabIsShowing(final int index) {
        this.getEventThreadQueuer().invokeAndWait("showTab", new IRunnable(){

            public Object run() throws StepExecutionException {
                CTabFolderImplClass.this.m_ctabFolder.showItem(CTabFolderImplClass.this.m_ctabFolder.getItem(index));
                return null;
            }
        });
        Boolean isShowing = (Boolean)this.getEventThreadQueuer().invokeAndWait("ensureTabIsShowing", new IRunnable(){

            public Object run() throws StepExecutionException {
                return CTabFolderImplClass.this.m_ctabFolder.getItem(index).isShowing() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        if (!isShowing.booleanValue()) {
            throw new StepExecutionException("The chosen tab could not be shown.", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
    }

    protected boolean indexOrTitleOfTabExists(final String tab, final String operator) {
        int tabIndex = -1;
        try {
            tabIndex = IndexConverter.toImplementationIndex((int)Integer.parseInt(tab));
        }
        catch (NumberFormatException numberFormatException) {
            tabIndex = (Integer)this.getEventThreadQueuer().invokeAndWait("indexOrTitleOfTabExists", new IRunnable(){

                public Object run() throws StepExecutionException {
                    int i = 0;
                    while (i < CTabFolderImplClass.this.m_ctabFolder.getItemCount()) {
                        if (MatchUtil.getInstance().match(SwtUtils.removeMnemonics(CTabFolderImplClass.this.m_ctabFolder.getItem(i).getText()), tab, operator)) {
                            int j = CTabFolderImplClass.this.m_ctabFolder.indexOf(CTabFolderImplClass.this.m_ctabFolder.getItem(i));
                            return new Integer(j);
                        }
                        ++i;
                    }
                    return new Integer(-1);
                }
            });
        }
        final int index = tabIndex;
        Boolean tabExists = (Boolean)this.getEventThreadQueuer().invokeAndWait("verifyExistenceOfTab", new IRunnable(){

            public Object run() throws StepExecutionException {
                if (index < 0 || index >= CTabFolderImplClass.this.m_ctabFolder.getItemCount()) {
                    return new Boolean(false);
                }
                return new Boolean(true);
            }
        });
        return tabExists;
    }
}

