/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.conf.model.resource.internal;

import java.util.HashMap;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jwt.we.conf.model.plugin.ConfPlugin;
import org.eclipse.jwt.we.conf.model.resource.ConfModelResourceManager;
import org.eclipse.jwt.we.conf.model.resource.internal.ConfModelResourceManagerImpl;

public class ConfModelSavingModelResourceAdapter
implements Adapter {
    private Resource confModelResource;
    private URI modelUri;
    private boolean disabled = false;

    public ConfModelSavingModelResourceAdapter(Resource confModelResource, URI modelUri) {
        this.confModelResource = confModelResource;
        this.modelUri = modelUri;
    }

    public Notifier getTarget() {
        return null;
    }

    public boolean isAdapterForType(Object type) {
        return type == ConfModelResourceManager.class;
    }

    public void notifyChanged(Notification notification) {
        if (this.disabled) {
            return;
        }
        if (notification.getFeatureID(Resource.class) == 3 && notification.getEventType() == 1 && !notification.getNewBooleanValue() && notification.getNotifier() instanceof Resource) {
            if (!this.modelUri.equals((Object)((Resource)notification.getNotifier()).getURI())) {
                URI newModelUri = ((Resource)notification.getNotifier()).getURI();
                URI newConfModelUri = ((ConfModelResourceManagerImpl)ConfModelResourceManager.INSTANCE).buildConfModelUriForModel(newModelUri);
                this.confModelResource.setURI(newConfModelUri);
            }
            try {
                this.confModelResource.save(new HashMap());
            }
            catch (Exception ex) {
                ConfPlugin.logger.warning("Error saving ConfModel " + this.confModelResource.getURI() + " on change notification (meaning save) from model " + this.modelUri, ex);
            }
        }
    }

    public void setTarget(Notifier newTarget) {
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public Resource getConfModelResource() {
        return this.confModelResource;
    }

    public URI getModelUri() {
        return this.modelUri;
    }
}

