/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.wizards;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.model.config.TraceChannel;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.model.config.TraceChannels;
import org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.Messages;
import org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.wizards.ITraceChannelConfigurationPage;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class UstTraceChannelConfigurationPage
extends WizardPage
implements ITraceChannelConfigurationPage {
    private TraceChannels fChannels;
    private Composite fContainer;
    private Text fChannelTimerText;

    protected UstTraceChannelConfigurationPage(TraceChannels channels) {
        super("UstTraceChannelConfigurationPage");
        this.fChannels = channels;
        this.setTitle(Messages.ChannelConfigPage_PageTitle);
    }

    public void createControl(Composite parent) {
        this.fContainer = new Composite(parent, 0);
        this.fContainer.setLayout((Layout)new GridLayout());
        this.setControl((Control)this.fContainer);
        Composite headerComposite = new Composite(this.fContainer, 4);
        GridLayout headerLayout = new GridLayout(4, true);
        headerLayout.marginHeight = 0;
        headerLayout.marginWidth = 0;
        headerComposite.setLayout((Layout)headerLayout);
        headerComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(headerComposite, 16384);
        label.setText(String.valueOf(Messages.ChannelConfigPage_ChannelTimer) + ":");
        label.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.fChannelTimerText = new Text(headerComposite, 16384);
        this.fChannelTimerText.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.fChannelTimerText.setToolTipText(Messages.ChannelConfigPage_ChannelTimerTooltip);
        TraceChannel chan = this.fChannels.get((Object)"AUTO");
        if (chan.getTimer() == -1L) {
            this.fChannelTimerText.setText("?");
        } else {
            this.fChannelTimerText.setText(String.valueOf(chan.getTimer()));
        }
        this.fChannelTimerText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = e.text.matches("[0-9]*");
            }
        });
        this.fChannelTimerText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String valueString = UstTraceChannelConfigurationPage.this.fChannelTimerText.getText();
                TraceChannel chan = UstTraceChannelConfigurationPage.this.fChannels.get((Object)"AUTO");
                if (valueString.length() == 0) {
                    valueString = "0";
                } else if ("?".equals(valueString)) {
                    chan.setTimer(-1L);
                } else {
                    chan.setTimer((long)Integer.parseInt(valueString));
                }
            }
        });
    }

    public void dispose() {
        super.dispose();
    }

    @Override
    public TraceChannels getTraceChannels() {
        return this.fChannels;
    }
}

