/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.launch;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.linuxtools.internal.perf.PerfCore;
import org.eclipse.linuxtools.profiling.launch.ProfileLaunchShortcut;
import org.eclipse.ui.IEditorLauncher;

public class PerfOpenData
extends ProfileLaunchShortcut
implements IEditorLauncher {
    public void open(IPath file) {
        String projectName = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(file).getProject().getName();
        ILaunchConfiguration config = this.createDefaultConfiguration(projectName);
        PerfCore.Report(config, null, null, null, file.toOSString(), null);
    }

    protected ILaunchConfigurationType getLaunchConfigType() {
        return this.getLaunchManager().getLaunchConfigurationType("org.eclipse.linuxtools.perf.launch.profile");
    }

    protected void setDefaultProfileAttributes(ILaunchConfigurationWorkingCopy wc) {
        wc.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", false);
        wc.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", true);
    }

    protected ILaunchConfiguration createDefaultConfiguration(String projectName) {
        ILaunchConfigurationWorkingCopy config = null;
        try {
            ILaunchConfigurationType configType = this.getLaunchConfigType();
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName(projectName));
            wc.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", projectName);
            config = wc;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return config;
    }
}

