/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.dashboard.actions;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.systemtap.ui.consolelog.ClientSession;
import org.eclipse.linuxtools.systemtap.ui.consolelog.ScpClient;
import org.eclipse.linuxtools.systemtap.ui.consolelog.Subscription;
import org.eclipse.linuxtools.systemtap.ui.consolelog.dialogs.SelectServerDialog;
import org.eclipse.linuxtools.systemtap.ui.consolelog.internal.ConsoleLogPlugin;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.ScriptConsole;
import org.eclipse.linuxtools.systemtap.ui.dashboard.actions.PauseModuleAction;
import org.eclipse.linuxtools.systemtap.ui.dashboard.actions.StopModuleAction;
import org.eclipse.linuxtools.systemtap.ui.dashboard.actions.hidden.GetSelectedModule;
import org.eclipse.linuxtools.systemtap.ui.dashboard.structures.ActiveModuleData;
import org.eclipse.linuxtools.systemtap.ui.dashboard.structures.DashboardModule;
import org.eclipse.linuxtools.systemtap.ui.dashboard.views.ActiveModuleBrowserView;
import org.eclipse.linuxtools.systemtap.ui.dashboard.views.DashboardModuleBrowserView;
import org.eclipse.linuxtools.systemtap.ui.graphicalrun.structures.ChartStreamDaemon2;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.datasets.IDataSet;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.dataset.DataSetFactory;
import org.eclipse.linuxtools.systemtap.ui.structures.TreeNode;
import org.eclipse.linuxtools.systemtap.ui.structures.listeners.IActionListener;
import org.eclipse.linuxtools.systemtap.ui.structures.listeners.IGobblerListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class RunModuleAction
extends Action
implements IViewActionDelegate,
IWorkbenchWindowActionDelegate {
    private final IActionListener stopListener = new IActionListener(){

        public void handleActionEvent() {
            RunModuleAction.this.setEnablement(true);
        }
    };
    private final IActionListener pauseListener = new IActionListener(){

        public void handleActionEvent() {
            RunModuleAction.this.setEnablement(true);
        }
    };
    private final ISelectionChangedListener activeModuleListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent e) {
            try {
                TreeNode node = (TreeNode)((StructuredSelection)e.getSelection()).getFirstElement();
                if (((ActiveModuleData)node.getData()).paused) {
                    RunModuleAction.this.setEnablement(true);
                } else {
                    RunModuleAction.this.setEnablement(false);
                }
            }
            catch (Exception exception) {}
        }
    };
    private final ISelectionChangedListener moduleListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent e) {
            try {
                TreeNode node = (TreeNode)((StructuredSelection)e.getSelection()).getFirstElement();
                IViewPart ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.dashboard.views.ActiveModuleBrowserView");
                ActiveModuleBrowserView amdv = (ActiveModuleBrowserView)ivp;
                DashboardModule module = node.getData() instanceof DashboardModule ? (DashboardModule)node.getData() : null;
                int childcount = node.getChildCount();
                if (childcount == 0 && !amdv.isActive(module)) {
                    RunModuleAction.this.setEnablement(true);
                } else if (amdv.isActive(module) && amdv.isPaused(module)) {
                    RunModuleAction.this.setEnablement(true);
                } else if (childcount > 0) {
                    boolean active = false;
                    int j = 0;
                    while (j < childcount) {
                        if (amdv.isActive((DashboardModule)node.getChildAt(j).getData())) {
                            active = true;
                            break;
                        }
                        ++j;
                    }
                    if (!active) {
                        RunModuleAction.this.setEnablement(true);
                    }
                } else {
                    RunModuleAction.this.setEnablement(false);
                }
            }
            catch (Exception exception) {}
        }
    };
    private IViewPart view;
    private static ArrayList<IActionListener> listeners = new ArrayList();
    private String fileName = null;
    protected IWorkbenchWindow fWindow = null;
    private IAction act;
    protected Subscription subscription;
    protected int SCRIPT_ID;
    protected ScriptConsole console;

    public void init(IViewPart view) {
        this.view = view;
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void run(IAction act) {
        this.run();
    }

    public void run() {
        Display disp = PlatformUI.getWorkbench().getDisplay();
        Cursor cursor = new Cursor((Device)disp, 1);
        PlatformUI.getWorkbench().getDisplay().getActiveShell().setCursor(cursor);
        DashboardModule module = null;
        TreeNode node = GetSelectedModule.getNode(this.view);
        if (node.getChildCount() == 0) {
            module = (DashboardModule)node.getData();
            if (module != null) {
                this.runScript(module);
                this.setEnablement(false);
                this.buildEnablementChecks();
                RunModuleAction.fireActionEvent();
            }
        } else {
            int j = 0;
            while (j < node.getChildCount()) {
                module = (DashboardModule)node.getChildAt(j).getData();
                this.runScript(module);
                this.setEnablement(false);
                this.buildEnablementChecks();
                RunModuleAction.fireActionEvent();
                ++j;
            }
        }
        PlatformUI.getWorkbench().getDisplay().getActiveShell().setCursor(null);
        cursor.dispose();
    }

    private void addActive(String display, ActiveModuleData amd) {
        IViewPart ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.dashboard.views.ActiveModuleBrowserView");
        ((ActiveModuleBrowserView)ivp).add(display, amd);
    }

    private void runScript(DashboardModule module) {
        String modname;
        IViewPart ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.dashboard.views.ActiveModuleBrowserView");
        ActiveModuleBrowserView ambv = (ActiveModuleBrowserView)ivp;
        boolean paused = ambv.isPaused(module);
        String tmpfileName = this.fileName = module.script.getAbsolutePath();
        String serverfileName = this.fileName.substring(this.fileName.lastIndexOf(47) + 1);
        if (!ConsoleLogPlugin.getDefault().getPreferenceStore().getBoolean("rememberServer") && !new SelectServerDialog(this.fWindow.getShell()).open()) {
            return;
        }
        if (module.location.equalsIgnoreCase("local")) {
            try {
                ScpClient scpclient = new ScpClient();
                tmpfileName = null;
                tmpfileName = "/tmp/" + serverfileName;
                scpclient.transfer(this.fileName, tmpfileName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((modname = serverfileName.substring(0, serverfileName.indexOf(46))).indexOf(45) != -1) {
            modname = modname.substring(0, modname.indexOf(45));
        }
        String[] cmd = new String[]{"stap", "-g", "-m", modname, tmpfileName};
        ScriptConsole console = ScriptConsole.getInstance((String)serverfileName);
        console.run(cmd, null, null, null);
        IDataSet ds = paused ? ambv.pause((DashboardModule)module).data : DataSetFactory.createDataSet((String)module.dataSetID, (String[])module.labels);
        console.getCommand().addInputStreamListener((IGobblerListener)new ChartStreamDaemon2(console, ds, module.parser));
        ActiveModuleData amd = new ActiveModuleData();
        amd.module = module;
        amd.cmd = console;
        amd.data = ds;
        amd.paused = false;
        this.addActive(String.valueOf(module.category) + "." + module.display, amd);
    }

    public void selectionChanged(IAction act, ISelection select) {
        this.act = act;
        this.setEnablement(false);
        this.buildEnablementChecks();
    }

    private void buildEnablementChecks() {
        IViewPart ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.dashboard.views.DashboardModuleBrowserView");
        if (ivp != null) {
            DashboardModuleBrowserView dmbv = (DashboardModuleBrowserView)ivp;
            dmbv.getViewer().addSelectionChangedListener(this.moduleListener);
            ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.dashboard.views.ActiveModuleBrowserView");
            ActiveModuleBrowserView ambv = (ActiveModuleBrowserView)ivp;
            ambv.getViewer().addSelectionChangedListener(this.activeModuleListener);
            StopModuleAction.addActionListener(this.stopListener);
            PauseModuleAction.addActionListener(this.pauseListener);
        }
    }

    private void setEnablement(boolean enabled) {
        this.act.setEnabled(enabled);
    }

    public void dispose() {
        try {
            IViewPart ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.dashboard.views.DashboardModuleBrowserView");
            DashboardModuleBrowserView dmbv = (DashboardModuleBrowserView)ivp;
            dmbv.getViewer().removeSelectionChangedListener(this.moduleListener);
            ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.dashboard.views.ActiveModuleBrowserView");
            ActiveModuleBrowserView ambv = (ActiveModuleBrowserView)ivp;
            ambv.getViewer().removeSelectionChangedListener(this.activeModuleListener);
            StopModuleAction.removeActionListener(this.stopListener);
            PauseModuleAction.removeActionListener(this.pauseListener);
        }
        catch (Exception exception) {}
        this.view = null;
        this.act = null;
        this.fWindow = null;
    }

    public static void addActionListener(IActionListener listener) {
        listeners.add(listener);
    }

    public static void removeActionListener(IActionListener listener) {
        listeners.remove(listener);
    }

    private static void fireActionEvent() {
        int i = 0;
        while (i < listeners.size()) {
            listeners.get(i).handleActionEvent();
            ++i;
        }
    }

    protected boolean createClientSession() {
        if (!ClientSession.isConnected() && new SelectServerDialog(this.fWindow.getShell()).open()) {
            this.subscription = new Subscription(this.fileName, false);
            ClientSession.isConnected();
        }
        return true;
    }
}

