/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.views;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.actions.hidden.FunctionBrowserAction;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.views.BrowserView;
import org.eclipse.linuxtools.systemtap.ui.ide.structures.TapsetLibrary;
import org.eclipse.linuxtools.systemtap.ui.logging.LogManager;
import org.eclipse.linuxtools.systemtap.ui.structures.TreeNode;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class FunctionBrowserView
extends BrowserView {
    public static final String ID = "org.eclipse.linuxtools.internal.systemtap.ui.ide.views.FunctionBrowserView";
    private FunctionBrowserAction doubleClickAction;
    private IDoubleClickListener dblClickListener;
    private TreeNode functions;
    private TreeNode localFunctions;
    private Menu menu;

    public FunctionBrowserView() {
        LogManager.logInfo((String)"Initializing", (Object)((Object)this));
    }

    public void createPartControl(Composite parent) {
        LogManager.logDebug((String)("Start createPartControl: parent-" + parent), (Object)((Object)this));
        super.createPartControl(parent);
        TapsetLibrary.init();
        TapsetLibrary.addListener(new BrowserView.ViewUpdater());
        this.refresh();
        this.makeActions();
        LogManager.logDebug((String)"End createPartControl:", (Object)((Object)this));
    }

    public void refresh() {
        LogManager.logDebug((String)"Start refresh:", (Object)((Object)this));
        this.functions = TapsetLibrary.getFunctions();
        this.addLocalFunctions(this.localFunctions);
        LogManager.logDebug((String)"End refresh:", (Object)((Object)this));
    }

    public void addLocalFunctions(TreeNode localFunctionTree) {
        LogManager.logDebug((String)("Start addLocalFunctions: localFunctionTree-" + localFunctionTree), (Object)((Object)this));
        if (this.functions.getChildCount() > 0) {
            TreeNode localFuncs = this.functions.getChildAt(0);
            if ("<local>".equals(localFuncs.toString())) {
                this.functions.remove(0);
            }
            if (this.localFunctions != null) {
                this.localFunctions = localFunctionTree;
                this.localFunctions.setDisplay("<local>");
                this.functions.addAt(this.localFunctions, 0);
            }
        }
        this.viewer.setInput((Object)this.functions);
        LogManager.logDebug((String)"End addLocalFunctions:", (Object)((Object)this));
    }

    private void makeActions() {
        LogManager.logDebug((String)"Start makeActions:", (Object)((Object)this));
        this.doubleClickAction = new FunctionBrowserAction(this.getSite().getWorkbenchWindow(), this);
        this.dblClickListener = new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                LogManager.logDebug((String)("Start doubleClick: event-" + event), (Object)this);
                FunctionBrowserView.this.doubleClickAction.run();
                LogManager.logDebug((String)"End doubleClick:", (Object)this);
            }
        };
        this.viewer.addDoubleClickListener(this.dblClickListener);
        MenuManager manager = new MenuManager("functionPopup");
        Control control = this.viewer.getControl();
        manager.add((IContributionItem)new Separator("additions"));
        Menu menu = manager.createContextMenu(control);
        control.setMenu(menu);
        this.getSite().registerContextMenu(manager, (ISelectionProvider)this.viewer);
        LogManager.logDebug((String)"End makeActions:", (Object)((Object)this));
    }

    public void dispose() {
        LogManager.logInfo((String)"Disposing", (Object)((Object)this));
        super.dispose();
        if (this.doubleClickAction != null) {
            this.doubleClickAction.dispose();
        }
        this.doubleClickAction = null;
        if (this.viewer != null) {
            this.viewer.removeDoubleClickListener(this.dblClickListener);
        }
        this.dblClickListener = null;
        if (this.localFunctions != null) {
            this.localFunctions.dispose();
        }
        this.localFunctions = null;
        if (this.functions != null) {
            this.functions.dispose();
        }
        this.functions = null;
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = null;
        LogManager.logDebug((String)"End dispose:", (Object)((Object)this));
    }
}

