/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.ide.structures;

import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDEPlugin;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.StringOutputStream;
import org.eclipse.linuxtools.profiling.launch.IRemoteCommandLauncher;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;
import org.eclipse.linuxtools.systemtap.ui.logging.LogManager;
import org.eclipse.linuxtools.systemtap.ui.structures.TreeDefinitionNode;
import org.eclipse.linuxtools.systemtap.ui.structures.TreeNode;
import org.eclipse.linuxtools.systemtap.ui.structures.listeners.IUpdateListener;

public class TapsetParser
implements Runnable {
    private boolean stopped = true;
    private boolean disposed = true;
    private boolean successfulFinish = false;
    private ArrayList<IUpdateListener> listeners;
    private TreeNode functions;
    private TreeNode probes;
    private String[] tapsets;

    public TapsetParser(String[] tapsets) {
        this.tapsets = tapsets;
        this.listeners = new ArrayList();
    }

    protected void init() {
        this.disposed = false;
        this.functions = new TreeNode((Object)"", false);
        this.probes = new TreeNode((Object)"", false);
        String s = this.readPass1(null);
        this.parseLevel1(s);
        this.cleanupTrees();
    }

    public void start() {
        this.stopped = false;
        this.init();
        Thread t = new Thread((Runnable)this, "TapsetParser");
        t.start();
    }

    public synchronized void stop() {
        this.stopped = true;
    }

    public boolean isRunning() {
        return !this.stopped;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public synchronized TreeNode getFunctions() {
        return this.functions;
    }

    public synchronized TreeNode getProbes() {
        return this.probes;
    }

    public boolean isFinishSuccessful() {
        return this.successfulFinish;
    }

    public void run() {
        this.runPass2Functions();
        this.fireUpdateEvent();
        this.runPass2Probes();
        this.fireUpdateEvent();
        this.stop();
        this.successfulFinish = true;
        this.fireUpdateEvent();
    }

    public void addListener(IUpdateListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(IUpdateListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    private void fireUpdateEvent() {
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).handleUpdateEvent();
            ++i;
        }
    }

    protected String runStap(String[] options, String probe, int level) {
        int i;
        String[] args = null;
        int size = 4;
        if (this.tapsets != null && this.tapsets.length > 0 && this.tapsets[0].trim().length() > 0) {
            size += this.tapsets.length << 1;
        }
        if (options != null && options.length > 0 && options[0].trim().length() > 0) {
            size += options.length;
        }
        args = new String[size];
        args[0] = "";
        args[1] = "-p" + level;
        args[size - 2] = "-e";
        args[size - 1] = probe;
        if (this.tapsets != null && this.tapsets.length > 0 && this.tapsets[0].trim().length() > 0) {
            i = 0;
            while (i < this.tapsets.length) {
                args[2 + (i << 1)] = "-I";
                args[3 + (i << 1)] = this.tapsets[i];
                ++i;
            }
        }
        if (options != null && options.length > 0 && options[0].trim().length() > 0) {
            i = 0;
            while (i < options.length) {
                args[args.length - options.length - 2 + i] = options[i];
                ++i;
            }
        }
        StringOutputStream str = new StringOutputStream();
        StringOutputStream strErr = new StringOutputStream();
        try {
            URI uri = IDEPlugin.getDefault().getPreferenceStore().getBoolean("RemoteProbes") ? IDEPlugin.getDefault().createRemoteUri(null) : new URI(Path.ROOT.toOSString());
            IRemoteCommandLauncher launcher = RemoteProxyManager.getInstance().getLauncher(uri);
            launcher.execute((IPath)new Path("stap"), args, null, null, null);
            launcher.waitAndRead((OutputStream)str, (OutputStream)strErr, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (URISyntaxException e) {
            LogManager.logCritical((String)("URISyntaxException runStap: " + e.getMessage()), (Object)this);
        }
        catch (CoreException e) {
            LogManager.logCritical((String)("CoreException runStap: " + e.getMessage()), (Object)this);
        }
        return str.toString();
    }

    private String readPass1(String script) {
        String[] options;
        if (script == null) {
            script = "probe begin{}";
            options = new String[]{"-v"};
        } else {
            options = null;
        }
        return this.runStap(options, script, 1);
    }

    private void parseLevel1(String s) {
        String prev = null;
        String prev2 = null;
        StringBuilder token = new StringBuilder("");
        boolean isProbe = false;
        int i = 0;
        while (i < s.length()) {
            char currChar = s.charAt(i);
            if (!Character.isWhitespace(currChar) && '}' != currChar && '{' != currChar) {
                token.append(currChar);
            } else if (token.length() > 0) {
                prev2 = prev;
                prev = token.toString();
                token.delete(0, token.length());
            }
            if (1 == token.length()) {
                TreeNode parent;
                if ("probe".equals(prev2) && "=".equals(token.toString())) {
                    do {
                        currChar = s.charAt(++i);
                        token.append(currChar);
                    } while ('{' != currChar && i < s.length());
                    parent = this.probes.getChildAt(this.probes.getChildCount() - 1);
                    parent.add((TreeNode)new TreeDefinitionNode((Object)("probe " + token.toString().substring(2, token.length() - 1)), prev, parent.getData().toString(), true));
                    isProbe = true;
                } else if ("function".equals(prev2)) {
                    do {
                        currChar = s.charAt(++i);
                        token.append(currChar);
                    } while (')' != currChar && i < s.length());
                    parent = this.functions.getChildAt(this.functions.getChildCount() - 1);
                    parent.add((TreeNode)new TreeDefinitionNode((Object)(String.valueOf(prev) + token.toString()), String.valueOf(prev) + token.toString(), parent.getData().toString(), true));
                    isProbe = false;
                } else if ("file".equals(prev2)) {
                    if (prev.lastIndexOf(47) > 0) {
                        prev2 = prev.substring(prev.lastIndexOf(47) + 1);
                    }
                    this.functions.add(new TreeNode((Object)prev, prev2, false));
                    this.probes.add(new TreeNode((Object)prev, prev2, false));
                    isProbe = false;
                }
            } else if (prev2 != null && prev2.length() > 2 && token.length() > 2 && isProbe && '(' == prev2.charAt(0) && ')' == prev2.charAt(prev2.length() - 1) && '(' == token.charAt(0) && ')' == token.charAt(token.length() - 1) && "=".equals(prev)) {
                TreeNode item = this.probes.getChildAt(this.probes.getChildCount() - 1);
                prev2 = prev2.substring(1, prev2.length() - 1);
                TreeNode child = item.getChildAt(item.getChildCount() - 1);
                boolean contains = false;
                int z = 0;
                while (z < child.getChildCount()) {
                    if (child.getChildAt(z).toString().equals(prev2)) {
                        contains = true;
                        break;
                    }
                    ++z;
                }
                if (!contains) {
                    child.add(new TreeNode((Object)(String.valueOf(prev2) + ":unknown"), prev2, false));
                }
                prev2 = null;
            }
            ++i;
        }
    }

    private void runPass2Functions() {
        int l = 0;
        String[] parameters = new String[]{};
        StringBuilder probe = new StringBuilder("");
        ArrayList<String> functionNames = new ArrayList<String>();
        int i = 0;
        while (i < this.functions.getChildCount()) {
            TreeNode child = this.functions.getChildAt(i);
            int j = 0;
            while (j < child.getChildCount()) {
                probe.delete(0, probe.length());
                String function = child.getChildAt(j).toString();
                probe.append(function.substring(0, function.indexOf("(") + 1));
                function = function.substring(function.indexOf("(") + 1, function.indexOf(")"));
                parameters = function.split(",");
                if (parameters[0].length() > 0) {
                    int k = 0;
                    while (k < parameters.length) {
                        if (k > 0) {
                            probe.append(",");
                        }
                        probe.append(String.valueOf(parameters[k]) + l++);
                        ++k;
                    }
                }
                probe.append(")\n");
                functionNames.add(probe.toString());
                ++j;
            }
            ++i;
        }
        parameters = functionNames.toArray(parameters);
        this.runPass2FunctionSet(parameters, 0, parameters.length - 1);
    }

    private void runPass2FunctionSet(String[] funcs, int low, int high) {
        if (low == high) {
            return;
        }
        if (this.stopped) {
            return;
        }
        StringBuilder functionStr = new StringBuilder("probe begin{\n");
        int i = low;
        while (i < high) {
            functionStr.append(funcs[i]);
            ++i;
        }
        functionStr.append("}\n");
        String result = this.runStap(new String[]{"-u"}, functionStr.toString(), 2);
        if (result.trim().length() > 0) {
            this.parsePass2Functions(result);
        } else if (low + 1 != high) {
            this.runPass2FunctionSet(funcs, low, low + (high - low >> 1));
            this.runPass2FunctionSet(funcs, low + (high - low >> 1), high);
        }
    }

    private void runPass2Probes() {
        int i = 0;
        while (i < this.probes.getChildCount()) {
            if (this.stopped) {
                return;
            }
            TreeNode temp = this.probes.getChildAt(i);
            this.runPass2ProbeSet(temp, 0, temp.getChildCount());
            ++i;
        }
    }

    private void runPass2ProbeSet(TreeNode probe, int low, int high) {
        if (low == high) {
            return;
        }
        StringBuilder probeStr = new StringBuilder("");
        int i = low;
        while (i < high) {
            TreeNode temp = probe.getChildAt(i);
            if (temp.getData().toString().startsWith("probe")) {
                probeStr.append("\nprobe " + temp.toString() + "{}");
            } else {
                this.runPass2ProbeSet(temp, 0, temp.getChildCount());
            }
            ++i;
        }
        String result = this.runStap(new String[]{"-u"}, probeStr.toString(), 2);
        if (result.trim().length() > 0) {
            boolean success = this.parsePass2Probes(result, probe);
            if (!success) {
                this.runPass2ProbeSet(probe, low, low + (high - low >> 1));
                this.runPass2ProbeSet(probe, low + (high - low >> 1), high);
            }
        } else if (low + 1 != high) {
            this.runPass2ProbeSet(probe, low, low + (high - low >> 1));
            this.runPass2ProbeSet(probe, low + (high - low >> 1), high);
        }
    }

    protected void cleanupTrees() {
        int i = this.functions.getChildCount() - 1;
        while (i >= 0) {
            if (this.functions.getChildAt(i).getChildCount() == 0) {
                this.functions.remove(i);
            }
            if (this.probes.getChildAt(i).getChildCount() == 0) {
                this.probes.remove(i);
            }
            --i;
        }
        this.functions.sortTree();
        this.probes.sortTree();
        this.formatProbes();
    }

    private void formatProbes() {
        TreeNode probes2 = new TreeNode((Object)"", false);
        int i = 0;
        while (i < this.probes.getChildCount()) {
            TreeNode fileNode = this.probes.getChildAt(i);
            int j = 0;
            while (j < fileNode.getChildCount()) {
                TreeNode probe = fileNode.getChildAt(j);
                String directory = probe.toString();
                if (directory.endsWith(".return") || directory.endsWith(".entry")) {
                    directory = directory.substring(0, directory.lastIndexOf(46));
                }
                String[] folders = directory.split("\\.");
                TreeNode probeGroup = probes2;
                int k = 0;
                while (k < folders.length - 1) {
                    TreeNode probeFolder;
                    boolean added = false;
                    int l = 0;
                    while (l < probeGroup.getChildCount()) {
                        probeFolder = probeGroup.getChildAt(l);
                        if (probeFolder.toString().equals(folders[k])) {
                            probeGroup = probeFolder;
                            added = true;
                            break;
                        }
                        ++l;
                    }
                    if (!added) {
                        probeFolder = new TreeNode((Object)folders[k], false);
                        probeGroup.add(probeFolder);
                        probeGroup = probeFolder;
                    }
                    ++k;
                }
                probeGroup.add(probe);
                ++j;
            }
            ++i;
        }
        this.probes = probes2;
        this.probes.sortTree();
    }

    private void parsePass2Functions(String s) {
        String[] functionLines = new String[]{};
        if (s.contains("# functions") && s.contains("# probes")) {
            functionLines = s.substring(s.indexOf("# functions"), s.indexOf("# probes")).split("\n");
        }
        int i = 0;
        while (i < functionLines.length) {
            int j = 0;
            while (j < this.functions.getChildCount()) {
                TreeNode child = this.functions.getChildAt(j);
                int k = 0;
                while (k < child.getChildCount()) {
                    TreeNode child2 = child.getChildAt(k);
                    String childString = child2.toString();
                    if (childString.indexOf("(") != -1 && functionLines[i].startsWith(String.valueOf(childString.substring(0, childString.indexOf("(")).trim()) + ":")) {
                        child2.setData((Object)functionLines[i]);
                        break;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private boolean parsePass2Probes(String s, TreeNode probeSet) {
        LogManager.logDebug((String)("Start parseLevel2Probes: probeSet-" + probeSet), (Object)this);
        TreeNode tree = new TreeNode((Object)"", false);
        TreeNode probe = null;
        String[] probeLines = null;
        boolean variables = false;
        if (s.contains("# probes")) {
            probeLines = s.substring(s.indexOf("# probes")).split("\n");
        }
        if (probeLines == null) {
            return false;
        }
        int i = 0;
        while (i < probeLines.length) {
            String line = probeLines[i].trim();
            if (line.startsWith("kernel.")) {
                probe = new TreeNode((Object)line, false);
                tree.add(probe);
                variables = false;
            } else if (line.equals("# locals") && probe != null) {
                variables = true;
            } else if (probe != null && variables) {
                if (line.contains(":")) {
                    probe.add(new TreeNode((Object)line, line.substring(0, line.lastIndexOf(":")).trim(), false));
                }
            } else {
                probe = null;
            }
            ++i;
        }
        i = 0;
        while (i < probeSet.getChildCount()) {
            int j = 0;
            while (j < tree.getChildCount()) {
                TreeNode two;
                TreeNode one = probeSet.getChildAt(i);
                if (this.probesMatch(one, two = tree.getChildAt(j))) {
                    int l = 0;
                    while (l < two.getChildCount()) {
                        boolean matched = false;
                        TreeNode twoC = two.getChildAt(l);
                        int k = 0;
                        while (k < one.getChildCount()) {
                            TreeNode oneC = one.getChildAt(k);
                            if (oneC.getData().toString().substring(0, oneC.getData().toString().indexOf(":")).equals(twoC.getData().toString().substring(0, twoC.getData().toString().indexOf(":")))) {
                                oneC.setData(twoC.getData());
                                matched = true;
                            }
                            ++k;
                        }
                        if (!matched) {
                            one.add(new TreeNode(twoC.getData(), twoC.toString(), false));
                        }
                        ++l;
                    }
                }
                ++j;
            }
            ++i;
        }
        tree.dispose();
        tree = null;
        return true;
    }

    private boolean probesMatch(TreeNode one, TreeNode two) {
        try {
            String valOneA = one.getData().toString();
            String valTwoA = two.getData().toString();
            String valOneB = "";
            String valTwoB = valTwoA.substring(valTwoA.indexOf("\"") + 1, valTwoA.indexOf("@"));
            if (valOneA.contains("\"")) {
                valOneB = valOneA.substring(valOneA.indexOf("\"") + 1);
            }
            if (valOneB.contains("\"")) {
                valOneB = valOneB.substring(0, valOneB.indexOf("\""));
            }
            if (valOneB.equals(valTwoB) && valOneA.contains(".return") == valTwoA.contains(".return")) {
                return true;
            }
        }
        catch (Exception e) {
            LogManager.logCritical((String)("Exception probesMatch: " + e.getMessage() + "\n" + one + "\n" + two), (Object)this);
        }
        return false;
    }

    public void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            this.functions.dispose();
            this.functions = null;
            this.probes.dispose();
            this.probes = null;
            this.tapsets = null;
            this.listeners.clear();
            this.listeners = null;
        }
    }
}

