/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd;

import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.util.SDMessages;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DrawableToolTip
implements PaintListener {
    protected Composite fParent = null;
    protected Shell fToolTipShell = null;
    protected TmfTimeRange fMinMaxRange;
    protected ITmfTimestamp fCurrentValue;
    private static int fHorMargin = 10;
    private static int fVertMargin = 10;
    private static int fTextScaleMargin = 20;
    private static int fScaleLength = 100;
    protected String fMessage;
    protected Color[] fColors;

    public DrawableToolTip(Composite parent) {
        this.fParent = parent;
        this.fToolTipShell = new Shell(this.fParent.getShell(), 16384);
        this.fToolTipShell.setLayout((Layout)new RowLayout());
        this.fToolTipShell.setBackground(Display.getDefault().getSystemColor(29));
        this.fToolTipShell.addPaintListener((PaintListener)this);
        this.fToolTipShell.setSize(200, 50);
        this.fColors = new Color[10];
        this.fColors[0] = new Color((Device)Display.getDefault(), 255, 229, 229);
        this.fColors[1] = new Color((Device)Display.getDefault(), 255, 204, 204);
        this.fColors[2] = new Color((Device)Display.getDefault(), 255, 178, 178);
        this.fColors[3] = new Color((Device)Display.getDefault(), 255, 153, 153);
        this.fColors[4] = new Color((Device)Display.getDefault(), 255, 127, 127);
        this.fColors[5] = new Color((Device)Display.getDefault(), 255, 102, 102);
        this.fColors[6] = new Color((Device)Display.getDefault(), 255, 76, 76);
        this.fColors[7] = new Color((Device)Display.getDefault(), 255, 51, 51);
        this.fColors[8] = new Color((Device)Display.getDefault(), 255, 25, 25);
        this.fColors[9] = new Color((Device)Display.getDefault(), 255, 0, 0);
    }

    public String getText() {
        return this.fMessage;
    }

    public String getAccessibleText() {
        return this.fCurrentValue.toString();
    }

    protected static int getHorizontalMargin() {
        return fHorMargin;
    }

    protected static void setHorizontalMargin(int margin) {
        fHorMargin = margin;
    }

    protected static int getVerticalMargin() {
        return fVertMargin;
    }

    protected static void setVerticalMargin(int margin) {
        fVertMargin = margin;
    }

    protected static int getTextScaleMargin() {
        return fTextScaleMargin;
    }

    protected static void setTestScaleMargin(int textScaleMargin) {
        fTextScaleMargin = textScaleMargin;
    }

    protected static int getScaleLength() {
        return fScaleLength;
    }

    protected static void setScaleLength(int scaleLength) {
        fScaleLength = scaleLength;
    }

    public void showToolTip(ITmfTimestamp value, ITmfTimestamp min, ITmfTimestamp max) {
        this.fMinMaxRange = new TmfTimeRange(min.clone(), max.clone());
        this.fCurrentValue = value.clone();
        int w = this.fToolTipShell.getBounds().width;
        int h = this.fToolTipShell.getBounds().height;
        Point hr = Display.getDefault().getCursorLocation();
        this.fToolTipShell.setBounds(hr.x, hr.y + 26, w, h);
        this.fToolTipShell.setVisible(true);
    }

    public void hideToolTip() {
        this.fToolTipShell.setVisible(false);
    }

    public void dispose() {
        int i = 0;
        while (i < this.fColors.length) {
            this.fColors[i].dispose();
            ++i;
        }
    }

    public void paintControl(PaintEvent event) {
        this.fMessage = String.valueOf(SDMessages._138) + " " + this.fCurrentValue.toString();
        Point size = event.gc.textExtent(this.fMessage);
        if (size.x < fScaleLength) {
            size.x = fScaleLength;
        }
        event.gc.drawText(this.fMessage, fHorMargin, fVertMargin, true);
        event.gc.drawLine(fHorMargin, fVertMargin + fTextScaleMargin + size.y, fHorMargin + fScaleLength, fVertMargin + fTextScaleMargin + size.y);
        int step = fScaleLength / 10;
        ITmfTimestamp minMaxdelta = this.fMinMaxRange.getEndTime().getDelta(this.fMinMaxRange.getStartTime());
        double gr = (double)minMaxdelta.getValue() / 10.0;
        ITmfTimestamp delta = this.fCurrentValue.getDelta(this.fMinMaxRange.getStartTime());
        long absDelta = Math.abs(delta.getValue());
        int colIndex = 0;
        if (gr != 0.0) {
            colIndex = Math.round((float)((double)absDelta / gr));
            if (colIndex > this.fColors.length) {
                colIndex = this.fColors.length;
            } else if (colIndex <= 1) {
                colIndex = 1;
            }
        } else {
            colIndex = 1;
        }
        int i = 0;
        while (i <= 10) {
            if (i < 10) {
                event.gc.setBackground(this.fColors[i]);
            }
            if (i < colIndex && i < 10) {
                event.gc.fillRectangle(fHorMargin + i * step, fVertMargin + fTextScaleMargin + size.y - 5, step, 11);
            }
            if (i == 0) {
                event.gc.drawText(SDMessages._56, fHorMargin, size.y + 2 * fVertMargin + fTextScaleMargin, true);
            }
            if (i == 0) {
                int len = event.gc.textExtent((String)SDMessages._55).x;
                event.gc.drawText(SDMessages._55, fHorMargin + fScaleLength - len + 1, size.y + 2 * fVertMargin + fTextScaleMargin, true);
            }
            int lineWidth = 10;
            if (i == 0 || i == 10) {
                lineWidth = 14;
            }
            event.gc.drawLine(fHorMargin + i * step, fVertMargin + fTextScaleMargin + size.y - lineWidth / 2, fHorMargin + i * step, fVertMargin + fTextScaleMargin + size.y + lineWidth / 2);
            ++i;
        }
        this.fToolTipShell.setSize(size.x + 2 * fHorMargin + 2, 2 * size.y + 3 * fVertMargin + fTextScaleMargin);
    }
}

