/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.editing;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.eclipse.m2e.core.lifecyclemapping.model.PluginExecutionAction;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.eclipse.m2e.core.ui.internal.editing.PomHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LifecycleMappingOperation
implements PomEdits.Operation {
    private static final Logger log = LoggerFactory.getLogger(LifecycleMappingOperation.class);
    private static final String LIFECYCLE_PLUGIN_VERSION = "1.0.0";
    private static final String LIFECYCLE_PLUGIN_ARTIFACTID = "lifecycle-mapping";
    private static final String LIFECYCLE_PLUGIN_GROUPID = "org.eclipse.m2e";
    private String version;
    private String groupId;
    private String artifactId;
    private PluginExecutionAction action;
    private String[] goals;
    private boolean createAtTopLevel = false;

    public LifecycleMappingOperation(String pluginGroupId, String pluginArtifactId, String pluginVersion, PluginExecutionAction action, String[] goals) {
        this(pluginGroupId, pluginArtifactId, pluginVersion, action, goals, false);
    }

    public LifecycleMappingOperation(String pluginGroupId, String pluginArtifactId, String pluginVersion, PluginExecutionAction action, String[] goals, boolean createAtTopLevel) {
        this.artifactId = pluginArtifactId;
        this.groupId = pluginGroupId;
        this.version = pluginVersion;
        assert (!PluginExecutionAction.configurator.equals((Object)action));
        this.action = action;
        this.goals = goals;
        this.createAtTopLevel = createAtTopLevel;
    }

    public void process(Document document) {
        Element pluginExecutions;
        Element root = document.getDocumentElement();
        if (this.createAtTopLevel) {
            if (root == null) {
                root = document.createElement("lifecycleMappingMetadata");
                document.appendChild(root);
            }
            pluginExecutions = PomEdits.getChild(root, "pluginExecutions");
        } else {
            Element managedPlugins = PomEdits.getChild(root, "build", "pluginManagement", "plugins");
            Element lifecyclePlugin = PomEdits.findChild(managedPlugins, "plugin", PomEdits.childEquals("groupId", LIFECYCLE_PLUGIN_GROUPID), PomEdits.childEquals("artifactId", LIFECYCLE_PLUGIN_ARTIFACTID));
            if (lifecyclePlugin == null) {
                lifecyclePlugin = PomHelper.createPlugin(managedPlugins, LIFECYCLE_PLUGIN_GROUPID, LIFECYCLE_PLUGIN_ARTIFACTID, LIFECYCLE_PLUGIN_VERSION);
                Comment comment = document.createComment("This plugin's configuration is used to store Eclipse m2e settings only. It has no influence on the Maven build itself.");
                managedPlugins.insertBefore(comment, lifecyclePlugin);
                PomEdits.format(comment);
            }
            pluginExecutions = PomEdits.getChild(lifecyclePlugin, "configuration", "lifecycleMappingMetadata", "pluginExecutions");
        }
        Element execution = null;
        for (Element exec : PomEdits.findChilds(pluginExecutions, "pluginExecution")) {
            Element filter = PomEdits.findChild(exec, "pluginExecutionFilter", PomEdits.childEquals("groupId", this.groupId), PomEdits.childEquals("artifactId", this.artifactId));
            Element actionEl = PomEdits.findChild(PomEdits.findChild(exec, "action"), this.action.toString());
            if (filter == null || actionEl == null) continue;
            String versionRange = PomEdits.getTextValue(PomEdits.getChild(filter, "versionRange"));
            if (versionRange != null) {
                try {
                    VersionRange range = VersionRange.createFromVersionSpec((String)versionRange);
                    if (!range.containsVersion((ArtifactVersion)new DefaultArtifactVersion(this.version))) {
                        Element rangeEl = PomEdits.findChild(filter, "versionRange");
                        PomEdits.setText(rangeEl, "[" + this.version + ",)");
                    }
                }
                catch (InvalidVersionSpecificationException e) {
                    log.error("Failed to parse version range:" + versionRange, (Throwable)e);
                }
            }
            execution = exec;
            break;
        }
        if (execution == null) {
            execution = this.createPluginExecution(document, pluginExecutions);
        }
        Element goalsEl = PomEdits.getChild(execution, "pluginExecutionFilter", "goals");
        ArrayList<String> toAddGoals = new ArrayList<String>(Arrays.asList(this.goals));
        for (Element existingGoal : PomEdits.findChilds(goalsEl, "goal")) {
            String glValue = PomEdits.getTextValue(existingGoal);
            if (glValue == null || !toAddGoals.contains(glValue)) continue;
            toAddGoals.remove(glValue);
        }
        if (toAddGoals.size() > 0) {
            for (String goal : toAddGoals) {
                PomEdits.format(PomEdits.createElementWithText(goalsEl, "goal", goal));
            }
        }
    }

    private Element createPluginExecution(Document document, Element parent) {
        Element exec = document.createElement("pluginExecution");
        parent.appendChild(exec);
        Element filter = document.createElement("pluginExecutionFilter");
        exec.appendChild(filter);
        PomEdits.createElementWithText(filter, "groupId", this.groupId);
        PomEdits.createElementWithText(filter, "artifactId", this.artifactId);
        PomEdits.createElementWithText(filter, "versionRange", "[" + this.version + ",)");
        Element actionEl = document.createElement("action");
        exec.appendChild(actionEl);
        Element actionEl2 = document.createElement(this.action.toString());
        actionEl.appendChild(actionEl2);
        if (PluginExecutionAction.execute.equals((Object)this.action)) {
            actionEl2.appendChild(document.createComment("use <runOnIncremental>false</runOnIncremental>to only execute the mojo during full/clean build"));
        }
        PomEdits.format(exec);
        return exec;
    }
}

