/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project.conversion;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Model;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2e.core.project.conversion.AbstractProjectConversionParticipant;
import org.eclipse.m2e.core.project.conversion.IProjectConversionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectConversionManager
implements IProjectConversionManager {
    private static final String CONVERSION_PARTICIPANTS_EXTENSION_POINT = "org.eclipse.m2e.core.projectConversionParticipants";
    private static final Logger log = LoggerFactory.getLogger(ProjectConversionManager.class);

    private static List<AbstractProjectConversionParticipant> lookupConversionParticipants(IProject project) {
        ArrayList<AbstractProjectConversionParticipant> participants = new ArrayList<AbstractProjectConversionParticipant>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint conversionExtensionPoint = registry.getExtensionPoint(CONVERSION_PARTICIPANTS_EXTENSION_POINT);
        if (conversionExtensionPoint != null) {
            IExtension[] archetypesExtensions;
            IExtension[] iExtensionArray = archetypesExtensions = conversionExtensionPoint.getExtensions();
            int n = archetypesExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    try {
                        if (project.hasNature(element.getAttribute("nature"))) {
                            participants.add((AbstractProjectConversionParticipant)element.createExecutableExtension("class"));
                        }
                    }
                    catch (CoreException ex) {
                        log.debug("Can not load IProjectConversionParticipant", (Throwable)ex);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return participants;
    }

    @Override
    public void convert(IProject project, Model model, IProgressMonitor monitor) throws CoreException {
        if (model == null) {
            return;
        }
        List<AbstractProjectConversionParticipant> participants = this.getConversionParticipants(project);
        if (participants != null) {
            for (AbstractProjectConversionParticipant participant : participants) {
                participant.convert(project, model, monitor);
            }
        }
    }

    @Override
    public List<AbstractProjectConversionParticipant> getConversionParticipants(IProject project) throws CoreException {
        List<AbstractProjectConversionParticipant> allParticipants = ProjectConversionManager.lookupConversionParticipants(project);
        ArrayList<AbstractProjectConversionParticipant> participants = new ArrayList<AbstractProjectConversionParticipant>();
        if (allParticipants != null) {
            for (AbstractProjectConversionParticipant participant : allParticipants) {
                if (!participant.accept(project)) continue;
                participants.add(participant);
            }
        }
        return participants;
    }
}

