/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project.registry;

import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.internal.project.registry.Capability;
import org.eclipse.m2e.core.internal.project.registry.MavenCapability;
import org.eclipse.m2e.core.internal.project.registry.RequiredCapability;

public class MavenRequiredCapability
extends RequiredCapability {
    private static final long serialVersionUID = 3254716937353332553L;
    private final String versionRange;
    private final String scope;
    private final boolean optional;

    private MavenRequiredCapability(String namespace, String id, String versionRange, String scope, boolean optional) {
        super(namespace, id);
        if (versionRange == null) {
            throw new NullPointerException();
        }
        this.versionRange = versionRange;
        this.scope = scope;
        this.optional = optional;
    }

    public static MavenRequiredCapability createMavenArtifact(ArtifactKey key, String scope, boolean optional) {
        return new MavenRequiredCapability("maven-artifact", MavenCapability.getId(key), key.getVersion(), scope, optional);
    }

    public static MavenRequiredCapability createMavenParent(ArtifactKey key) {
        return new MavenRequiredCapability("maven-parent", MavenCapability.getId(key), key.getVersion(), null, false);
    }

    public boolean isPotentialMatch(Capability capability) {
        if (capability instanceof MavenCapability && this.getVersionlessKey().equals(capability.getVersionlessKey())) {
            try {
                DefaultArtifactVersion version = new DefaultArtifactVersion(((MavenCapability)capability).getVersion());
                VersionRange range = VersionRange.createFromVersionSpec((String)this.versionRange);
                return range.containsVersion((ArtifactVersion)version);
            }
            catch (InvalidVersionSpecificationException invalidVersionSpecificationException) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getVersionlessKey().toString());
        if (this.scope != null) {
            sb.append(':').append(this.scope);
        }
        sb.append('/').append(this.versionRange);
        if (this.optional) {
            sb.append("(optional)");
        }
        return sb.toString();
    }

    public int hashCode() {
        int hash = this.getVersionlessKey().hashCode();
        hash = hash * 17 + this.versionRange.hashCode();
        hash = hash * 17 + (this.scope != null ? this.scope.hashCode() : 0);
        hash = hash * 17 + (this.optional ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MavenRequiredCapability)) {
            return false;
        }
        MavenRequiredCapability other = (MavenRequiredCapability)obj;
        return this.getVersionlessKey().equals(other.getVersionlessKey()) && this.versionRange.equals(other.versionRange) && MavenRequiredCapability.eq(this.scope, other.scope) && this.optional == other.optional;
    }
}

