/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.repository;

import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.eclipse.core.runtime.IPath;
import org.eclipse.m2e.core.repository.IRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryInfo
implements IRepository {
    private final String id;
    private final String repositoryUrl;
    private final File basedir;
    private final int scope;
    private final AuthenticationInfo authInfo;
    private String uid;
    private String mirrorId;
    private String mirrorOf;
    private Set<IPath> projects = new HashSet<IPath>();

    public RepositoryInfo(String id, String repositoryUrl, int scope, AuthenticationInfo authInfo) {
        this(id, repositoryUrl, RepositoryInfo.getBasedir(repositoryUrl), scope, authInfo);
    }

    public RepositoryInfo(String id, String repositoryUrl, File basedir, int scope, AuthenticationInfo authInfo) {
        this.id = id;
        this.repositoryUrl = repositoryUrl;
        this.scope = scope;
        this.authInfo = authInfo;
        this.basedir = basedir;
    }

    @Override
    public AuthenticationInfo getAuthenticationInfo() {
        return this.authInfo;
    }

    @Override
    public String getUrl() {
        return this.repositoryUrl;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getMirrorId() {
        return this.mirrorId;
    }

    @Override
    public String getMirrorOf() {
        return this.mirrorOf;
    }

    public void setMirrorOf(String mirrorOf) {
        this.mirrorOf = mirrorOf;
    }

    public void setMirrorId(String mirrorId) {
        this.mirrorId = mirrorId;
    }

    public Set<IPath> getProjects() {
        return this.projects;
    }

    public void addProject(IPath project) {
        if (this.isScope(16)) {
            this.projects.add(project);
        }
    }

    public void removeProject(IPath project) {
        this.projects.remove(project);
    }

    @Override
    public String getUid() {
        if (this.uid == null) {
            this.uid = RepositoryInfo.getUid(this.id, this.repositoryUrl, this.authInfo != null ? this.authInfo.getUserName() : null);
        }
        return this.uid;
    }

    public static String getUid(String id, String repositoryUrl, String username) {
        String uid;
        StringBuilder sb = new StringBuilder();
        if (id != null) {
            sb.append(id);
        }
        sb.append('|').append(repositoryUrl);
        if (username != null) {
            sb.append('|').append(username);
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(sb.toString().getBytes());
            byte[] messageDigest = digest.digest();
            StringBuffer hexString = new StringBuffer();
            int i = 0;
            while (i < messageDigest.length) {
                String hex = Integer.toHexString(0xFF & messageDigest[i]);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
                ++i;
            }
            uid = hexString.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            uid = sb.toString();
            uid = uid.replace(':', '_').replace('/', '_').replace('|', '_');
        }
        return uid;
    }

    @Override
    public String getProtocol() {
        return RepositoryInfo.getProtocol(this.repositoryUrl);
    }

    public static String getProtocol(String repositoryUrl) {
        int pos = repositoryUrl.indexOf(":");
        if (pos == -1) {
            return "file";
        }
        return repositoryUrl.substring(0, pos).trim();
    }

    public static File getBasedir(String repositoryUrl) {
        if (RepositoryInfo.getProtocol(repositoryUrl).equalsIgnoreCase("file")) {
            MavenArtifactRepository trick = new MavenArtifactRepository();
            trick.setUrl(repositoryUrl);
            return new File(trick.getBasedir());
        }
        return null;
    }

    @Override
    public File getBasedir() {
        return this.basedir;
    }

    @Override
    public boolean isScope(int scope) {
        return (this.scope & scope) != 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.id != null) {
            sb.append(this.id).append('|');
        }
        sb.append(this.repositoryUrl);
        return sb.toString();
    }
}

